/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.part;

import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.util.ProjectionHelper;
import com.amadornes.rscircuits.util.UnlistedPropertyDyeColor;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.IRedstonePart;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.MultipartRedstoneHelper;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;

public class PartRedstoneWire
extends Multipart
implements ISlottedPart,
IRedstonePart.ISlottedRedstonePart {
    public static final IProperty<Boolean> FRONT = PropertyBool.func_177716_a((String)"front");
    public static final IProperty<Boolean> BACK = PropertyBool.func_177716_a((String)"back");
    public static final IProperty<Boolean> LEFT = PropertyBool.func_177716_a((String)"left");
    public static final IProperty<Boolean> RIGHT = PropertyBool.func_177716_a((String)"right");
    public static final IUnlistedProperty<EnumFacing> FACE = Properties.toUnlisted((IProperty)PropertyEnum.func_177709_a((String)"face", EnumFacing.class));
    public static final IUnlistedProperty<EnumDyeColor> COLOR = new UnlistedPropertyDyeColor();
    public static final IUnlistedProperty<Integer> POWER = Properties.toUnlisted((IProperty)PropertyInteger.func_177719_a((String)"power", (int)0, (int)255));
    public static final AxisAlignedBB[][][] BOXES = new AxisAlignedBB[2][6][5];
    private EnumFacing face;
    private EnumDyeColor color;
    private byte power = 0;
    private byte prevInput = 0;
    private int[] connections = new int[4];
    private boolean ignoreUpdates = false;
    private boolean outputPower = true;

    private static AxisAlignedBB[] genBoxes(double r, double h) {
        AxisAlignedBB[] boxes = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.5 - r, 0.5 - r, h, 0.5 + r), new AxisAlignedBB(0.5 - r, 0.0, 0.0, 0.5 + r, h, 0.5 - r), new AxisAlignedBB(0.5 + r, 0.0, 0.5 - r, 1.0, h, 0.5 + r), new AxisAlignedBB(0.5 - r, 0.0, 0.5 + r, 0.5 + r, h, 1.0), new AxisAlignedBB(0.5 - r, 0.0, 0.5 - r, 0.5 + r, h, 0.5 + r)};
        return boxes;
    }

    public PartRedstoneWire(EnumFacing face, EnumDyeColor color) {
        this.face = face;
        this.color = color;
    }

    public PartRedstoneWire() {
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(PartSlot.getFaceSlot((EnumFacing)this.face));
    }

    private byte calculateInput() {
        int power = 0;
        int i = 0;
        for (EnumFacing f : EnumFacing.field_82609_l) {
            IMultipartContainer imc;
            int con;
            if (f == this.face.func_176734_d() || f == this.face) continue;
            if ((con = this.connections[i++]) == 1) {
                IBlockState state = this.getWorld().func_180495_p(this.getPos().func_177972_a(f));
                if (state.func_177230_c() == Blocks.field_150488_af) {
                    power = Math.max(power, (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O));
                    continue;
                }
                power = Math.max(power, this.getWorld().func_175651_c(this.getPos().func_177972_a(f), f) * 17);
                continue;
            }
            if (con == 2) {
                ISlottedPart part = this.getContainer().getPartInSlot(PartSlot.getFaceSlot((EnumFacing)this.face));
                if (part instanceof PartRedstoneWire || !(part instanceof IRedstonePart)) continue;
                power = Math.max(power, ((IRedstonePart)part).getWeakSignal(this.face) * 17);
                continue;
            }
            if (con != 3 || (imc = MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)this.getPos().func_177972_a(f))) == null) continue;
            power = Math.max(power, MultipartRedstoneHelper.getWeakSignal((IMultipartContainer)imc, (EnumFacing)f.func_176734_d(), (EnumFacing)this.face) * 17);
        }
        return (byte)power;
    }

    public boolean canConnectRedstone(EnumFacing side) {
        if (this.face == EnumFacing.DOWN) {
            return side != this.face && side != this.face.func_176734_d();
        }
        return false;
    }

    public int getWeakSignal(EnumFacing side) {
        return this.outputPower && this.canConnectRedstone(side) ? (this.power & 0xFF) / 17 : 0;
    }

    public int getStrongSignal(EnumFacing side) {
        return this.outputPower && side == this.face ? (this.power & 0xFF) / 17 : 0;
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        AxisAlignedBB[] boxes = BOXES[this.color == null ? 0 : 1][this.face.ordinal()];
        list.add(boxes[4]);
        switch (this.face) {
            case DOWN: {
                if (this.connections[0] != 0) {
                    list.add(boxes[1]);
                }
                if (this.connections[1] != 0) {
                    list.add(boxes[3]);
                }
                if (this.connections[2] != 0) {
                    list.add(boxes[0]);
                }
                if (this.connections[3] == 0) break;
                list.add(boxes[2]);
                break;
            }
            case UP: {
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                break;
            }
        }
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)MCMultiPartMod.multipart).add(new IProperty[]{FRONT, BACK, LEFT, RIGHT}).add(new IUnlistedProperty[]{FACE, COLOR, POWER}).build();
    }

    public IBlockState getActualState(IBlockState state) {
        switch (this.face) {
            case DOWN: {
                state = state.func_177226_a(FRONT, (Comparable)Boolean.valueOf(this.connections[2] != 0));
                state = state.func_177226_a(BACK, (Comparable)Boolean.valueOf(this.connections[3] != 0));
                state = state.func_177226_a(RIGHT, (Comparable)Boolean.valueOf(this.connections[0] != 0));
                state = state.func_177226_a(LEFT, (Comparable)Boolean.valueOf(this.connections[1] != 0));
                break;
            }
            case UP: {
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                break;
            }
        }
        return state;
    }

    public IBlockState getExtendedState(IBlockState state) {
        return ((IExtendedBlockState)state).withProperty(FACE, (Object)this.face).withProperty(COLOR, (Object)this.color).withProperty(POWER, (Object)(this.power & 0xFF));
    }

    public void onAdded() {
        this.onUpdate(true);
    }

    public void onNeighborBlockChange(Block block) {
        if (!this.getWorld().isSideSolid(this.getPos().func_177972_a(this.face), this.face.func_176734_d())) {
            this.harvest(null, null);
            return;
        }
        this.onUpdate(false);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("face", this.face.ordinal());
        tag.func_74768_a("color", this.color == null ? -1 : this.color.ordinal());
        tag.func_74774_a("power", this.power);
        tag.func_74783_a("connections", this.connections);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.face = EnumFacing.func_82600_a((int)tag.func_74762_e("face"));
        this.color = tag.func_74762_e("color") == -1 ? null : EnumDyeColor.values()[tag.func_74762_e("color")];
        this.power = tag.func_74771_c("power");
        if (tag.func_74764_b("connections")) {
            System.arraycopy(tag.func_74759_k("connections"), 0, this.connections, 0, 4);
        }
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        buf.func_179249_a((Enum)this.face);
        buf.writeInt(this.color == null ? -1 : this.color.ordinal());
        buf.writeByte((int)this.power);
        buf.func_186875_a(this.connections);
    }

    public void readUpdatePacket(PacketBuffer buf) {
        this.face = (EnumFacing)buf.func_179257_a(EnumFacing.class);
        int c = buf.readInt();
        this.color = c == -1 ? null : EnumDyeColor.values()[c];
        this.power = buf.readByte();
        System.arraycopy(buf.func_186863_b(), 0, this.connections, 0, 4);
    }

    private boolean isConnected(EnumFacing face) {
        return this.connections[face.func_176736_b()] != 0;
    }

    private void onUpdate(boolean joinWorld) {
        if (this.ignoreUpdates) {
            return;
        }
        boolean changeCon = false;
        int i = 0;
        for (EnumFacing f : EnumFacing.field_82609_l) {
            if (f == this.face || f == this.face.func_176734_d()) continue;
            int con = this.connections[i];
            this.connections[i] = this.getConnectionType(f);
            if (con == this.connections[i++]) continue;
            changeCon = true;
        }
        this.sendUpdatePacket();
        byte input = 0;
        if (!changeCon) {
            HashSet<PartRedstoneWire> wires = new HashSet<PartRedstoneWire>();
            this.propagate(wires, 1);
            wires.forEach(w -> {
                w.outputPower = false;
            });
            input = this.calculateInput();
            wires.forEach(w -> {
                w.outputPower = true;
            });
            wires.clear();
        }
        if (joinWorld || changeCon || this.prevInput != input) {
            this.prevInput = input;
            this.propagate();
        }
    }

    private void propagate() {
        HashSet<PartRedstoneWire> wires = new HashSet<PartRedstoneWire>();
        this.propagate(wires, 64);
        int power = 0;
        for (PartRedstoneWire wire : wires) {
            wire.outputPower = false;
        }
        for (PartRedstoneWire wire : wires) {
            byte in;
            wire.prevInput = in = wire.calculateInput();
            power = Math.max(power, in & 0xFF);
        }
        for (PartRedstoneWire wire : wires) {
            wire.outputPower = true;
            wire.ignoreUpdates = true;
        }
        for (PartRedstoneWire wire : wires) {
            wire.notifyNonWires((byte)power);
        }
        for (PartRedstoneWire wire : wires) {
            wire.ignoreUpdates = false;
        }
    }

    private void propagate(Set<PartRedstoneWire> wires, int maxLen) {
        if (wires.add(this) && maxLen >= 1) {
            int i = 0;
            for (EnumFacing f : EnumFacing.field_82609_l) {
                ISlottedPart p;
                IMultipartContainer c;
                int con;
                if (f == this.face || f == this.face.func_176734_d() || (con = this.connections[i++]) != 3 || (c = MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)this.getPos().func_177972_a(f))) == null || (p = c.getPartInSlot(PartSlot.getFaceSlot((EnumFacing)this.face))) == null || !(p instanceof PartRedstoneWire)) continue;
                ((PartRedstoneWire)p).propagate(wires, maxLen - 1);
            }
        }
    }

    private void notifyNonWires(byte power) {
        this.power = power;
        this.getWorld().func_175685_c(this.getPos(), (Block)MCMultiPartMod.multipart);
    }

    private int getConnectionType(EnumFacing face) {
        IMultipartContainer c = MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)this.getPos().func_177972_a(face));
        ISlottedPart part = this.getContainer().getPartInSlot(PartSlot.getFaceSlot((EnumFacing)face));
        if (part != null && part instanceof IRedstonePart) {
            return ((IRedstonePart)part).canConnectRedstone(this.face) ? 2 : 0;
        }
        if (c != null) {
            return MultipartRedstoneHelper.canConnectRedstone((IMultipartContainer)c, (EnumFacing)face.func_176734_d(), (EnumFacing)this.face) ? 3 : 0;
        }
        IBlockState state = this.getWorld().func_180495_p(this.getPos().func_177972_a(face));
        return state.func_177230_c().canConnectRedstone(state, (IBlockAccess)this.getWorld(), this.getPos().func_177972_a(face), face) ? 1 : 0;
    }

    public float getHardness(PartMOP hit) {
        return 0.25f;
    }

    public List<ItemStack> getDrops() {
        return Arrays.asList(new ItemStack(SCMItems.redwire));
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return new ItemStack(SCMItems.redwire);
    }

    static {
        AxisAlignedBB[] uninsulatedBoxes = PartRedstoneWire.genBoxes(0.0625, 0.125);
        AxisAlignedBB[] insulatedBoxes = PartRedstoneWire.genBoxes(0.125, 0.1875);
        for (EnumFacing f : EnumFacing.field_82609_l) {
            PartRedstoneWire.BOXES[0][f.ordinal()] = ProjectionHelper.rotateFaces(uninsulatedBoxes, f);
            PartRedstoneWire.BOXES[1][f.ordinal()] = ProjectionHelper.rotateFaces(insulatedBoxes, f);
        }
    }
}

