/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.network;

import com.amadornes.rscircuits.network.NetworkHandler;
import com.amadornes.rscircuits.network.Packet;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class PacketSplit
extends Packet<PacketSplit> {
    private static final ThreadLocal<Cache<UUID, Triple<Integer, Integer, Map<Integer, byte[]>>>> packetCache = ThreadLocal.withInitial(() -> CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build());
    private UUID id;
    private int discriminator;
    private int subID;
    private int totalPackets;
    private byte[] data;

    public PacketSplit(UUID id, int discriminator, int subID, int totalPackets, byte[] data) {
        this.id = id;
        this.discriminator = discriminator;
        this.subID = subID;
        this.totalPackets = totalPackets;
        this.data = data;
    }

    public PacketSplit() {
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        this.handleSingle(player, Side.CLIENT);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        this.handleSingle(player, Side.SERVER);
    }

    private void handleSingle(EntityPlayer player, Side side) {
        try {
            Triple pair = (Triple)packetCache.get().get((Object)this.id, () -> Triple.of((Object)this.discriminator, (Object)this.totalPackets, new HashMap()));
            ((Map)pair.getRight()).put(this.subID, this.data);
            if (((Integer)pair.getMiddle()).intValue() == ((Map)pair.getRight()).size()) {
                this.joinAndHandle((Map)pair.getRight(), (Integer)pair.getLeft(), player, side);
            }
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void joinAndHandle(Map<Integer, byte[]> value, int discriminator, EntityPlayer player, Side side) {
        ByteBuf buf = Unpooled.buffer();
        for (int i = 0; i < value.size(); ++i) {
            buf.writeBytes(value.get(i));
        }
        try {
            Packet packet = (Packet)((Class)((Pair)NetworkHandler.instance.discriminatorMap.inverse().get((Object)discriminator)).getKey()).newInstance();
            packet.fromBytes(buf);
            if (side == Side.CLIENT) {
                packet.handleClientSide(player);
            } else {
                packet.handleServerSide(player);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_179252_a(this.id);
        buf.writeInt(this.discriminator);
        buf.writeInt(this.subID);
        buf.writeInt(this.totalPackets);
        buf.func_179250_a(this.data);
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        this.id = buf.func_179253_g();
        this.discriminator = buf.readInt();
        this.subID = buf.readInt();
        this.totalPackets = buf.readInt();
        this.data = buf.func_179251_a();
    }

    public static List<PacketSplit> split(Packet<?> packet, Side side) {
        byte[] data;
        int lengthLeft;
        UUID id = UUID.randomUUID();
        int discriminator = (Integer)NetworkHandler.instance.discriminatorMap.get((Object)Pair.of(packet.getClass(), (Object)side));
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        packet.toBytes(buf);
        byte[] allData = buf.array();
        if (lengthLeft < 30000) {
            return null;
        }
        LinkedList<byte[]> dataArrays = new LinkedList<byte[]>();
        for (lengthLeft = allData.length; lengthLeft > 0; lengthLeft -= data.length) {
            data = new byte[Math.min(lengthLeft, 30000)];
            System.arraycopy(allData, allData.length - lengthLeft, data, 0, data.length);
            dataArrays.add(data);
        }
        ArrayList<PacketSplit> packets = new ArrayList<PacketSplit>();
        int i = 0;
        for (byte[] data2 : dataArrays) {
            packets.add(new PacketSplit(id, discriminator, i++, dataArrays.size(), data2));
        }
        return packets;
    }
}

