/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.wire;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.ComponentBase;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IRedstoneConductor;
import com.amadornes.rscircuits.api.component.IWirePassthroughComponent;
import com.amadornes.rscircuits.component.ComponentBaseInt;
import com.amadornes.rscircuits.component.wire.IRedstoneConductorContainer;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class SimpleRedstoneConductor<T extends ComponentBaseInt & IRedstoneConductorContainer> {
    private final T parent;
    private final ConnectionInfo[] neighbors = new ConnectionInfo[6];

    public SimpleRedstoneConductor(T parent) {
        this.parent = parent;
        for (EnumCircuitSide side : EnumCircuitSide.VALUES) {
            this.neighbors[side.ordinal()] = new ConnectionInfo(side);
        }
    }

    public IRedstoneConductor.IConnectionInfo[] getNeighbors() {
        return this.neighbors;
    }

    public ConnectionInfo[] getNeighborsRAW() {
        return this.neighbors;
    }

    public boolean connect(EnumCircuitSide side, IRedstoneConductor conductor, IRedstoneConductor.EnumConnectionType type, boolean simulated) {
        ConnectionInfo info = this.neighbors[side.ordinal()];
        if (!simulated) {
            info.type = type;
            info.neighbor = conductor;
            ((IRedstoneConductorContainer)this.parent).onConnect(side, conductor, type);
        }
        return true;
    }

    public void disconnect(EnumCircuitSide side) {
        ConnectionInfo info = this.neighbors[side.ordinal()];
        info.type = IRedstoneConductor.EnumConnectionType.NONE;
        info.neighbor = null;
        ((IRedstoneConductorContainer)this.parent).onDisconnect(side);
    }

    public void propagate(EnumDyeColor color) {
        if (!((IRedstoneConductor)this.parent).isBundled() && color != ((IRedstoneConductor)this.parent).getColor()) {
            return;
        }
        SetMultimap wires = MultimapBuilder.hashKeys().hashSetValues().build();
        LinkedHashSet scheduled = new LinkedHashSet();
        LinkedHashSet<Triple> scheduledNext = new LinkedHashSet<Triple>();
        scheduledNext.add(Triple.of(this.parent, this.parent, (Object)color));
        while (!scheduledNext.isEmpty()) {
            scheduled.addAll(scheduledNext);
            scheduledNext.clear();
            scheduled.forEach(arg_0 -> SimpleRedstoneConductor.lambda$propagate$0((Multimap)wires, scheduledNext, arg_0));
            scheduled.clear();
        }
        AtomicInteger power = new AtomicInteger(0);
        wires.asMap().forEach((w, cols) -> cols.forEach(c -> power.set(Math.max(power.get(), w.getInput((EnumDyeColor)c) & 0xFF))));
        byte pow = (byte)power.get();
        wires.asMap().forEach((w, cols) -> w.onPropagated((Set)cols, pow));
    }

    public void propagate(IRedstoneConductor from, EnumDyeColor color, Multimap<IRedstoneConductor, EnumDyeColor> wires, Set<Triple<IRedstoneConductor, IRedstoneConductor, EnumDyeColor>> scheduled) {
        if (((ComponentBase)this.parent).getPos() != null && !wires.containsEntry(this.parent, (Object)color)) {
            wires.put(this.parent, (Object)color);
            for (ConnectionInfo info : this.neighbors) {
                if (info.neighbor == null || info.type != IRedstoneConductor.EnumConnectionType.ANODE && info.type != IRedstoneConductor.EnumConnectionType.BIDIRECTIONAL || info.neighbor.getNeighbors()[info.side.ordinal() ^ 1].getType() == IRedstoneConductor.EnumConnectionType.CATHODE) continue;
                scheduled.add((Triple<IRedstoneConductor, IRedstoneConductor, EnumDyeColor>)Triple.of(this.parent, (Object)info.neighbor, (Object)(((IRedstoneConductor)this.parent).isBundled() ? color : ((IRedstoneConductor)this.parent).getColor())));
            }
        }
    }

    public void onPropagated(Set<EnumDyeColor> colors, byte power) {
        for (ConnectionInfo info : this.neighbors) {
            if (!info.getType().isOutput || info.neighbor != null && info.neighbor.getNeighbors()[info.side.ordinal() ^ 1].getType() != IRedstoneConductor.EnumConnectionType.CATHODE) continue;
            if (info.neighbor == null) {
                IRedstoneConductor wire = SimpleRedstoneConductor.getWireNeighbor(((ComponentBase)this.parent).getCircuit(), ((ComponentBase)this.parent).getPos(), info.side, ((IRedstoneConductorContainer)this.parent).getSlot());
                if (wire != null && wire.getNeighbors()[info.side.ordinal() ^ 1].getType() != IRedstoneConductor.EnumConnectionType.CATHODE) continue;
                ((ComponentBase)this.parent).getCircuit().notifyUpdate(((ComponentBase)this.parent).getPos(), ((IRedstoneConductorContainer)this.parent).getSlot(), info.side);
                continue;
            }
            if (info.neighbor.getNeighbors()[info.side.ordinal() ^ 1].getType() != IRedstoneConductor.EnumConnectionType.CATHODE) continue;
            ((ComponentBase)this.parent).getCircuit().notifyUpdate(((ComponentBase)this.parent).getPos(), ((IRedstoneConductorContainer)this.parent).getSlot(), info.side);
        }
    }

    public void onAdded() {
        if (this.isClient()) {
            return;
        }
        for (EnumCircuitSide enumCircuitSide : EnumCircuitSide.VALUES) {
            this.computeConnection(enumCircuitSide);
        }
        if (((IRedstoneConductor)this.parent).isBundled()) {
            for (EnumCircuitSide enumCircuitSide : EnumDyeColor.values()) {
                this.propagate((EnumDyeColor)enumCircuitSide);
            }
        } else {
            this.propagate(((IRedstoneConductor)this.parent).getColor());
        }
    }

    public void computeConnection(EnumCircuitSide side) {
        IRedstoneConductor neighbor = SimpleRedstoneConductor.getWireNeighbor(((ComponentBase)this.parent).getCircuit(), ((ComponentBase)this.parent).getPos(), side, ((IRedstoneConductorContainer)this.parent).getSlot());
        ConnectionInfo info = this.neighbors[side.ordinal()];
        IRedstoneConductor.EnumConnectionType prevType = info.type;
        if (!info.type.canConnect) {
            if (info.type == IRedstoneConductor.EnumConnectionType.NONE) {
                if (neighbor != null) {
                    if ((((IRedstoneConductor)this.parent).isBundled() || neighbor.isBundled() || !((IRedstoneConductor)this.parent).isColorBiased() || !neighbor.isColorBiased() || ((IRedstoneConductor)this.parent).getColor() == neighbor.getColor()) && ((IRedstoneConductor)this.parent).connect(side, neighbor, IRedstoneConductor.EnumConnectionType.ANODE, true) && neighbor.connect(side.getOpposite(), (IRedstoneConductor)this.parent, IRedstoneConductor.EnumConnectionType.ANODE, true)) {
                        ((IRedstoneConductor)this.parent).connect(side, neighbor, IRedstoneConductor.EnumConnectionType.ANODE, false);
                        neighbor.connect(side.getOpposite(), (IRedstoneConductor)this.parent, IRedstoneConductor.EnumConnectionType.ANODE, false);
                    }
                } else {
                    Pair<IComponent, EnumComponentSlot> n = ((ComponentBase)this.parent).getNeighborPair(((IRedstoneConductorContainer)this.parent).getSlot(), side);
                    if (n != null) {
                        if (!((IRedstoneConductor)this.parent).isBundled()) {
                            if (((IComponent)n.getKey()).isInput((EnumComponentSlot)((Object)n.getValue()), side.getOpposite())) {
                                info.type = IRedstoneConductor.EnumConnectionType.ANODE;
                            } else if (((IComponent)n.getKey()).isOutput((EnumComponentSlot)((Object)n.getValue()), side.getOpposite())) {
                                info.type = IRedstoneConductor.EnumConnectionType.CATHODE;
                            }
                        } else if (((IComponent)n.getKey()).getBundledConnection((EnumComponentSlot)((EnumComponentSlot)((Object)n.getValue())), (EnumCircuitSide)side.getOpposite()).canConnect) {
                            info.type = IRedstoneConductor.EnumConnectionType.BIDIRECTIONAL;
                        }
                        if (info.type != prevType) {
                            ((IRedstoneConductorContainer)this.parent).onConnect(side, null, info.type);
                        }
                    } else {
                        info.type = IRedstoneConductor.EnumConnectionType.NONE;
                        if (info.type != prevType) {
                            ((IRedstoneConductorContainer)this.parent).onDisconnect(side);
                        }
                    }
                }
            }
        } else {
            if (neighbor != null) {
                info.neighbor = neighbor;
                return;
            }
            Pair<IComponent, EnumComponentSlot> n = ((ComponentBase)this.parent).getNeighborPair(((IRedstoneConductorContainer)this.parent).getSlot(), side);
            if (n == null) {
                info.type = IRedstoneConductor.EnumConnectionType.NONE;
                if (info.type != prevType) {
                    ((IRedstoneConductorContainer)this.parent).onDisconnect(side);
                }
            } else if (info.type == IRedstoneConductor.EnumConnectionType.ANODE && !((IComponent)n.getKey()).isInput((EnumComponentSlot)((Object)n.getValue()), side.getOpposite()) || info.type == IRedstoneConductor.EnumConnectionType.CATHODE && !((IComponent)n.getKey()).isOutput((EnumComponentSlot)((Object)n.getValue()), side.getOpposite()) || info.type == IRedstoneConductor.EnumConnectionType.BIDIRECTIONAL && !((IComponent)n.getKey()).getBundledConnection((EnumComponentSlot)((EnumComponentSlot)((Object)n.getValue())), (EnumCircuitSide)side.getOpposite()).canConnect) {
                info.type = IRedstoneConductor.EnumConnectionType.NONE;
                this.computeConnection(side);
            }
        }
    }

    public void onRemoved() {
        if (this.isClient()) {
            return;
        }
        for (ConnectionInfo info : this.neighbors) {
            if (info.neighbor == null) continue;
            info.neighbor.disconnect(info.side.getOpposite());
            if (((IRedstoneConductor)this.parent).isBundled() && info.neighbor.isBundled()) {
                for (EnumDyeColor c : EnumDyeColor.values()) {
                    info.neighbor.propagate(c);
                }
            } else if (((IRedstoneConductor)this.parent).isBundled()) {
                info.neighbor.propagate(info.neighbor.getColor());
            } else {
                info.neighbor.propagate(((IRedstoneConductor)this.parent).getColor());
            }
            ((IRedstoneConductor)this.parent).disconnect(info.side);
        }
    }

    public void onLoaded() {
        if (this.isClient()) {
            return;
        }
        for (EnumCircuitSide side : EnumCircuitSide.VALUES) {
            ConnectionInfo info = this.neighbors[side.ordinal()];
            if (info.type.canConnect) {
                IRedstoneConductor neighbor = SimpleRedstoneConductor.getWireNeighbor(((ComponentBase)this.parent).getCircuit(), ((ComponentBase)this.parent).getPos(), side, ((IRedstoneConductorContainer)this.parent).getSlot());
                if (neighbor == null) continue;
                info.neighbor = neighbor;
                continue;
            }
            info.neighbor = null;
        }
    }

    public void onCircuitAdded() {
        if (this.isClient()) {
            return;
        }
        if (((IRedstoneConductor)this.parent).isBundled()) {
            for (EnumDyeColor c : EnumDyeColor.values()) {
                this.propagate(c);
            }
        } else {
            this.propagate(((IRedstoneConductor)this.parent).getColor());
        }
    }

    public void rotate(Rotation rotation) {
        if (this.isClient()) {
            return;
        }
        ConnectionInfo[] neighbors2 = new ConnectionInfo[this.neighbors.length];
        for (ConnectionInfo info : this.neighbors) {
            EnumCircuitSide side = info.side.rotate(rotation);
            ConnectionInfo connectionInfo = new ConnectionInfo(side);
            neighbors2[side.ordinal()] = connectionInfo;
            ConnectionInfo nInfo = connectionInfo;
            nInfo.type = info.type;
        }
        System.arraycopy(neighbors2, 0, this.neighbors, 0, this.neighbors.length);
    }

    public void rotatePost() {
        if (this.isClient()) {
            return;
        }
        this.onLoaded();
        if (((IRedstoneConductor)this.parent).isBundled()) {
            for (EnumDyeColor c : EnumDyeColor.values()) {
                this.propagate(c);
            }
        } else {
            this.propagate(((IRedstoneConductor)this.parent).getColor());
        }
    }

    public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
        if (this.isClient()) {
            return;
        }
        ConnectionInfo info = this.neighbors[side.ordinal()];
        IRedstoneConductor.EnumConnectionType prevType = info.type;
        this.computeConnection(side);
        if (prevType.canConnect || info.type.canConnect) {
            if (((IRedstoneConductor)this.parent).isBundled()) {
                for (EnumDyeColor c : EnumDyeColor.values()) {
                    this.propagate(c);
                }
            } else {
                this.propagate(((IRedstoneConductor)this.parent).getColor());
            }
        }
    }

    private boolean isClient() {
        return ((ComponentBase)this.parent).getCircuit().getWorld() != null && ((ComponentBase)this.parent).getCircuit().getWorld().field_72995_K;
    }

    public static IRedstoneConductor getWireNeighbor(ICircuit circuit, BlockPos pos, EnumCircuitSide side, EnumComponentSlot slot) {
        Pair<IComponent, EnumComponentSlot> c = ComponentBase.getNeighborPairConditioned(circuit, pos, slot, side, (comp, s) -> comp instanceof IRedstoneConductor || !(comp instanceof IWirePassthroughComponent) || ((IWirePassthroughComponent)((Object)comp)).blocksWire());
        return c != null && c.getKey() instanceof IRedstoneConductor ? (IRedstoneConductor)c.getKey() : null;
    }

    private static /* synthetic */ void lambda$propagate$0(Multimap wires, LinkedHashSet scheduledNext, Triple p) {
        ((IRedstoneConductor)p.getMiddle()).propagate((IRedstoneConductor)p.getLeft(), (EnumDyeColor)p.getRight(), (Multimap<IRedstoneConductor, EnumDyeColor>)wires, scheduledNext);
    }

    public static class ConnectionInfo
    implements IRedstoneConductor.IConnectionInfo {
        public final EnumCircuitSide side;
        public IRedstoneConductor.EnumConnectionType type = IRedstoneConductor.EnumConnectionType.NONE;
        public IRedstoneConductor neighbor;

        public ConnectionInfo(EnumCircuitSide side) {
            this.side = side;
        }

        @Override
        public EnumCircuitSide getSide() {
            return this.side;
        }

        @Override
        public IRedstoneConductor.EnumConnectionType getType() {
            return this.type;
        }

        @Override
        public IRedstoneConductor getNeighbor() {
            return this.neighbor;
        }
    }
}

