/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.wire;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IRedstoneConductor;
import com.amadornes.rscircuits.component.misc.ComponentPost;
import com.amadornes.rscircuits.component.wire.IRedstoneConductorContainer;
import com.amadornes.rscircuits.component.wire.SimpleRedstoneConductor;
import com.google.common.collect.Multimap;
import java.util.Set;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Triple;

public abstract class ComponentWirePostBase
extends ComponentPost
implements IRedstoneConductor,
IRedstoneConductorContainer {
    protected final SimpleRedstoneConductor<ComponentWirePostBase> cond = new SimpleRedstoneConductor<ComponentWirePostBase>(this);
    private boolean needsReconnect = false;

    public ComponentWirePostBase(ICircuit circuit) {
        super(circuit);
    }

    @Override
    public EnumComponentSlot getSlot() {
        return EnumComponentSlot.CENTER;
    }

    @Override
    public void onAdded() {
        if (this.needsReconnect) {
            this.needsReconnect = false;
            for (EnumCircuitSide side : EnumCircuitSide.VALUES) {
                this.cond.computeConnection(side);
            }
        }
        this.cond.onAdded();
    }

    @Override
    public void onRemoved() {
        this.cond.onRemoved();
    }

    @Override
    public void onLoaded() {
        if (this.needsReconnect) {
            this.needsReconnect = false;
            for (EnumCircuitSide side : EnumCircuitSide.VALUES) {
                this.cond.computeConnection(side);
            }
        }
        this.cond.onLoaded();
    }

    @Override
    public void onCircuitAdded() {
        this.cond.onCircuitAdded();
    }

    @Override
    public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
        this.cond.onNeighborChange(side, slot, component, updateType);
    }

    @Override
    public void propagate(EnumDyeColor color) {
        this.cond.propagate(color);
    }

    @Override
    public void propagate(IRedstoneConductor from, EnumDyeColor color, Multimap<IRedstoneConductor, EnumDyeColor> wires, Set<Triple<IRedstoneConductor, IRedstoneConductor, EnumDyeColor>> scheduled) {
        this.cond.propagate(from, color, wires, scheduled);
    }

    @Override
    public void onPropagated(Set<EnumDyeColor> colors, byte power) {
        this.cond.onPropagated(colors, power);
    }

    public IRedstoneConductor.IConnectionInfo[] getNeighbors() {
        return this.cond.getNeighbors();
    }

    @Override
    public boolean connect(EnumCircuitSide side, IRedstoneConductor conductor, IRedstoneConductor.EnumConnectionType type, boolean simulated) {
        return this.cond.connect(side, conductor, type, simulated);
    }

    @Override
    public void disconnect(EnumCircuitSide side) {
        this.cond.disconnect(side);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        int connections = this.cond.getNeighbors()[0].getType().ordinal() & 3 | (this.cond.getNeighbors()[0].getType().ordinal() & 3) << 3;
        tag.func_74768_a("connections", connections);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.func_74764_b("connections")) {
            int connections = tag.func_74762_e("connections");
            this.cond.getNeighborsRAW()[0].type = IRedstoneConductor.EnumConnectionType.VALUES[connections & 3];
            this.cond.getNeighborsRAW()[1].type = IRedstoneConductor.EnumConnectionType.VALUES[connections >> 3 & 3];
        } else {
            this.needsReconnect = true;
        }
    }
}

