/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.wire;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.api.component.IRedstoneConductor;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.component.wire.ComponentWireFlatBase;
import com.amadornes.rscircuits.component.wire.SimpleRedstoneConductor;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import com.amadornes.rscircuits.util.ProjectionHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

public class ComponentWireBundled
extends ComponentWireFlatBase {
    public static final PropertyBool FRONT = PropertyBool.func_177716_a((String)"front");
    public static final PropertyBool BACK = PropertyBool.func_177716_a((String)"back");
    public static final PropertyBool LEFT = PropertyBool.func_177716_a((String)"left");
    public static final PropertyBool RIGHT = PropertyBool.func_177716_a((String)"right");
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "bundled_wire");
    private byte[] power = new byte[16];
    private boolean shouldOutputPower = true;
    private boolean connectOnAdd = true;

    public ComponentWireBundled(ICircuit circuit, boolean connectOnAdd) {
        super(circuit, EnumComponentSlot.BOTTOM);
        this.connectOnAdd = connectOnAdd;
    }

    public ComponentWireBundled(ICircuit circuit) {
        super(circuit);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.005f;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public IBlockState getActualState() {
        IRedstoneConductor.IConnectionInfo[] info = this.getNeighbors();
        return super.getActualState().func_177226_a((IProperty)FRONT, (Comparable)Boolean.valueOf(info[EnumCircuitSide.FRONT.ordinal()].getType().canConnect)).func_177226_a((IProperty)BACK, (Comparable)Boolean.valueOf(info[EnumCircuitSide.BACK.ordinal()].getType().canConnect)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(info[EnumCircuitSide.LEFT.ordinal()].getType().canConnect)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(info[EnumCircuitSide.RIGHT.ordinal()].getType().canConnect));
    }

    @Override
    public boolean isBundled() {
        return true;
    }

    @Override
    public EnumDyeColor getColor() {
        return null;
    }

    @Override
    public boolean isColorBiased() {
        return true;
    }

    @Override
    public byte getInput(EnumDyeColor color) {
        int input = 0;
        for (IRedstoneConductor.IConnectionInfo info : this.getNeighbors()) {
            Pair<IComponent, EnumComponentSlot> neighbor;
            if (!info.getType().isInput || info.getNeighbor() != null || (neighbor = this.getNeighborPair(this.slot, info.getSide())) == null) continue;
            input = Math.max(input, ((IComponent)neighbor.getKey()).getOutputSignal((EnumComponentSlot)((Object)neighbor.getValue()), info.getSide().getOpposite(), color, true) & 0xFF);
        }
        if (this.getPos().func_177956_o() == 0) {
            for (EnumCircuitSide edge : this.getEdgesOn()) {
                input = Math.max(input, this.getCircuit().getInput(edge, color, true) & 0xFF);
            }
        }
        return (byte)input;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return bundled & this.shouldOutputPower && this.isOutput(slot, side) && color != null ? this.power[color.ordinal()] : (byte)0;
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return this.cond.getNeighbors()[side.ordinal()].getType().isInput;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return this.cond.getNeighbors()[side.ordinal()].getType().isOutput;
    }

    @Override
    public IRedstoneConductor.EnumConnectionType getBundledConnection(EnumComponentSlot slot, EnumCircuitSide side) {
        return this.cond.getNeighbors()[side.ordinal()].getType();
    }

    @Override
    public boolean isStrongOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return true;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, Vec3d hit) {
        if (heldItem != null && heldItem.func_77973_b() == SCMItems.screwdriver) {
            List<EnumCircuitSide> edges;
            IRedstoneConductor.EnumConnectionType prevType;
            int rot = ProjectionHelper.getPlacementRotation(new Vec3d(hit.field_72450_a, 0.0, 1.0 - hit.field_72449_c));
            if (rot == 1 || rot == 2) {
                rot = (rot - 1 ^ 1) + 1;
            }
            SimpleRedstoneConductor.ConnectionInfo info = this.cond.getNeighborsRAW()[rot + 2];
            IRedstoneConductor.EnumConnectionType type = prevType = info.type;
            EnumCircuitSide side = info.side;
            Pair<IComponent, EnumComponentSlot> neighbor = this.getNeighborPair(this.slot, side);
            if (neighbor != null) {
                if (type.canConnect) {
                    type = IRedstoneConductor.EnumConnectionType.DISABLED;
                } else if (((IComponent)neighbor.getKey()).getBundledConnection((EnumComponentSlot)((EnumComponentSlot)((Object)neighbor.getValue())), (EnumCircuitSide)side).canConnect) {
                    type = IRedstoneConductor.EnumConnectionType.BIDIRECTIONAL;
                }
            } else if (!this.isOnSeam() && this.getPos().func_177956_o() == 0 && (edges = this.getEdgesOn()).contains((Object)side) && this.isOnEdge(side)) {
                IRedstoneConductor.EnumConnectionType enumConnectionType = type = type.canConnect ? IRedstoneConductor.EnumConnectionType.DISABLED : IRedstoneConductor.EnumConnectionType.BIDIRECTIONAL;
            }
            if (type != prevType) {
                if (!this.getCircuit().getWorld().field_72995_K) {
                    info.type = type;
                    if (neighbor != null && neighbor.getKey() instanceof IRedstoneConductor) {
                        IRedstoneConductor w = (IRedstoneConductor)neighbor.getKey();
                        if (type == IRedstoneConductor.EnumConnectionType.DISABLED) {
                            w.disconnect(side.getOpposite());
                            if (w.isBundled()) {
                                EnumDyeColor[] enumDyeColorArray = EnumDyeColor.values();
                                int n = enumDyeColorArray.length;
                                for (int i = 0; i < n; ++i) {
                                    EnumDyeColor c = enumDyeColorArray[i];
                                    w.propagate(c);
                                }
                            } else {
                                w.propagate(w.getColor());
                            }
                            info.neighbor = null;
                        } else {
                            info.neighbor = w;
                            w.connect(side.getOpposite(), this, IRedstoneConductor.EnumConnectionType.ANODE, false);
                        }
                    } else {
                        this.getCircuit().notifyUpdate(this.getPos(), this.slot, side);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_77972_a(1, (EntityLivingBase)player);
                    }
                    for (EnumDyeColor c : EnumDyeColor.values()) {
                        this.propagate(c);
                    }
                    this.getCircuit().sendUpdate(this.getPos(), this.slot, true);
                    this.getCircuit().markDirty();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean connect(EnumCircuitSide side, IRedstoneConductor conductor, IRedstoneConductor.EnumConnectionType type, boolean simulated) {
        return (!simulated || this.connectOnAdd || this.cond.getNeighbors()[side.ordinal()].getType() != IRedstoneConductor.EnumConnectionType.DISABLED) && super.connect(side, conductor, type.canConnect ? IRedstoneConductor.EnumConnectionType.BIDIRECTIONAL : type, simulated);
    }

    @Override
    public void onAdded() {
        if (this.connectOnAdd) {
            super.onAdded();
        }
    }

    @Override
    public void onPropagated(Set<EnumDyeColor> colors, byte power) {
        boolean update = false;
        for (EnumDyeColor c : colors) {
            if (this.power[c.ordinal()] == power) continue;
            this.power[c.ordinal()] = power;
            update = true;
        }
        if (update) {
            super.onPropagated(colors, power);
            this.getCircuit().markDirty();
        }
    }

    @Override
    public void onConnect(EnumCircuitSide side, IRedstoneConductor conductor, IRedstoneConductor.EnumConnectionType type) {
        this.getCircuit().markDirty();
        this.getCircuit().sendUpdate(this.getPos(), this.slot, true);
    }

    @Override
    public void onDisconnect(EnumCircuitSide side) {
        this.getCircuit().markDirty();
        this.getCircuit().sendUpdate(this.getPos(), this.slot, true);
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        boxes.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0));
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getPickedItem());
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, EnumResourceType.TINY_BUNDLED_WIRE.ordinal());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74773_a("power", this.power);
        int connections = 0;
        for (IRedstoneConductor.IConnectionInfo info : this.getNeighbors()) {
            connections |= (info.getType().canConnect ? 1 : 0) << info.getSide().ordinal();
        }
        tag.func_74768_a("connections", connections);
        tag.func_74774_a("version", (byte)3);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        block4: {
            int version;
            block5: {
                block3: {
                    super.readFromNBT(tag);
                    this.power = tag.func_74770_j("power");
                    int n = version = tag.func_74764_b("version") ? tag.func_74771_c("version") & 0xFF : 1;
                    if (version != 1) break block3;
                    int connections = tag.func_74770_j("connections")[0] & 0xFF;
                    for (int i = 0; i < 4; ++i) {
                        this.cond.getNeighborsRAW()[i + 2].type = IRedstoneConductor.EnumConnectionType.VALUES[connections >> i * 2 & 3];
                    }
                    break block4;
                }
                if (version != 2) break block5;
                int connections = tag.func_74762_e("connections");
                for (SimpleRedstoneConductor.ConnectionInfo info : this.cond.getNeighborsRAW()) {
                    info.type = IRedstoneConductor.EnumConnectionType.VALUES[connections >> info.side.ordinal() * 2 & 3];
                }
                break block4;
            }
            if (version != 3) break block4;
            int connections = tag.func_74762_e("connections");
            for (SimpleRedstoneConductor.ConnectionInfo info : this.cond.getNeighborsRAW()) {
                info.type = (connections >> info.side.ordinal() & 1) != 0 ? IRedstoneConductor.EnumConnectionType.BIDIRECTIONAL : IRedstoneConductor.EnumConnectionType.NONE;
            }
        }
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        int connections = 0;
        for (IRedstoneConductor.IConnectionInfo info : this.getNeighbors()) {
            connections |= info.getType().ordinal() << info.getSide().ordinal() * 2;
        }
        buf.writeInt(connections);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        int connections = buf.readInt();
        for (SimpleRedstoneConductor.ConnectionInfo info : this.cond.getNeighborsRAW()) {
            info.type = IRedstoneConductor.EnumConnectionType.VALUES[connections >> info.side.ordinal() * 2 & 3];
        }
    }

    @Override
    public void serializePlacement(PacketBuffer buf) {
        super.serializePlacement(buf);
        buf.writeBoolean(this.connectOnAdd);
    }

    @Override
    public void deserializePlacement(PacketBuffer buf) {
        super.deserializePlacement(buf);
        this.connectOnAdd = buf.readBoolean();
        if (!this.connectOnAdd) {
            for (SimpleRedstoneConductor.ConnectionInfo info : this.cond.getNeighborsRAW()) {
                if (info.side.face.func_176740_k() == EnumFacing.Axis.Y) continue;
                info.type = IRedstoneConductor.EnumConnectionType.DISABLED;
            }
        }
    }

    @Override
    public void debug(EntityPlayer player) {
        StringBuilder power = new StringBuilder("Power: [");
        for (byte b : this.power) {
            power.append((b & 0xFF) + ", ");
        }
        power.reverse().delete(0, 2).reverse().append("]");
        player.func_145747_a((ITextComponent)new TextComponentString(power.toString()));
    }

    public static class Factory
    extends SimpleFactory<ComponentWireBundled> {
        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer.Builder((Block)MCMultiPartMod.multipart).add(new IProperty[]{FRONT, BACK, LEFT, RIGHT}).build();
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/bundled_wire");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && stack.func_77952_i() == EnumResourceType.TINY_BUNDLED_WIRE.ordinal();
        }

        private ComponentWireBundled mkWire(ICircuit circuit, ItemStack stack) {
            return new ComponentWireBundled(circuit, !Keyboard.isKeyDown((int)29));
        }

        @Override
        public IComponentFactory.EnumPlacementType getPlacementType(ItemStack stack, EntityPlayer player) {
            return IComponentFactory.EnumPlacementType.DRAW;
        }

        @Override
        public ComponentWireBundled getPlacementData(ICircuit circuit, BlockPos pos, EnumCircuitSide faceClicked, Vec3d hitVec, ItemStack stack, EntityPlayer player, IComponentFactory.EnumPlacementType type, ComponentWireBundled previousData, Map<BlockPos, ComponentWireBundled> otherData, IComponentFactory.EnumInstantanceUse use) {
            if (previousData != null) {
                return previousData;
            }
            if (!circuit.isSideSolid(pos.func_177977_b(), EnumCircuitSide.TOP)) {
                return null;
            }
            IComponent c = circuit.getComponent(pos, EnumComponentSlot.BOTTOM);
            return c instanceof ComponentWireBundled ? (ComponentWireBundled)c : this.mkWire(circuit, stack);
        }

        @Override
        public boolean placeComponent(ICircuit circuit, BlockPos pos, ComponentWireBundled data, IComponentFactory.EnumPlacementType type, Map<BlockPos, ComponentWireBundled> otherData, boolean simulate) {
            for (EnumCircuitSide side : EnumCircuitSide.HORIZONTALS) {
                ComponentWireBundled neighbor = otherData.get(pos.func_177972_a(side.face));
                if (neighbor == null) continue;
                SimpleRedstoneConductor.ConnectionInfo info = data.cond.getNeighborsRAW()[side.ordinal()];
                info.type = IRedstoneConductor.EnumConnectionType.ANODE;
                info.neighbor = neighbor;
            }
            return circuit.addComponent(pos, data, simulate);
        }

        @Override
        public void drawPlacement(ICircuit circuit, BlockPos pos, ComponentWireBundled data, IComponentFactory.EnumPlacementType type, Map<BlockPos, ComponentWireBundled> otherData) {
            super.drawPlacement(circuit, pos, data, type, otherData);
            boolean front = this.getState(circuit, pos, EnumCircuitSide.FRONT, otherData, data.connectOnAdd);
            boolean back = this.getState(circuit, pos, EnumCircuitSide.BACK, otherData, data.connectOnAdd);
            boolean left = this.getState(circuit, pos, EnumCircuitSide.LEFT, otherData, data.connectOnAdd);
            boolean right = this.getState(circuit, pos, EnumCircuitSide.RIGHT, otherData, data.connectOnAdd);
            IBlockState state = data.getActualState().func_177226_a((IProperty)FRONT, (Comparable)Boolean.valueOf(front)).func_177226_a((IProperty)BACK, (Comparable)Boolean.valueOf(back)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(left)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(right));
            SimpleFactory.draw(data, state, state);
            if (data.connectOnAdd) {
                if (front) {
                    state = data.getActualState().func_177226_a((IProperty)FRONT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BACK, (Comparable)Boolean.valueOf(front)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(false));
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                    SimpleFactory.draw(data, state, state);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                }
                if (back) {
                    state = data.getActualState().func_177226_a((IProperty)FRONT, (Comparable)Boolean.valueOf(back)).func_177226_a((IProperty)BACK, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(false));
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                    SimpleFactory.draw(data, state, state);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (left) {
                    state = data.getActualState().func_177226_a((IProperty)FRONT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BACK, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(left));
                    GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
                    SimpleFactory.draw(data, state, state);
                    GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                }
                if (right) {
                    state = data.getActualState().func_177226_a((IProperty)FRONT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BACK, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(right)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(false));
                    GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                    SimpleFactory.draw(data, state, state);
                    GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
        }

        private boolean getState(ICircuit circuit, BlockPos pos, EnumCircuitSide side, Map<BlockPos, ComponentWireBundled> otherData, boolean connectOnAdd) {
            IComponent c;
            if (otherData.containsKey(pos.func_177972_a(EnumCircuitSide.FRONT.face))) {
                return true;
            }
            if (!connectOnAdd || (c = circuit.getComponent(pos.func_177972_a(side.face), EnumComponentSlot.BOTTOM)) != null) {
                // empty if block
            }
            return false;
        }

        @Override
        public ComponentWireBundled instantiate(ICircuit circuit) {
            return new ComponentWireBundled(circuit);
        }
    }
}

