/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.misc;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.api.component.IWirePassthroughComponent;
import com.amadornes.rscircuits.component.ComponentFace;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import com.amadornes.rscircuits.part.PartCircuit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public class ComponentPlateNC
extends ComponentFace
implements IWirePassthroughComponent {
    public static final PropertyInteger MODE = PropertyInteger.func_177719_a((String)"mode", (int)0, (int)2);
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "plate_noncond");
    private int mode = 0;

    public ComponentPlateNC(ICircuit circuit) {
        super(circuit, EnumComponentSlot.TOP);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.002f;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public IBlockState getActualState() {
        return super.getActualState().func_177226_a((IProperty)MODE, (Comparable)Integer.valueOf(this.mode));
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        if (this.mode == 0) {
            return false;
        }
        if (side == (this.mode == 2 ? EnumCircuitSide.TOP : EnumCircuitSide.BOTTOM)) {
            Pair<IComponent, EnumComponentSlot> component = this.getNeighborPair(this.slot, side.getOpposite());
            return component != null ? ((IComponent)component.getKey()).isOutput((EnumComponentSlot)((Object)component.getValue()), side) : false;
        }
        return false;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        if (this.mode == 0) {
            return false;
        }
        if (side == (this.mode == 1 ? EnumCircuitSide.TOP : EnumCircuitSide.BOTTOM)) {
            Pair<IComponent, EnumComponentSlot> component = this.getNeighborPair(this.slot, side.getOpposite());
            return component != null ? ((IComponent)component.getKey()).isOutput((EnumComponentSlot)((Object)component.getValue()), side) : false;
        }
        return false;
    }

    @Override
    public boolean isStrongOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        if (this.mode == 0) {
            return false;
        }
        if (side == (this.mode == 1 ? EnumCircuitSide.TOP : EnumCircuitSide.BOTTOM)) {
            Pair<IComponent, EnumComponentSlot> component = this.getNeighborPair(this.slot, side.getOpposite());
            return component != null ? ((IComponent)component.getKey()).isStrongOutput((EnumComponentSlot)((Object)component.getValue()), side) : false;
        }
        return false;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        if (this.mode == 0) {
            return 0;
        }
        if (side == (this.mode == 1 ? EnumCircuitSide.TOP : EnumCircuitSide.BOTTOM)) {
            Pair<IComponent, EnumComponentSlot> component = this.getNeighborPair(this.slot, side.getOpposite());
            return component != null ? ((IComponent)component.getKey()).getOutputSignal((EnumComponentSlot)((Object)component.getValue()), side, color, bundled) : (byte)0;
        }
        return 0;
    }

    @Override
    public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
        this.update(side);
    }

    private void update(EnumCircuitSide side) {
        IComponent c;
        if (this.mode == 1 && (side == null || side == EnumCircuitSide.BOTTOM)) {
            IComponent c2 = this.getCircuit().getComponent(this.getPos().func_177984_a(), EnumComponentSlot.BOTTOM);
            if (c2 != null) {
                c2.onNeighborChange(EnumCircuitSide.BOTTOM, EnumComponentSlot.TOP, this, EnumCircuitUpdate.COMPONENT_UPDATE);
            }
        } else if (this.mode == 2 && (side == null || side == EnumCircuitSide.TOP) && (c = this.getCircuit().getComponent(this.getPos(), EnumComponentSlot.CENTER)) != null) {
            c.onNeighborChange(EnumCircuitSide.TOP, EnumComponentSlot.TOP, this, EnumCircuitUpdate.COMPONENT_UPDATE);
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, Vec3d hit) {
        if (hand == EnumHand.MAIN_HAND && heldItem != null && heldItem.func_77973_b() == SCMItems.screwdriver && !player.func_70093_af()) {
            if (!this.getCircuit().getWorld().field_72995_K) {
                this.mode = (this.mode + 1) % 3;
                this.getCircuit().notifyUpdate(this.getPos(), this.slot, EnumCircuitSide.TOP, EnumCircuitSide.BOTTOM);
                this.getCircuit().markDirty();
                this.getCircuit().sendUpdate(this.getPos(), this.slot, true);
            }
            return true;
        }
        return super.onActivated(player, hand, heldItem, hit);
    }

    @Override
    public boolean isSideSolid(EnumCircuitSide side) {
        return true;
    }

    @Override
    public boolean blocksWire() {
        return true;
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        boxes.add(new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getPickedItem());
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, EnumResourceType.TINY_PLATE_NONCOND.ordinal());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        tag.func_74768_a("mode", this.mode);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.mode = tag.func_74762_e("mode");
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        buf.writeInt(this.mode);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        this.mode = buf.readInt();
    }

    public static class Factory
    extends SimpleFactory<ComponentPlateNC>
    implements IComponentFactory.IDrawListener<ComponentPlateNC> {
        private int height = -1;

        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{MODE});
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/plate_noncond");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && stack.func_77952_i() == EnumResourceType.TINY_PLATE_NONCOND.ordinal();
        }

        @Override
        public IComponentFactory.EnumPlacementType getPlacementType(ItemStack stack, EntityPlayer player) {
            return IComponentFactory.EnumPlacementType.DRAW;
        }

        @Override
        public ComponentPlateNC getPlacementData(ICircuit circuit, BlockPos pos, EnumCircuitSide faceClicked, Vec3d hitVec, ItemStack stack, EntityPlayer player, IComponentFactory.EnumPlacementType type, ComponentPlateNC previousData, Map<BlockPos, ComponentPlateNC> otherData, IComponentFactory.EnumInstantanceUse use) {
            if (previousData != null) {
                return previousData;
            }
            if (this.height == -1) {
                if (use == IComponentFactory.EnumInstantanceUse.PLACEMENT) {
                    this.height = pos.func_177956_o();
                    PartCircuit.selectionBoxOffset = (float)(2 * this.height) / 16.0f;
                }
                return new ComponentPlateNC(circuit);
            }
            if (pos.func_177956_o() == this.height) {
                return new ComponentPlateNC(circuit);
            }
            return null;
        }

        @Override
        public boolean placeComponent(ICircuit circuit, BlockPos pos, ComponentPlateNC data, IComponentFactory.EnumPlacementType type, Map<BlockPos, ComponentPlateNC> otherData, boolean simulate) {
            return circuit.addComponent(pos, data, simulate);
        }

        @Override
        public void onStartDrawing(EntityPlayer player) {
        }

        @Override
        public void onFinishDrawing(EntityPlayer player) {
            this.height = -1;
            PartCircuit.selectionBoxOffset = 0.0f;
        }

        @Override
        public ComponentPlateNC instantiate(ICircuit circuit) {
            return new ComponentPlateNC(circuit);
        }
    }
}

