/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.circuit;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IRedstoneConductor;
import com.amadornes.rscircuits.component.ComponentFace;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.component.circuit.ComponentCircuit;
import com.amadornes.rscircuits.init.SCMItems;
import java.util.Arrays;
import java.util.List;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class ComponentCircuitSlave
extends ComponentFace {
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "circuit_slave");
    private ComponentCircuit master;
    private BlockPos selfPos = null;

    public ComponentCircuitSlave(ICircuit circuit) {
        super(circuit, EnumComponentSlot.BOTTOM);
    }

    public ComponentCircuitSlave(ICircuit circuit, ComponentCircuit master, BlockPos selfPos) {
        super(circuit, EnumComponentSlot.BOTTOM);
        this.master = master;
        this.selfPos = selfPos;
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.0f;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public IBlockState getActualState() {
        return null;
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return this.master != null && this.master.isInput(slot, side);
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return this.master != null && this.master.isOutput(slot, side);
    }

    @Override
    public IRedstoneConductor.EnumConnectionType getBundledConnection(EnumComponentSlot slot, EnumCircuitSide side) {
        return this.master != null ? this.master.getBundledConnection(slot, side) : IRedstoneConductor.EnumConnectionType.NONE;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        if (this.master == null) {
            return 0;
        }
        return this.master.getOutputSignal(slot, side, color, bundled);
    }

    @Override
    public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
        if (this.master != null && slot == EnumComponentSlot.BOTTOM && side.face.func_176740_k() != EnumFacing.Axis.Y && !(component instanceof ComponentCircuit) && !(component instanceof ComponentCircuitSlave)) {
            this.master.circuit.forEachEdge(IComponent::onWorldChange, side, 0, 0, EnumComponentSlot.VALUES);
        }
    }

    @Override
    public void onLoaded() {
        this.master = (ComponentCircuit)this.getCircuit().getComponent(this.getPos().func_177973_b((Vec3i)this.selfPos), this.slot);
    }

    @Override
    public void onAdded() {
        this.master = (ComponentCircuit)this.getCircuit().getComponent(this.getPos().func_177973_b((Vec3i)this.selfPos), this.slot);
    }

    @Override
    public void onCircuitAdded() {
        this.master = (ComponentCircuit)this.getCircuit().getComponent(this.getPos().func_177973_b((Vec3i)this.selfPos), this.slot);
    }

    @Override
    public void onRemoved() {
        if (this.master != null && !this.master.removing) {
            this.master.removing = true;
            for (int x = 0; x < this.master.size; ++x) {
                for (int z = 0; z < this.master.size; ++z) {
                    if (x == this.selfPos.func_177958_n() && z == this.selfPos.func_177952_p()) continue;
                    this.getCircuit().removeComponent(this.getCircuit().getComponent(this.getPos().func_177973_b((Vec3i)this.selfPos).func_177982_a(x, 0, z), this.slot));
                }
            }
            this.master.removing = false;
        }
    }

    @Override
    public boolean harvest(EntityPlayer player, Vec3d hitPos) {
        if (player != null && !player.field_71075_bZ.field_75098_d && !this.getCircuit().getWorld().field_72995_K) {
            this.master.getDrops().forEach(this.getCircuit()::spawnStack);
        }
        return super.harvest(player, hitPos);
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        if (this.master != null) {
            boxes.add(new AxisAlignedBB(0.0, 0.0, 0.0, (double)this.master.size, (double)(2 * this.master.size) / 16.0, (double)this.master.size).func_186670_a(BlockPos.field_177992_a.func_177973_b((Vec3i)this.selfPos)));
        }
    }

    @Override
    public ItemStack getPickedItem() {
        return this.master != null ? this.master.getPickedItem() : new ItemStack(SCMItems.circuit);
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(new ItemStack[0]);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74772_a("selfPos", this.selfPos.func_177986_g());
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.selfPos = BlockPos.func_177969_a((long)tag.func_74763_f("selfPos"));
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        buf.writeLong(this.selfPos.func_177986_g());
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        this.selfPos = BlockPos.func_177969_a((long)buf.readLong());
    }

    @Override
    public void debug(EntityPlayer player) {
        if (this.master != null) {
            this.master.debug(player);
        }
    }

    public static class Factory
    extends SimpleFactory<ComponentCircuitSlave> {
        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[0]);
        }

        @Override
        public ResourceLocation getModelPath() {
            return null;
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return false;
        }

        @Override
        public ComponentCircuitSlave instantiate(ICircuit circuit) {
            return new ComponentCircuitSlave(circuit);
        }
    }
}

