/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.button;

import com.amadornes.rscircuits.SCM;
import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.component.ComponentBaseInt;
import com.amadornes.rscircuits.component.ComponentButton;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import com.google.common.base.Supplier;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class ComponentDelay
extends ComponentButton {
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "delay");
    private int delay = 20;
    private int ticks = 0;
    private byte input = 0;
    private byte state = 0;

    public ComponentDelay(ICircuit circuit) {
        super(circuit, EnumComponentSlot.BOTTOM);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.04f;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public IBlockState getActualState() {
        return super.getActualState().func_177226_a(ON, (Comparable)Boolean.valueOf(this.state != 0));
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side != EnumCircuitSide.TOP;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side != EnumCircuitSide.TOP;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return side.face.func_176740_k() != EnumFacing.Axis.Y ? this.state : (byte)0;
    }

    @Override
    public void tick() {
        ++this.ticks;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, Vec3d hit) {
        if (heldItem != null && (heldItem.func_77973_b() == SCMItems.screwdriver || heldItem.func_77973_b() == SCMItems.multimeter)) {
            SCM.proxy.displayTimerGui((d, s) -> "Quartz Resonator: " + d + (s ? " seconds" : " ticks"), s -> s ? "s" : "t", (Supplier<Integer>)((Supplier)() -> this.delay), d -> {
                ByteBuf buf = Unpooled.buffer();
                buf.writeInt(d.intValue());
                this.getCircuit().sendCustomPayload(this.getPos(), this.slot, buf);
            }, 1, 72000, 20.0);
            return true;
        }
        return false;
    }

    @Override
    public void onScheduledTick(int type, Object data) {
        byte prevState = this.state;
        this.state = (Byte)data;
        if (this.state != prevState) {
            this.getCircuit().notifyUpdate(this.getPos(), this.slot, EnumCircuitSide.HORIZONTALS);
            this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
            this.getCircuit().markDirty();
        }
    }

    @Override
    public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
        if (side == EnumCircuitSide.BOTTOM && this.dropIfNeeded()) {
            return;
        }
        byte power = this.getInput();
        if (this.input != power) {
            this.input = power;
            this.getCircuit().scheduleTick(this, this.delay, this.ticks, this.input);
            this.getCircuit().markDirty();
        }
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getPickedItem());
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, EnumResourceType.QUARTZ_RESONATOR.ordinal());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("delay", this.delay);
        tag.func_74768_a("ticks", this.ticks);
        tag.func_74774_a("input", this.input);
        tag.func_74774_a("state", this.state);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.delay = tag.func_74762_e("delay");
        this.ticks = tag.func_74762_e("ticks");
        this.input = tag.func_74771_c("input");
        this.state = tag.func_74771_c("state");
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        buf.writeInt(this.delay);
        buf.writeBoolean(this.state != 0);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        this.delay = buf.readInt();
        this.state = (byte)(buf.readBoolean() ? 255 : 0);
    }

    @Override
    public NBTTagCompound serializeTickData(int type, Object data) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("state", ((Byte)data).byteValue());
        return tag;
    }

    @Override
    public Object deserializeTickData(int type, NBTTagCompound tag) {
        return tag.func_74771_c("state");
    }

    @Override
    public void handleCustomPayload(ByteBuf buf) {
        this.delay = buf.readInt();
        this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
    }

    public static class Factory
    extends SimpleFactory<ComponentDelay> {
        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{ComponentBaseInt.ON});
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/delay");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && stack.func_77952_i() == EnumResourceType.QUARTZ_RESONATOR.ordinal();
        }

        @Override
        public ComponentDelay instantiate(ICircuit circuit) {
            return new ComponentDelay(circuit);
        }
    }
}

