/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.client.TmpModel;
import com.amadornes.rscircuits.component.ComponentBaseInt;
import com.amadornes.rscircuits.util.RedstoneUtils;
import com.google.common.base.Function;
import java.awt.Color;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Point3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SimpleFactory<T extends ComponentBaseInt>
implements IComponentFactory<T> {
    public abstract T instantiate(ICircuit var1);

    public T instantiate(ICircuit circuit, ItemStack stack) {
        return (T)this.instantiate(circuit);
    }

    @Override
    public void serialize(PacketBuffer buf, Map<BlockPos, T> data, EntityPlayer player) {
        SimpleFactory.serialize(buf, data, java.util.function.Function.identity());
    }

    @Override
    public void deserialize(PacketBuffer buf, Map<BlockPos, T> data, Function<BlockPos, ICircuit> circuitProvider, EntityPlayer player) {
        SimpleFactory.deserialize(buf, data, circuitProvider, java.util.function.Function.identity(), iCircuit -> this.instantiate((ICircuit)iCircuit));
    }

    @Override
    public IComponentFactory.EnumPlacementType getPlacementType(ItemStack stack, EntityPlayer player) {
        return IComponentFactory.EnumPlacementType.SINGLE;
    }

    @Override
    public T getPlacementData(ICircuit circuit, BlockPos pos, EnumCircuitSide faceClicked, Vec3d hitVec, ItemStack stack, EntityPlayer player, IComponentFactory.EnumPlacementType type, T previousData, Map<BlockPos, T> otherData, IComponentFactory.EnumInstantanceUse use) {
        if (previousData != null) {
            return previousData;
        }
        return this.instantiate(circuit, stack);
    }

    @Override
    public boolean placeComponent(ICircuit circuit, BlockPos pos, T data, IComponentFactory.EnumPlacementType type, Map<BlockPos, T> otherData, boolean simulate) {
        return circuit.addComponent(pos, (IComponent)data, simulate);
    }

    @Override
    public void drawPlacement(ICircuit circuit, BlockPos pos, T data, IComponentFactory.EnumPlacementType type, Map<BlockPos, T> otherData) {
        SimpleFactory.draw(data, java.util.function.Function.identity());
    }

    public static <T extends ComponentBaseInt, V> void serialize(PacketBuffer buf, Map<BlockPos, V> data, java.util.function.Function<V, T> adapter) {
        buf.writeInt(data.size());
        data.forEach((pos, comp) -> {
            buf.func_179255_a(pos);
            ((ComponentBaseInt)adapter.apply(comp)).serializePlacement(buf);
        });
    }

    public static <T extends ComponentBaseInt, V> void deserialize(PacketBuffer buf, Map<BlockPos, V> data, Function<BlockPos, ICircuit> circuitProvider, java.util.function.Function<T, V> adapter, java.util.function.Function<ICircuit, T> supplier) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buf.func_179259_c();
            ComponentBaseInt comp = (ComponentBaseInt)supplier.apply((ICircuit)circuitProvider.apply((Object)pos));
            comp.setPos(RedstoneUtils.limitPositionToBounds(pos));
            comp.deserializePlacement(buf);
            data.put(pos, adapter.apply(comp));
        }
    }

    public static <T extends ComponentBaseInt, V> void draw(V data, java.util.function.Function<V, T> adapter) {
        ComponentBaseInt comp = (ComponentBaseInt)adapter.apply(data);
        IBlockState state = comp.getActualState();
        if (state != null) {
            SimpleFactory.draw(comp, state, comp.getExtendedState(state));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static <T extends ComponentBaseInt> void draw(T comp, IBlockState modelState, IBlockState state) {
        Minecraft mc = Minecraft.func_71410_x();
        IBakedModel model = mc.func_175602_ab().func_184389_a(modelState);
        float size = comp.getSize();
        Vec3d offset = comp.getOffset();
        Stream stream = model.func_188616_a(state, null, 0L).stream();
        for (EnumFacing f : EnumFacing.field_82609_l) {
            stream = Stream.concat(stream, model.func_188616_a(state, f, 0L).stream());
        }
        TmpModel.INSTANCE.getQuads().addAll(stream.map(q -> {
            int multiplier = q.func_178212_b() ? comp.getColorMultiplier(q.func_178211_c()) : -1;
            Color colorMultiplier = multiplier != -1 ? new Color(multiplier, false) : null;
            int[] data = (int[])q.func_178209_a().clone();
            for (int i = 0; i < 4; ++i) {
                Point3f point = new Point3f((Float.intBitsToFloat(data[i * 7 + 0]) - 0.5f + (offset != null ? (float)offset.field_72450_a : 0.0f)) * size / 0.125f + 0.5f, (Float.intBitsToFloat(data[i * 7 + 1]) + (offset != null ? (float)offset.field_72448_b : 0.0f)) * size / 0.125f, (Float.intBitsToFloat(data[i * 7 + 2]) - 0.5f + (offset != null ? (float)offset.field_72449_c : 0.0f)) * size / 0.125f + 0.5f);
                data[i * 7 + 0] = Float.floatToRawIntBits(point.x);
                data[i * 7 + 1] = Float.floatToRawIntBits(point.y);
                data[i * 7 + 2] = Float.floatToRawIntBits(point.z);
                if (colorMultiplier == null) continue;
                Color color = new Color(data[i * 7 + 3]);
                data[i * 7 + 3] = color.getAlpha() << 24 | color.getRed() * colorMultiplier.getBlue() / 255 << 16 | color.getGreen() * colorMultiplier.getGreen() / 255 << 8 | color.getBlue() * colorMultiplier.getRed() / 255 << 0;
            }
            return new BakedQuad(data, q.func_178211_c(), q.func_178210_d(), q.func_187508_a(), q.shouldApplyDiffuseLighting(), q.getFormat());
        }).collect(Collectors.toList()));
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_DST_COLOR);
        GlStateManager.func_179141_d();
        GlStateManager.func_179089_o();
        VertexBuffer vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        vb.func_178969_c((double)(-mc.field_71476_x.func_178782_a().func_177958_n()), (double)(-mc.field_71476_x.func_178782_a().func_177956_o()), (double)(-mc.field_71476_x.func_178782_a().func_177952_p()));
        mc.func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)mc.field_71441_e, (IBakedModel)TmpModel.INSTANCE, state, mc.field_71476_x.func_178782_a(), vb, false);
        vb.func_178969_c(0.0, 0.0, 0.0);
        Tessellator.func_178181_a().func_78381_a();
        TmpModel.INSTANCE.getQuads().clear();
        GlStateManager.func_179129_p();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }
}

