/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.command;

import com.amadornes.rscircuits.SCM;
import com.amadornes.rscircuits.item.ICircuitStorage;
import com.amadornes.rscircuits.util.GistPublisher;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Base64;
import java.util.Collections;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class CommandExport
extends CommandBase {
    public String func_71517_b() {
        return "export";
    }

    public String func_71518_a(ICommandSender sender) {
        return "";
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) throw new CommandException("You must be a player to use this command!", new Object[0]);
        EntityPlayer player = (EntityPlayer)sender;
        ItemStack stack = player.func_184614_ca();
        if (stack == null || !(stack.func_77973_b() instanceof ICircuitStorage)) throw new CommandException("You must have a circuit/blueprint/redprint in your hand!", new Object[0]);
        NBTTagCompound tag = ((ICircuitStorage)stack.func_77973_b()).getCircuitData(player, stack);
        if (tag == null) throw new CommandException("The item must contain a circuit!", new Object[0]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)baos);
        }
        catch (IOException e) {
            throw new CommandException("Failed to save the circuit to a streamable format", new Object[0]);
        }
        String data = new String(Base64.getEncoder().encode(baos.toByteArray()));
        new Thread(() -> {
            try {
                URL url = GistPublisher.publish(Collections.singletonMap("blueprint", data));
                TextComponentString link = new TextComponentString(url.toString());
                ClickEvent evt = new ClickEvent(ClickEvent.Action.OPEN_URL, url.toString());
                link.func_150256_b().func_150241_a(evt);
                link.func_150256_b().func_150228_d(Boolean.valueOf(true));
                link.func_150256_b().func_150238_a(TextFormatting.BLUE);
                player.func_145747_a((ITextComponent)link);
            }
            catch (Exception e) {
                SCM.log.error("Error while uploading blueprint gist", (Throwable)e);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error while uploading blueprint gist"));
            }
        }).start();
    }
}

