/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.circuit;

import com.amadornes.rscircuits.CommonProxy;
import com.amadornes.rscircuits.SCM;
import com.amadornes.rscircuits.api.circuit.EnumCircuitIOMode;
import com.amadornes.rscircuits.api.circuit.HandledCircuitException;
import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IRedstoneConductor;
import com.amadornes.rscircuits.circuit.EnumCircuitCrashStatus;
import com.amadornes.rscircuits.circuit.ICircuitContainer;
import com.amadornes.rscircuits.component.ComponentRegistry;
import com.amadornes.rscircuits.util.GistPublisher;
import com.amadornes.rscircuits.util.RedstoneUtils;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AtomicDouble;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class Circuit
implements ICircuit {
    public static final List<String> tags = Arrays.asList("components", "updates", "name");
    private final ICircuitContainer container;
    public IComponent[][][][] components = new IComponent[8][5][8][7];
    private Map<Long, Map<IComponent, Map<Integer, Object>>> scheduledTicks = new TreeMap<Long, Map<IComponent, Map<Integer, Object>>>(Long::compare);
    private Map<Long, Map<IComponent, Map<Integer, Object>>> scheduledTicksBkp = new TreeMap<Long, Map<IComponent, Map<Integer, Object>>>(Long::compare);
    private Map<Pair<BlockPos, EnumComponentSlot>, Boolean> updates = new HashMap<Pair<BlockPos, EnumComponentSlot>, Boolean>();
    private boolean iterating = false;
    private boolean scheduledOffset = false;
    private EnumCircuitIOMode[] ioModes = new EnumCircuitIOMode[4];
    private String name = "";
    private Set<IComponent> nonInteractable = new HashSet<IComponent>();
    private MutablePair<EnumCircuitCrashStatus, String> crash = new MutablePair((Object)EnumCircuitCrashStatus.NO_CRASH, null);

    public Circuit(ICircuitContainer container) {
        this.container = container;
        Arrays.fill((Object[])this.ioModes, (Object)EnumCircuitIOMode.REGULAR);
    }

    @Override
    public World getWorld() {
        return this.container != null ? this.container.getWorld() : null;
    }

    @Override
    public BlockPos getPos() {
        return this.container != null ? this.container.getPos() : BlockPos.field_177992_a;
    }

    @Override
    public EnumFacing getFace() {
        return this.container.getFace();
    }

    @Override
    public EnumCircuitIOMode getIOMode(EnumCircuitSide side) {
        return this.ioModes[side.ordinal() - 2];
    }

    public EnumCircuitIOMode[] getIOModes() {
        return this.ioModes;
    }

    public void cycleModes(EnumCircuitSide side) {
        this.ioModes[side.ordinal() - 2] = this.ioModes[side.ordinal() - 2] == EnumCircuitIOMode.BUNDLED ? EnumCircuitIOMode.REGULAR : EnumCircuitIOMode.BUNDLED;
        this.container.sendUpdatePacket();
    }

    @Override
    public IComponent getComponent(BlockPos pos, EnumComponentSlot slot) {
        Circuit circuit = this.getCircuit(pos);
        pos = RedstoneUtils.limitPositionToBounds(pos);
        if (circuit == this) {
            return this.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][slot.ordinal()];
        }
        if (circuit != null) {
            return circuit.getComponent(pos, slot);
        }
        return null;
    }

    @Override
    public boolean addComponent(BlockPos pos, IComponent component, boolean simulate) {
        Circuit circuit = this.getCircuit(pos);
        pos = RedstoneUtils.limitPositionToBounds(pos);
        if (circuit == this) {
            if (pos.func_177956_o() < 4) {
                EnumSet<EnumComponentSlot> slots = component.getSlots();
                if (slots.isEmpty()) {
                    return false;
                }
                for (EnumComponentSlot slot : slots) {
                    if (this.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][slot.ordinal()] == null) continue;
                    return false;
                }
                if (!simulate) {
                    component.setPos(pos);
                    for (EnumComponentSlot slot : slots) {
                        this.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][slot.ordinal()] = component;
                    }
                    component.onAdded();
                    for (EnumComponentSlot s : component.getSlots()) {
                        this.notifyUpdate(component.getPos(), s, EnumCircuitUpdate.COMPONENT_ADD, EnumCircuitSide.VALUES);
                    }
                    component.onAddedPost();
                    this.sendUpdate(pos, (EnumComponentSlot)((Object)component.getSlots().iterator().next()), !component.isDynamic());
                    this.markDirty();
                    this.nonInteractable.add(component);
                }
                return true;
            }
            return false;
        }
        if (circuit != null) {
            return circuit.addComponent(pos, component, simulate);
        }
        return false;
    }

    @Override
    public void removeComponent(IComponent component) {
        if (component == null) {
            return;
        }
        BlockPos pos = component.getPos();
        for (EnumComponentSlot s2 : component.getSlots()) {
            this.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][s2.ordinal()] = null;
        }
        component.onRemoved();
        for (EnumComponentSlot s2 : component.getSlots()) {
            this.notifyUpdate(component.getPos(), s2, EnumCircuitUpdate.COMPONENT_REMOVE, component, EnumCircuitSide.VALUES);
        }
        component.onRemovedPost();
        if (!component.isDynamic() && component.getActualState() != null) {
            this.container.markRenderUpdate();
        }
        this.scheduledTicks.values().forEach((? super T m) -> {
            Map cfr_ignored_0 = (Map)m.remove(component);
        });
        component.getSlots().forEach((? super T s) -> this.sendUpdate(pos, (EnumComponentSlot)((Object)s), !component.isDynamic()));
        this.markDirty();
    }

    @Override
    public void replaceComponent(IComponent component, IComponent newComponent) {
        if (component == null || !component.getSlots().equals(newComponent.getSlots())) {
            return;
        }
        BlockPos pos = component.getPos();
        newComponent.setPos(pos);
        for (EnumComponentSlot s2 : component.getSlots()) {
            this.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][s2.ordinal()] = newComponent;
        }
        component.onRemoved();
        newComponent.onAdded();
        for (EnumComponentSlot s2 : component.getSlots()) {
            this.notifyUpdate(component.getPos(), s2, EnumCircuitUpdate.COMPONENT_ADD, component, EnumCircuitSide.VALUES);
        }
        component.onRemovedPost();
        if (!component.isDynamic() && component.getActualState() != null) {
            this.container.markRenderUpdate();
        }
        this.scheduledTicks.values().forEach((? super T m) -> {
            Map cfr_ignored_0 = (Map)m.remove(component);
        });
        component.getSlots().forEach((? super T s) -> this.sendUpdate(pos, (EnumComponentSlot)((Object)s), !component.isDynamic()));
        this.markDirty();
    }

    @Override
    public boolean isSideSolid(BlockPos pos, EnumCircuitSide side) {
        if (pos.func_177956_o() == -1 && side == EnumCircuitSide.TOP) {
            return true;
        }
        Circuit circuit = this.getCircuit(pos);
        pos = RedstoneUtils.limitPositionToBounds(pos);
        if (circuit == this) {
            IComponent comp = this.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][side.ordinal()];
            if (comp != null) {
                return comp.isSideSolid(side);
            }
            comp = this.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][EnumComponentSlot.CENTER.ordinal()];
            if (comp != null) {
                return comp.isSideSolid(side);
            }
            return false;
        }
        if (circuit != null) {
            return circuit.isSideSolid(pos, side);
        }
        return false;
    }

    @Override
    public void scheduleTick(IComponent component, int delay, int type, Object data) {
        Map<Integer, Object> tickMap;
        long finalTime;
        if (this.getWorld() != null && this.getWorld().field_72995_K) {
            return;
        }
        Map<Long, Map<IComponent, Map<Integer, Object>>> scheduledTicks = !this.iterating ? this.scheduledTicks : this.scheduledTicksBkp;
        Map<IComponent, Map<Integer, Object>> componentMap = scheduledTicks.get(finalTime = this.getWorld().func_82737_E() + (long)delay);
        if (componentMap == null) {
            componentMap = new HashMap<IComponent, Map<Integer, Object>>();
            scheduledTicks.put(finalTime, componentMap);
        }
        if ((tickMap = componentMap.get(component)) == null) {
            tickMap = new HashMap<Integer, Object>();
            componentMap.put(component, tickMap);
        }
        tickMap.put(type, data);
    }

    @Override
    public void notifyUpdate(BlockPos pos, EnumComponentSlot slot, EnumCircuitSide ... directions) {
        this.notifyUpdate(pos, slot, EnumCircuitUpdate.COMPONENT_UPDATE, directions);
    }

    public void notifyUpdate(BlockPos pos, EnumComponentSlot slot, EnumCircuitUpdate updateType, EnumCircuitSide ... directions) {
        if (this.getWorld() == null || this.getWorld().field_72995_K) {
            return;
        }
        this.notifyUpdate(pos, slot, updateType, this.getComponent(pos, slot), directions);
    }

    public void notifyUpdate(BlockPos pos, EnumComponentSlot slot, EnumCircuitUpdate updateType, IComponent comp, EnumCircuitSide ... directions) {
        if (this.getWorld() == null || this.getWorld().field_72995_K) {
            return;
        }
        for (EnumCircuitSide side : directions) {
            IComponent c;
            if (side == null) continue;
            if ((slot == EnumComponentSlot.CENTER || slot.side != side && slot.side != side.getOpposite()) && (c = this.getComponent(pos, EnumComponentSlot.VALUES[side.ordinal()])) != null) {
                c.onNeighborChange(side.getOpposite(), slot, comp, updateType);
                continue;
            }
            BlockPos p = pos.func_177972_a(side.face);
            Circuit circuit = this.getCircuit(p);
            if (circuit == null) {
                this.container.notifyNeighbor(side, true);
                continue;
            }
            p = RedstoneUtils.limitPositionToBounds(p);
            if (slot == EnumComponentSlot.CENTER) {
                for (EnumComponentSlot s : EnumComponentSlot.VALUES) {
                    IComponent c2 = circuit.getComponent(p, s);
                    if (c2 == null) continue;
                    c2.onNeighborChange(side.getOpposite(), slot, comp, updateType);
                }
                continue;
            }
            IComponent c3 = circuit.getComponent(p, slot.side == side ? EnumComponentSlot.VALUES[slot.ordinal() ^ 1] : slot);
            if (c3 == null) {
                c3 = circuit.getComponent(p, EnumComponentSlot.CENTER);
            }
            if (c3 == null) continue;
            c3.onNeighborChange(side.getOpposite(), slot, comp, updateType);
        }
    }

    @Override
    public void notifyUpdateAll(BlockPos pos, EnumComponentSlot slot) {
        this.notifyUpdate(pos, slot, EnumCircuitSide.VALUES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendUpdate(BlockPos pos, EnumComponentSlot slot, boolean reRender) {
        if (pos == null) {
            return;
        }
        this.updates.merge((Pair<BlockPos, EnumComponentSlot>)Pair.of((Object)pos, (Object)((Object)slot)), reRender, (a, b) -> a != false || b != false);
        Set<Circuit> set = CommonProxy.updatedCircuits;
        synchronized (set) {
            CommonProxy.updatedCircuits.add(this);
        }
    }

    @Override
    public void markDirty() {
        this.container.markDirty();
    }

    public Map<Pair<BlockPos, EnumComponentSlot>, Boolean> getUpdates() {
        return this.updates;
    }

    @Override
    public Circuit getCircuit(BlockPos pos) {
        if (pos.func_177958_n() >= 0 && pos.func_177958_n() < 7 && pos.func_177956_o() >= 0 && pos.func_177956_o() < 5 && pos.func_177952_p() >= 0 && pos.func_177952_p() < 7) {
            return this;
        }
        if (!this.container.isInWorld() || this.getWorld() == null || this.getPos() == null) {
            return null;
        }
        Pair<BlockPos, BlockPos> coords = RedstoneUtils.correctCoords(BlockPos.field_177992_a, this.getFace(), pos);
        if (((BlockPos)coords.getKey()).func_177951_i((Vec3i)BlockPos.field_177992_a) == 0.0) {
            boolean gZ;
            boolean gX = ((BlockPos)coords.getValue()).func_177958_n() == 7;
            boolean bl = gZ = ((BlockPos)coords.getValue()).func_177952_p() == 7;
            if (gX && this.container.getCircuitAt(this.getPos().func_177971_a((Vec3i)RedstoneUtils.correctOffset(new BlockPos(1, 0, 0), this.getFace())), this.getFace()) == null || gZ && this.container.getCircuitAt(this.getPos().func_177971_a((Vec3i)RedstoneUtils.correctOffset(new BlockPos(0, 0, 1), this.getFace())), this.getFace()) == null || gX && gZ && this.container.getCircuitAt(this.getPos().func_177971_a((Vec3i)RedstoneUtils.correctOffset(new BlockPos(1, 0, 1), this.getFace())), this.getFace()) == null) {
                return null;
            }
            return this;
        }
        return this.container.getCircuitAt(this.getPos().func_177971_a((Vec3i)coords.getKey()), this.getFace());
    }

    @Override
    public byte getInput(EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return this.container.getInput(side, color, bundled);
    }

    @Override
    public void rotate(Rotation rotation) {
        int j;
        int i;
        Function<Object, Object> rotatePos;
        switch (rotation) {
            case CLOCKWISE_90: {
                rotatePos = p -> new BlockPos(6 - p.func_177952_p(), p.func_177956_o(), p.func_177958_n());
                break;
            }
            case CLOCKWISE_180: {
                rotatePos = p -> new BlockPos(6 - p.func_177958_n(), p.func_177956_o(), 6 - p.func_177952_p());
                break;
            }
            case COUNTERCLOCKWISE_90: {
                rotatePos = p -> new BlockPos(p.func_177952_p(), p.func_177956_o(), 6 - p.func_177958_n());
                break;
            }
            default: {
                rotatePos = Function.identity();
            }
        }
        EnumCircuitIOMode[] ioModes2 = new EnumCircuitIOMode[this.ioModes.length];
        for (int i2 = 0; i2 < this.ioModes.length; ++i2) {
            ioModes2[EnumCircuitSide.HORIZONTALS[i2].rotate((Rotation)rotation).ordinal() - 2] = this.ioModes[i2];
        }
        System.arraycopy(ioModes2, 0, this.ioModes, 0, this.ioModes.length);
        HashSet rotated = new HashSet();
        IComponent[][][][] components = new IComponent[8][5][8][7];
        this.forEach(rotated::add, true);
        rotated.forEach((? super T c) -> c.rotatePre(rotation));
        rotated.forEach((? super T c) -> {
            BlockPos pos = (BlockPos)rotatePos.apply(c.getPos());
            for (EnumComponentSlot s : c.getSlots()) {
                components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][s.ordinal()] = c;
            }
            c.setPos(pos);
        });
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 4; ++j) {
                components[i][j][7] = this.components[i][j][7];
                components[7][j][i] = this.components[7][j][i];
            }
        }
        this.components = components;
        rotated.forEach((? super T c) -> c.rotatePost());
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 4; ++j) {
                for (EnumComponentSlot s : EnumComponentSlot.VALUES) {
                    IComponent c2 = this.getComponent(new BlockPos(i, j, -1), s);
                    if (c2 != null) {
                        c2.onNeighborChange(EnumCircuitSide.FRONT, s, components[i][j][0][s.ordinal()], EnumCircuitUpdate.CIRCUIT_ROTATE);
                    }
                    if ((c2 = this.getComponent(new BlockPos(i, j, 7), s)) != null) {
                        c2.onNeighborChange(EnumCircuitSide.BACK, s, components[i][j][6][s.ordinal()], EnumCircuitUpdate.CIRCUIT_ROTATE);
                    }
                    if ((c2 = this.getComponent(new BlockPos(-1, j, i), s)) != null) {
                        c2.onNeighborChange(EnumCircuitSide.LEFT, s, components[0][j][i][s.ordinal()], EnumCircuitUpdate.CIRCUIT_ROTATE);
                    }
                    if ((c2 = this.getComponent(new BlockPos(7, j, i), s)) == null) continue;
                    c2.onNeighborChange(EnumCircuitSide.RIGHT, s, components[6][j][i][s.ordinal()], EnumCircuitUpdate.CIRCUIT_ROTATE);
                }
            }
        }
        this.markDirty();
        this.container.sendUpdatePacket();
    }

    @Override
    public void sendCustomPayload(BlockPos pos, EnumComponentSlot slot, ByteBuf buf) {
        this.container.sendCustomPayload(pos, slot, buf);
    }

    @Override
    public boolean isEncapsulated() {
        return this.container.isEncapsulated();
    }

    public void handleCustomPayload(BlockPos pos, EnumComponentSlot slot, ByteBuf buf) {
        IComponent c = this.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][slot.ordinal()];
        if (c != null) {
            c.handleCustomPayload(buf);
        }
    }

    public void forEach(Consumer<IComponent> consumer) {
        this.forEach(consumer, false);
    }

    public void forEach(Consumer<IComponent> consumer, BiFunction<IComponent, Throwable, RuntimeException> errorHandler) {
        this.forEach(consumer, false, errorHandler);
    }

    public void forEach(Consumer<IComponent> consumer, boolean limitTo7x7) {
        this.forEach(consumer, limitTo7x7, (a, b) -> Throwables.propagate((Throwable)b));
    }

    public void forEach(Consumer<IComponent> consumer, boolean limitTo7x7, BiFunction<IComponent, Throwable, RuntimeException> errorHandler) {
        HashSet<IComponent> visited = new HashSet<IComponent>();
        int size = limitTo7x7 ? 7 : 8;
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < 5; ++y) {
                for (int z = 0; z < size; ++z) {
                    for (int s = 0; s < 7; ++s) {
                        IComponent c = this.components[x][y][z][s];
                        if (c == null || !visited.add(c)) continue;
                        try {
                            consumer.accept(c);
                            continue;
                        }
                        catch (HandledCircuitException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            RuntimeException ex = errorHandler.apply(c, e);
                            if (ex == null) continue;
                            throw ex;
                        }
                    }
                }
            }
        }
    }

    public void forEachEdge(Consumer<IComponent> consumer, EnumCircuitSide edge, int startY, int endY, EnumComponentSlot ... slots) {
        block13: {
            block15: {
                block14: {
                    block12: {
                        if (edge != EnumCircuitSide.RIGHT) break block12;
                        for (int z = 0; z < 7; ++z) {
                            for (int y = startY; y <= endY; ++y) {
                                for (EnumComponentSlot s : slots) {
                                    IComponent c = this.components[0][y][z][s.ordinal()];
                                    if (c == null) continue;
                                    consumer.accept(c);
                                }
                            }
                        }
                        break block13;
                    }
                    if (edge != EnumCircuitSide.LEFT) break block14;
                    for (int z = 0; z < 7; ++z) {
                        for (int y = startY; y <= endY; ++y) {
                            for (EnumComponentSlot s : slots) {
                                IComponent c = this.components[6][y][z][s.ordinal()];
                                if (c == null) continue;
                                consumer.accept(c);
                            }
                        }
                    }
                    break block13;
                }
                if (edge != EnumCircuitSide.BACK) break block15;
                for (int x = 0; x < 7; ++x) {
                    for (int y = startY; y <= endY; ++y) {
                        for (EnumComponentSlot s : slots) {
                            IComponent c = this.components[x][y][0][s.ordinal()];
                            if (c == null) continue;
                            consumer.accept(c);
                        }
                    }
                }
                break block13;
            }
            if (edge != EnumCircuitSide.FRONT) break block13;
            for (int x = 0; x < 7; ++x) {
                for (int y = startY; y <= endY; ++y) {
                    for (EnumComponentSlot s : slots) {
                        IComponent c = this.components[x][y][6][s.ordinal()];
                        if (c == null) continue;
                        consumer.accept(c);
                    }
                }
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList components = new NBTTagList();
        HashSet<IComponent> visited = new HashSet<IComponent>();
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 5; ++y) {
                for (int z = 0; z < 8; ++z) {
                    for (int s = 0; s < 7; ++s) {
                        IComponent c = this.components[x][y][z][s];
                        if (c == null || !visited.add(c)) continue;
                        NBTTagCompound t = new NBTTagCompound();
                        c.writeToNBT(t);
                        t.func_74778_a("__type", c.getName().toString());
                        t.func_74772_a("__pos", c.getPos().func_177986_g());
                        components.func_74742_a((NBTBase)t);
                    }
                }
            }
        }
        visited.clear();
        tag.func_74782_a("components", (NBTBase)components);
        tag.func_74768_a("componentsVersion", 2);
        NBTTagCompound updates = new NBTTagCompound();
        this.scheduledTicks.forEach((? super K k, ? super V v) -> {
            NBTTagCompound tickUpdates = new NBTTagCompound();
            v.forEach((? super K c, ? super V u) -> {
                NBTTagCompound t = new NBTTagCompound();
                u.forEach((? super K m, ? super V o) -> {
                    NBTTagCompound d = c.serializeTickData((int)m, o);
                    if (d != null) {
                        t.func_74782_a(m + "", (NBTBase)d);
                    }
                });
                tickUpdates.func_74782_a(c.getPos().func_177986_g() + "_" + ((EnumComponentSlot)((Object)((Object)((Object)c.getSlots().iterator().next())))).name().toLowerCase(), (NBTBase)t);
            });
            updates.func_74782_a(k - this.container.getWorld().func_82737_E() + "", (NBTBase)tickUpdates);
        });
        tag.func_74782_a("updates", (NBTBase)updates);
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("crash", ((EnumCircuitCrashStatus)((Object)this.crash.getLeft())).ordinal());
        if (this.crash.getLeft() == EnumCircuitCrashStatus.UPLOADED) {
            tag.func_74778_a("crashInfo", (String)this.crash.getRight());
        }
        tag.func_74783_a("iomodes", new int[]{this.ioModes[0].ordinal(), this.ioModes[1].ordinal(), this.ioModes[2].ordinal(), this.ioModes[3].ordinal()});
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.readFromNBT(tag, false);
    }

    public void readFromNBT(NBTTagCompound tag, boolean notify) {
        int i;
        int componentsVersion;
        NBTTagList components = tag.func_150295_c("components", 10);
        int n = componentsVersion = tag.func_74764_b("componentsVersion") ? tag.func_74762_e("componentsVersion") : 1;
        if (componentsVersion == 1) {
            i = 0;
            for (int x = 0; x < 8; ++x) {
                int x_ = x;
                for (int y = 0; y < 5; ++y) {
                    int y_ = y;
                    for (int z = 0; z < 8; ++z) {
                        int z_ = z;
                        BlockPos pos = null;
                        for (int s = 0; s < 7; ++s) {
                            IComponent c;
                            NBTTagCompound t = components.func_150305_b(i);
                            if (t.func_74764_b("__type") && (c = ComponentRegistry.INSTANCE.getFactory(new ResourceLocation(t.func_74779_i("__type"))).instantiate(this)) != null) {
                                c.setPos(pos == null ? new BlockPos(x, y, z) : pos);
                                c.readFromNBT(t);
                                c.getSlots().forEach((? super T slot) -> {
                                    this.components[x_][y_][z_][slot.ordinal()] = c;
                                });
                            }
                            ++i;
                        }
                    }
                }
            }
        } else if (componentsVersion == 2) {
            for (i = 0; i < components.func_74745_c(); ++i) {
                NBTTagCompound t = components.func_150305_b(i);
                IComponent c = ComponentRegistry.INSTANCE.getFactory(new ResourceLocation(t.func_74779_i("__type"))).instantiate(this);
                if (c == null) continue;
                BlockPos pos = BlockPos.func_177969_a((long)t.func_74763_f("__pos"));
                c.setPos(pos);
                c.readFromNBT(t);
                c.getSlots().forEach((? super T slot) -> {
                    this.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][slot.ordinal()] = c;
                });
            }
        }
        this.scheduledTicks.clear();
        NBTTagCompound updates = tag.func_74775_l("updates");
        updates.func_150296_c().forEach((? super T s1) -> {
            NBTTagCompound tickUpdates = updates.func_74775_l(s1);
            long time = Long.parseLong(s1);
            HashMap map = new HashMap();
            tickUpdates.func_150296_c().forEach((? super T s2) -> {
                String[] s3 = s2.split("_");
                BlockPos pos = BlockPos.func_177969_a((long)Long.parseLong(s3[0]));
                EnumComponentSlot slot = EnumComponentSlot.valueOf(s3[1].toUpperCase());
                IComponent c = this.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][slot.ordinal()];
                if (c != null) {
                    HashMap m = new HashMap();
                    NBTTagCompound d = tickUpdates.func_74775_l(s2);
                    d.func_150296_c().forEach((? super T s4) -> {
                        int type = Integer.parseInt(s4);
                        m.put(type, c.deserializeTickData(type, d.func_74775_l(s4)));
                    });
                    map.put(c, m);
                }
            });
            this.scheduledTicks.put(time, map);
        });
        this.scheduledOffset = true;
        if (tag.func_74764_b("name")) {
            this.name = tag.func_74779_i("name");
        }
        if (tag.func_74764_b("crash")) {
            this.crash.setLeft((Object)EnumCircuitCrashStatus.values()[tag.func_74762_e("crash")]);
            if (tag.func_74764_b("crashInfo")) {
                this.crash.setRight((Object)tag.func_74779_i("crashInfo"));
            }
        }
        if (tag.func_74764_b("iomodes")) {
            int[] iomodes = tag.func_74759_k("iomodes");
            for (int i2 = 0; i2 < 4; ++i2) {
                this.ioModes[i2] = EnumCircuitIOMode.values()[iomodes[i2]];
            }
        }
        if (notify) {
            this.forEach(IComponent::onLoaded);
        }
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        HashSet<IComponent> visited = new HashSet<IComponent>();
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 5; ++y) {
                for (int z = 0; z < 8; ++z) {
                    for (int s = 0; s < 7; ++s) {
                        IComponent c = this.components[x][y][z][s];
                        if (c == null) {
                            buf.writeBoolean(false);
                            continue;
                        }
                        buf.writeBoolean(true);
                        if (visited.add(c)) {
                            buf.writeBoolean(true);
                            buf.func_180714_a(c.getName().toString());
                            c.writeDescription(buf);
                            continue;
                        }
                        buf.writeBoolean(false);
                    }
                }
            }
        }
        buf.func_179249_a((Enum)this.ioModes[0]).func_179249_a((Enum)this.ioModes[1]).func_179249_a((Enum)this.ioModes[2]).func_179249_a((Enum)this.ioModes[3]);
        visited.clear();
        buf.func_180714_a(this.name);
    }

    public void readUpdatePacket(PacketBuffer buf) {
        HashSet<IComponent> newComponents = new HashSet<IComponent>();
        for (int x = 0; x < 8; ++x) {
            int x_ = x;
            for (int y = 0; y < 5; ++y) {
                int y_ = y;
                for (int z = 0; z < 8; ++z) {
                    int z_ = z;
                    BlockPos pos = null;
                    for (int s = 0; s < 7; ++s) {
                        if (buf.readBoolean()) {
                            boolean wasThere;
                            if (!buf.readBoolean()) continue;
                            IComponent c = this.components[x][y][z][s];
                            ResourceLocation name = new ResourceLocation(buf.func_150789_c(128));
                            boolean bl = wasThere = c != null && c.getName().equals((Object)name);
                            if (!wasThere) {
                                c = ComponentRegistry.INSTANCE.getFactory(name).instantiate(this);
                                c.setPos(pos == null ? new BlockPos(x, y, z) : pos);
                                c.readDescription(buf);
                                IComponent c_ = c;
                                c.getSlots().forEach((? super T slot) -> {
                                    this.components[x_][y_][z_][slot.ordinal()] = c_;
                                });
                                newComponents.add(c);
                                continue;
                            }
                            c.readDescription(buf);
                            continue;
                        }
                        this.components[x][y][z][s] = null;
                    }
                }
            }
        }
        this.ioModes[0] = (EnumCircuitIOMode)buf.func_179257_a(EnumCircuitIOMode.class);
        this.ioModes[1] = (EnumCircuitIOMode)buf.func_179257_a(EnumCircuitIOMode.class);
        this.ioModes[2] = (EnumCircuitIOMode)buf.func_179257_a(EnumCircuitIOMode.class);
        this.ioModes[3] = (EnumCircuitIOMode)buf.func_179257_a(EnumCircuitIOMode.class);
        newComponents.forEach(IComponent::onLoaded);
        newComponents.clear();
        this.name = buf.func_150789_c(16);
    }

    public void tickScheduled() {
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            long now = this.getWorld().func_82737_E();
            if (this.scheduledOffset) {
                this.scheduledOffset = false;
                this.scheduledTicks.forEach((? super K t, ? super V m) -> this.scheduledTicksBkp.put(t + now, (Map<IComponent, Map<Integer, Object>>)m));
                Map<Long, Map<IComponent, Map<Integer, Object>>> tmp = this.scheduledTicks;
                this.scheduledTicks = this.scheduledTicksBkp;
                this.scheduledTicksBkp = tmp;
            }
            HashSet<Long> removed = new HashSet<Long>();
            this.iterating = true;
            for (Map.Entry<Long, Map<IComponent, Map<Integer, Object>>> e : this.scheduledTicks.entrySet()) {
                if (e.getKey() > now) break;
                e.getValue().forEach((? super K c, ? super V u) -> u.forEach((? super K t, ? super V d) -> c.onScheduledTick((int)t, d)));
                removed.add(e.getKey());
            }
            removed.forEach(this.scheduledTicks::remove);
            removed.clear();
            this.iterating = false;
            this.scheduledTicksBkp.forEach((? super K k, ? super V v) -> this.scheduledTicks.merge((Long)k, (Map<IComponent, Map<Integer, Object>>)v, (m1, m2) -> {
                m2.forEach((? super K k1, ? super V v1) -> m1.merge(k1, v1, (m3, m4) -> {
                    m3.putAll(m4);
                    return m3;
                }));
                return m1;
            }));
            this.scheduledTicksBkp.clear();
        }
    }

    public void tick() {
        this.forEach(IComponent::tick, (c, e) -> {
            this.container.spawnMagicSmoke(c.getPos());
            return new HandledCircuitException((Throwable)e);
        });
    }

    public void tickEnd() {
        this.nonInteractable.clear();
    }

    public boolean isEmpty() {
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 5; ++y) {
                for (int z = 0; z < 8; ++z) {
                    for (int s = 0; s < 7; ++s) {
                        IComponent c = this.components[x][y][z][s];
                        if (c == null) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void clear() {
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 5; ++y) {
                for (int z = 0; z < 8; ++z) {
                    for (int s = 0; s < 7; ++s) {
                        this.components[x][y][z][s] = null;
                    }
                }
            }
        }
        this.container.onCleared();
        this.container.notifyNeighbors();
        this.crash.setLeft((Object)EnumCircuitCrashStatus.NO_CRASH);
        this.crash.setRight(null);
    }

    public byte getOutput(EnumCircuitSide cside, EnumDyeColor color, boolean bundled) {
        AtomicInteger power = new AtomicInteger(0);
        this.forEachEdge(c -> {
            if (c.isOutput(EnumComponentSlot.BOTTOM, cside) && c.isStrongOutput(EnumComponentSlot.BOTTOM, cside)) {
                if (!bundled && c.getBundledConnection(EnumComponentSlot.BOTTOM, cside) == IRedstoneConductor.EnumConnectionType.NONE) {
                    for (EnumDyeColor col : EnumDyeColor.values()) {
                        power.set(Math.max(power.get(), c.getOutputSignal(EnumComponentSlot.BOTTOM, cside, col, false) & 0xFF));
                    }
                } else {
                    power.set(Math.max(power.get(), c.getOutputSignal(EnumComponentSlot.BOTTOM, cside, color, true) & 0xFF));
                }
            }
        }, cside, 0, 0, EnumComponentSlot.BOTTOM);
        return (byte)power.get();
    }

    @Override
    public void spawnMagicSmoke(BlockPos pos) {
        this.container.spawnMagicSmoke(pos);
    }

    @Override
    public void spawnStack(ItemStack stack) {
        this.container.spawnStack(stack);
    }

    @Override
    public float computeComplexity() {
        AtomicDouble complexity = new AtomicDouble(0.0);
        this.forEach(c -> complexity.addAndGet((double)c.getComplexity()));
        return complexity.floatValue();
    }

    public static int getSize(float complexity) {
        if (complexity <= 1.0f) {
            return 1;
        }
        if (complexity <= 4.0f) {
            return 2;
        }
        if (complexity <= 9.0f) {
            return 3;
        }
        return -1;
    }

    public void onCrash(Throwable throwable) {
        if (this.crash.getLeft() == EnumCircuitCrashStatus.NO_CRASH) {
            this.crash.setLeft((Object)EnumCircuitCrashStatus.UPLOADING);
            new Thread(() -> {
                HashMap<String, String> data = new HashMap<String, String>();
                String crashlog = ExceptionUtils.getStackTrace((Throwable)throwable);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    NBTTagCompound tag = new NBTTagCompound();
                    this.writeToNBT(tag);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)baos);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to save circuit!", e);
                }
                String blueprint = new String(Base64.getEncoder().encode(baos.toByteArray()));
                data.put("crashlog", crashlog);
                data.put("blueprint", blueprint);
                try {
                    URL url = GistPublisher.publish(data);
                    this.crash.setLeft((Object)EnumCircuitCrashStatus.UPLOADED);
                    this.crash.setRight((Object)url.toString());
                }
                catch (Exception e) {
                    this.crash.setLeft((Object)EnumCircuitCrashStatus.UPLOAD_ERROR);
                    File crashDir = new File("./crash-reports/scm");
                    crashDir.mkdirs();
                    crashDir.mkdirs();
                    String time = new Date().toString().replace(" ", "_").replace(":", ".");
                    try {
                        File logFile = new File(crashDir, time + ".log");
                        logFile.createNewFile();
                        PrintWriter logWriter = new PrintWriter(logFile);
                        throwable.printStackTrace(logWriter);
                        logWriter.close();
                        File schematicFile = new File(crashDir, time + ".scm");
                        schematicFile.createNewFile();
                        PrintWriter schematicWriter = new PrintWriter(schematicFile);
                        schematicWriter.write(blueprint);
                        schematicWriter.close();
                        this.crash.setRight((Object)time);
                    }
                    catch (Exception ex) {
                        SCM.log.catching((Throwable)ex);
                    }
                }
            }).start();
        }
    }

    public Pair<EnumCircuitCrashStatus, String> getCrash() {
        return Pair.of((Object)this.crash.getLeft(), (Object)this.crash.getRight());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name.trim();
        this.container.markDirty();
        this.container.sendUpdatePacket();
    }

    public boolean canInteractWith(IComponent component) {
        return !this.nonInteractable.contains(component);
    }
}

