/*
 * Decompiled with CFR 0.152.
 */
package zairus.hermitquest.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.hermitquest.HermitQuest;
import zairus.hermitquest.block.BlockTeaCup;
import zairus.hermitquest.block.HQBlocks;
import zairus.hermitquest.item.HQItems;

public class ItemCup
extends Item {
    private static final int RECHARGE_TICKS = 6000;
    private int cupType;

    public ItemCup() {
        this.func_77625_d(1);
        this.func_77637_a(HermitQuest.hqTab);
    }

    public ItemCup setCupType(int type) {
        this.cupType = type;
        return this;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        ActionResult result = new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        int timer = this.getStackTime(itemStack);
        if (timer >= 6000) {
            player.func_184598_c(hand);
            result = new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return result;
    }

    private int getStackTime(ItemStack stack) {
        int timer = 0;
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (!tag.func_74764_b("rechargeTimer")) {
                tag.func_74768_a("rechargeTimer", 0);
            }
            timer = tag.func_74762_e("rechargeTimer");
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("rechargeTimer", 0);
            stack.func_77982_d(tag);
        }
        return timer;
    }

    private void setStackTime(ItemStack stack, int time) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (!tag.func_74764_b("rechargeTimer")) {
                tag.func_74768_a("rechargeTimer", 0);
            }
            tag.func_74768_a("rechargeTimer", time);
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("rechargeTimer", 0);
            stack.func_77982_d(tag);
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos blockpos;
        Block cupBlock = null;
        cupBlock = stack.func_77973_b() == HQItems.CUP_TEA ? HQBlocks.TEA_CUP : HQBlocks.COFFEE_MUG;
        boolean flag = world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
        BlockPos blockPos = blockpos = flag ? pos : pos.func_177972_a(facing);
        if (player.func_175151_a(blockpos, facing, stack) && world.func_175716_a(world.func_180495_p(blockpos).func_177230_c(), blockpos, false, facing, (Entity)null, stack) && cupBlock.func_176196_c(world, blockpos)) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            IBlockState state = cupBlock.func_176223_P();
            EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
            state = state.func_177226_a((IProperty)BlockTeaCup.FACING, (Comparable)enumfacing);
            world.func_180501_a(blockpos, state, 3);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Nullable
    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        EntityPlayer entityplayer;
        EntityPlayer entityPlayer = entityplayer = entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null;
        if (!world.field_72995_K) {
            ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
            switch (this.cupType) {
                case 1: {
                    effects.add(new PotionEffect(MobEffects.field_76424_c, 600, 2));
                    effects.add(new PotionEffect(MobEffects.field_76438_s, 600, 0));
                    break;
                }
                default: {
                    effects.add(new PotionEffect(MobEffects.field_76443_y, 600, 0));
                    effects.add(new PotionEffect(MobEffects.field_76424_c, 600, 0));
                }
            }
            for (PotionEffect effect : effects) {
                entityLiving.func_70690_d(effect);
            }
            if (entityplayer == null || !entityplayer.field_71075_bZ.field_75098_d) {
                this.setStackTime(stack, 0);
            }
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        int time = this.getStackTime(stack);
        if (time < 6000) {
            this.setStackTime(stack, ++time);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (this.getStackTime(stack) < 6000) {
            tooltip.add("Empty");
            tooltip.add("Refilling...");
        } else {
            tooltip.add("Full");
            tooltip.add("Take a sip");
        }
    }
}

