/*
 * Decompiled with CFR 0.152.
 */
package zairus.hermitquest.biome.decorate;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import zairus.hermitquest.biome.decorate.WorldGenDecorationBase;

public class WorldGenPlant
extends WorldGenDecorationBase {
    private IBlockState plant;
    private List<IBlockState> allowedBlocks;

    public WorldGenPlant(IBlockState genPlant) {
        this.plant = genPlant;
        this.initAllowedBlocks();
    }

    @Override
    public List<Biome> getAllowedBiomes() {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        biomes.add(Biomes.field_76782_w);
        biomes.add(Biomes.field_150574_L);
        biomes.add(Biomes.field_76792_x);
        biomes.add(Biomes.field_185446_X);
        biomes.add(Biomes.field_185447_Y);
        return biomes;
    }

    public WorldGenPlant setAllowedBlocks(IBlockState ... states) {
        this.allowedBlocks = new ArrayList<IBlockState>();
        for (IBlockState s : states) {
            this.allowedBlocks.add(s);
        }
        return this;
    }

    private void initAllowedBlocks() {
        this.allowedBlocks = new ArrayList<IBlockState>();
        this.allowedBlocks.add(Blocks.field_150346_d.func_176223_P());
        this.allowedBlocks.add(Blocks.field_150349_c.func_176223_P());
    }

    @Override
    public boolean doGenerate(World world, Random rand, BlockPos pos) {
        if (!this.allowedBlocks.contains(world.func_180495_p(pos).func_177230_c().func_176223_P())) {
            return false;
        }
        if (rand.nextInt(this.rarity) != 0) {
            return false;
        }
        this.setBlockInWorld(world, pos.func_177984_a(), this.plant);
        return true;
    }
}

