/*
 * Decompiled with CFR 0.152.
 */
package zairus.hermitquest.biome.decorate;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import zairus.hermitquest.HQConfig;
import zairus.hermitquest.HermitQuest;

public abstract class WorldGenDecorationBase
extends WorldGenerator {
    private final GenerationType generationType;
    protected int rarity = 3;

    public WorldGenDecorationBase() {
        this(GenerationType.FINDGROUND);
    }

    public WorldGenDecorationBase(GenerationType t) {
        this.generationType = t;
    }

    public WorldGenDecorationBase setRarity(int r) {
        this.rarity = r;
        return this;
    }

    public abstract List<Biome> getAllowedBiomes();

    protected abstract boolean doGenerate(World var1, Random var2, BlockPos var3);

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        switch (this.generationType) {
            case FINDGROUND: {
                pos = this.findGround(world, pos);
                break;
            }
            default: {
                pos = new BlockPos(pos.func_177958_n(), rand.nextInt(255), pos.func_177952_p());
            }
        }
        boolean generated = this.doGenerate(world, rand, pos);
        if (generated && HQConfig.output_generation_log) {
            HermitQuest.logger.info("generated: [" + ((Object)((Object)this)).getClass().getName() + "]" + pos);
        }
        return generated;
    }

    public BlockPos findGround(World world, BlockPos pos) {
        BlockPos groundPos = new BlockPos(pos.func_177958_n(), 255, pos.func_177952_p());
        while (world.func_175623_d(groundPos) && (groundPos = groundPos.func_177977_b()).func_177956_o() > 0) {
        }
        return groundPos;
    }

    public boolean setBlockInWorld(World world, BlockPos pos, IBlockState state) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        world.func_175656_a(pos, state);
        return true;
    }

    public BlockPos findBlockInArea(World world, BlockPos center, int areaExpand, int height, IBlockState match, boolean surface) {
        BlockPos pos = null;
        block0: for (int x = -areaExpand; x <= areaExpand; ++x) {
            for (int z = -areaExpand; z <= areaExpand; ++z) {
                for (int y = height; y >= (surface ? 0 : -height); --y) {
                    if (!world.func_175667_e(center.func_177982_a(x, y, z)) || world.func_180495_p(center.func_177982_a(x, y, z)) != match) continue;
                    pos = center.func_177982_a(x, y, z);
                    break block0;
                }
            }
        }
        return pos;
    }

    public static enum GenerationType {
        FINDGROUND,
        ANYWHERE;

    }
}

