/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import elec332.core.util.IElecItemHandler;
import elec332.core.util.InventoryHelper;
import elec332.core.util.ItemStackHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

public class BasicItemHandler
implements IElecItemHandler,
INBTSerializable<NBTTagCompound> {
    protected List<ItemStack> stacks;

    public BasicItemHandler() {
        this(1);
    }

    public BasicItemHandler(int size) {
        this.stacks = InventoryHelper.newItemStackList(size);
    }

    public BasicItemHandler(List<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public void setSize(int size) {
        this.stacks = InventoryHelper.newItemStackList(size);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        ItemStack stackInSlot = this.stacks.get(slot);
        if (ItemStack.func_77989_b((ItemStack)stackInSlot, (ItemStack)stack) || !this.isStackValidForSlot(slot, stack)) {
            return;
        }
        this.stacks.set(slot, stack);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.stacks.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (!ItemStackHelper.isStackValid(stack)) {
            return ItemStackHelper.NULL_STACK;
        }
        if (!this.canInsert(slot, stack) || !this.isStackValidForSlot(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (ItemStackHelper.isStackValid(existing)) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.field_77994_a;
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.field_77994_a > limit;
        if (!simulate) {
            if (!ItemStackHelper.isStackValid(existing)) {
                this.stacks.set(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.field_77994_a = existing.field_77994_a + (reachedLimit ? limit : stack.field_77994_a);
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - limit)) : ItemStackHelper.NULL_STACK;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || !this.canExtract(slot)) {
            return ItemStackHelper.NULL_STACK;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.stacks.get(slot);
        if (!ItemStackHelper.isStackValid(existing)) {
            return ItemStackHelper.NULL_STACK;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.field_77994_a <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, ItemStackHelper.NULL_STACK);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.field_77994_a - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public NBTTagCompound serializeNBT() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size());
        InventoryHelper.readItemsFromNBT(nbt, this.stacks);
        this.onLoad();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound tag = InventoryHelper.writeItemsToNBT(compound, this.stacks);
        tag.func_74768_a("Size", this.stacks.size());
        return tag;
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }

    public boolean isStackValidForSlot(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public boolean canExtract(int slot) {
        return true;
    }

    public boolean canInsert(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public void clear() {
        this.stacks.clear();
    }
}

