/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.collect.Lists;
import elec332.core.main.ElecCore;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ASMHelper {
    private static int count = 0;
    private static final ASMClassLoader ASMCLASSLOADER = new ASMClassLoader();

    private ASMHelper() {
    }

    public static <T> Class<? extends T> makeImplementInterfaces(Class<T> original, Class<?> clazz, IClassModifier classModifier, Class<?> ... exceptions) {
        MethodVisitor mv;
        ArrayList itf = Lists.newArrayList((Object[])exceptions);
        ClassWriter cw = new ClassWriter(0);
        ArrayList ifs = Lists.newArrayList((Object[])clazz.getInterfaces());
        ifs.removeAll(itf);
        Class[] interfaces = ifs.toArray(new Class[0]);
        String[] interfaceNames = new String[interfaces.length];
        String superType = ASMHelper.getInternalName(original);
        String clazzType = ASMHelper.getInternalName(clazz);
        String clazzNN = original.getName();
        for (int i = 0; i < interfaces.length; ++i) {
            Class interfaceC = interfaces[i];
            clazzNN = clazzNN + "_" + interfaceC.getSimpleName();
            interfaceNames[i] = ASMHelper.getInternalName(interfaceC);
        }
        String name = ASMHelper.getASMName(clazzNN);
        String internalName = "generated/" + name.replace('.', '/');
        String instanceDesc = Type.getDescriptor(Object.class);
        cw.visit(52, 33, internalName, null, ASMHelper.getInternalName(original), interfaceNames);
        cw.visitSource(".dynamic", null);
        cw.visitField(1, "instance", instanceDesc, null, null).visitEnd();
        for (Constructor<?> constructor : original.getConstructors()) {
            String cTorDescSuper = "(";
            Class<?>[] classArray = constructor.getParameterTypes();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> c = classArray[i];
                cTorDescSuper = cTorDescSuper + Type.getDescriptor(c);
            }
            cTorDescSuper = cTorDescSuper + ")V";
            String mycTorDesc = cTorDescSuper.replace("(", "(" + instanceDesc);
            mv = cw.visitMethod(1, "<init>", mycTorDesc, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, internalName, "instance", instanceDesc);
            mv.visitVarInsn(25, 0);
            for (int i = 2; i < constructor.getParameterCount() + 2; ++i) {
                mv.visitVarInsn(Type.getType(constructor.getParameterTypes()[i - 2]).getOpcode(21), i);
            }
            mv.visitMethodInsn(183, superType, "<init>", cTorDescSuper, false);
            mv.visitInsn(177);
            mv.visitMaxs(constructor.getParameterCount() + 2, constructor.getParameterCount() + 2);
            mv.visitEnd();
        }
        for (GenericDeclaration genericDeclaration : interfaces) {
            for (Method m : ((Class)genericDeclaration).getMethods()) {
                mv = cw.visitMethod(1, m.getName(), ASMHelper.getMethodDescriptor(m), null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, internalName, "instance", instanceDesc);
                mv.visitTypeInsn(192, ASMHelper.getInternalName(genericDeclaration));
                for (int i = 0; i < m.getParameterCount(); ++i) {
                    mv.visitVarInsn(Type.getType(m.getParameterTypes()[i]).getOpcode(21), i + 1);
                }
                mv.visitMethodInsn(185, ASMHelper.getInternalName(genericDeclaration), m.getName(), ASMHelper.getMethodDescriptor(m), true);
                Label l1 = new Label();
                Label l2 = new Label();
                mv.visitInsn(Type.getType(m.getReturnType()).getOpcode(172));
                int i = m.getParameterCount() + 1;
                for (int j = 1; j < m.getParameterCount() + 1; ++j) {
                    mv.visitLocalVariable("o" + j, Type.getType(m.getParameterTypes()[j - 1]).getDescriptor(), null, l1, l2, j);
                }
                mv.visitMaxs(i, i);
                mv.visitEnd();
            }
        }
        if (classModifier != null) {
            cw = classModifier.modifyClass(internalName, cw, new Object[0]);
        }
        cw.visitEnd();
        File file = new File(ASMHelper.class.getProtectionDomain().getCodeSource().getLocation().getPath().replace(ASMHelper.class.getSimpleName(), "testBackup.class"));
        if (ElecCore.developmentEnvironment) {
            // empty if block
        }
        return ASMHelper.defineClass(internalName.replace('/', '.'), cw);
    }

    public static ClassReader getClassReaderFrom(Class<?> clazz) {
        try {
            ClassLoader correctLoader = ASMHelper.class.getClassLoader();
            return new ClassReader(correctLoader.getResourceAsStream(clazz.getName().replace('.', '/') + ".class"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMethodDescriptor(Method m) {
        return Type.getMethodDescriptor((Method)m);
    }

    public static String getInternalName(Class<?> clazz) {
        return Type.getInternalName(clazz);
    }

    public static String getInternalName(String clazz) {
        return clazz.replace('.', '/');
    }

    public static Class<?> defineClass(String name, ClassWriter classWriter) {
        return ASMHelper.defineClass(name, classWriter.toByteArray());
    }

    public static Class<?> defineClass(String name, byte[] data) {
        return ASMCLASSLOADER.defineClass(name, data);
    }

    private static String getASMName(String name) {
        return name + "_" + count++;
    }

    private static class ASMClassLoader
    extends ClassLoader {
        private ASMClassLoader() {
            super(ASMClassLoader.class.getClassLoader());
        }

        public Class<?> defineClass(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length);
        }
    }

    public static interface IClassModifier {
        public ClassWriter modifyClass(String var1, ClassWriter var2, Object ... var3);

        public static IClassModifier combine(final IClassModifier ... modifiers) {
            if (modifiers == null || modifiers.length == 0) {
                return null;
            }
            return new IClassModifier(){

                @Override
                public ClassWriter modifyClass(String internalClassName, ClassWriter cw, Object ... additionalData) {
                    for (IClassModifier classModifier : modifiers) {
                        if (classModifier == null) continue;
                        cw = classModifier.modifyClass(internalClassName, cw, additionalData);
                    }
                    return cw;
                }
            };
        }
    }
}

