/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.handler;

import com.google.common.collect.Lists;
import elec332.core.api.callback.CallbackProcessor;
import elec332.core.api.callback.ICallbackProcessor;
import elec332.core.api.callback.RegisteredCallback;
import elec332.core.api.discovery.ASMDataProcessor;
import elec332.core.api.util.StaticProxy;
import elec332.core.handler.AbstractAnnotationProcessor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.relauncher.Side;

@ASMDataProcessor(value={LoaderState.PREINITIALIZATION})
public class PreInitAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    protected void registerProcesses() {
        final ArrayList callbacks = Lists.newArrayList();
        final List callbacks_ = Collections.unmodifiableList(callbacks);
        this.registerDataProcessor(RegisteredCallback.class, new Consumer<ASMDataTable.ASMData>(){

            @Override
            public void accept(ASMDataTable.ASMData asmData) {
                Class<?> clazz = PreInitAnnotationProcessor.this.loadClass(asmData, false);
                if (clazz == null) {
                    return;
                }
                Object instance = PreInitAnnotationProcessor.this.instantiate(clazz, false, new Object[0]);
                if (instance == null) {
                    return;
                }
                callbacks.add(instance);
            }
        });
        this.registerDataProcessor(CallbackProcessor.class, new Consumer<ASMDataTable.ASMData>(){

            @Override
            public void accept(ASMDataTable.ASMData asmData) {
                Object instance = PreInitAnnotationProcessor.this.instantiate(PreInitAnnotationProcessor.this.loadClass(asmData), new Object[0]);
                if (instance instanceof ICallbackProcessor) {
                    ((ICallbackProcessor)instance).getCallbacks(callbacks_);
                }
            }
        });
        this.registerDataProcessor(StaticProxy.class, new Consumer<ASMDataTable.ASMData>(){

            @Override
            public void accept(ASMDataTable.ASMData asmData) {
                try {
                    String proxyClazzName;
                    Class<?> clazz = PreInitAnnotationProcessor.this.loadClass(asmData, false);
                    if (clazz == null) {
                        AbstractAnnotationProcessor.logger.error("Error injecting proxy: " + asmData.getClassName());
                        return;
                    }
                    Field f = clazz.getDeclaredField(asmData.getObjectName());
                    f.setAccessible(true);
                    StaticProxy proxyA = f.getAnnotation(StaticProxy.class);
                    Side side = FMLCommonHandler.instance().getSide();
                    String string = proxyClazzName = side.isClient() ? proxyA.clientSide() : proxyA.serverSide();
                    if (proxyClazzName.equals("")) {
                        proxyClazzName = asmData.getClassName() + (side.isClient() ? "$ClientProxy" : "$ServerProxy");
                    }
                    Object proxy = Class.forName(proxyClazzName).newInstance();
                    if ((f.getModifiers() & 8) != 0) {
                        AbstractAnnotationProcessor.logger.error("Field " + f.getName() + " in class " + clazz.getCanonicalName() + " is not static, skipping proxy injection...");
                        return;
                    }
                    if (!f.getType().isAssignableFrom(proxy.getClass())) {
                        throw new IllegalArgumentException();
                    }
                    f.set(null, proxy);
                }
                catch (Exception e) {
                    AbstractAnnotationProcessor.logger.error("Error injecting proxy: ");
                    AbstractAnnotationProcessor.logger.error((Object)e);
                }
            }
        });
    }
}

