/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.effects.api.ability;

import elec332.core.effects.api.ElecCoreAbilitiesAPI;
import elec332.core.effects.api.ability.Ability;
import elec332.core.effects.api.util.AbilityHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;

public final class WrappedAbility {
    private final Ability ability;
    private int strength;
    private int duration;

    public WrappedAbility(Ability ability, int duration) {
        this(ability, duration, 1);
    }

    public WrappedAbility(Ability ability, int duration, int strength) {
        this.ability = ability;
        this.strength = Math.min(strength, ability.getMaxLevel());
        this.duration = duration;
        if (ability.isInstant()) {
            this.duration = 1;
        }
    }

    public final void onActivated(EntityLivingBase entity) {
        this.ability.onEffectAddedToEntity(entity, this);
    }

    public final void onRemoved(EntityLivingBase entity) {
        this.ability.onEffectRemovedFromEntity(entity, this);
    }

    public final void onUpdate(EntityLivingBase entity) {
        this.ability.updateEffectOnEntity(entity, this);
        --this.duration;
        if (this.duration <= 0) {
            AbilityHelper.removeEffectFromEntity(entity, this);
        }
    }

    public void applyTo(EntityLivingBase entity) {
        AbilityHelper.addEffectToEntity(entity, this.copyOf());
    }

    public WrappedAbility copyOf() {
        return new WrappedAbility(this.ability, this.duration, this.strength);
    }

    public Ability getAbility() {
        return this.ability;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isInstant() {
        return this.ability.isInstant();
    }

    public final void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("ability", this.ability.getName());
        tagCompound.func_74768_a("strength", this.strength);
        tagCompound.func_74768_a("duration", this.duration);
    }

    public void mergeWith(WrappedAbility otherAbility) {
        if (otherAbility == null || otherAbility.ability != this.ability) {
            return;
        }
        this.duration = otherAbility.duration;
        this.strength = otherAbility.strength;
    }

    public static WrappedAbility readEffectFromNBT(NBTTagCompound tagCompound) {
        String s = tagCompound.func_74779_i("ability");
        Ability ability = ElecCoreAbilitiesAPI.getApi().getEffectFromName(s);
        if (ability != null) {
            return new WrappedAbility(ability, tagCompound.func_74762_e("duration"), tagCompound.func_74762_e("strength"));
        }
        return null;
    }
}

