/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.effects;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import elec332.core.effects.EntityAbilityProperties;
import elec332.core.effects.api.ElecCoreAbilitiesAPI;
import elec332.core.effects.api.IElecCoreAbilitiesAPI;
import elec332.core.effects.api.ability.Ability;
import elec332.core.effects.api.ability.WrappedAbility;
import elec332.core.effects.api.util.AbilityHelper;
import elec332.core.effects.api.util.IAbilityPacket;
import elec332.core.effects.defaultabilities.Climb;
import elec332.core.effects.defaultabilities.FireResistance;
import elec332.core.effects.defaultabilities.Flight;
import elec332.core.effects.defaultabilities.Invisibility;
import elec332.core.effects.defaultabilities.Jump;
import elec332.core.effects.defaultabilities.PowerStrike;
import elec332.core.effects.defaultabilities.QuickStrike;
import elec332.core.effects.defaultabilities.QuickSwimming;
import elec332.core.effects.defaultabilities.WaterBreathing;
import elec332.core.effects.network.PacketSyncAbilities;
import elec332.core.main.ElecCore;
import elec332.core.server.ServerHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class AbilityHandler
implements IElecCoreAbilitiesAPI {
    public static final AbilityHandler instance = new AbilityHandler();
    private Map<String, Ability> effectMap = Maps.newHashMap();
    private boolean shouldActivate = false;

    private AbilityHandler() {
    }

    @Override
    public void registerEffect(Ability ability) {
        if (ability == null) {
            throw new IllegalArgumentException("You cannot register a null ability!");
        }
        if (this.effectMap.containsKey(ability.getName())) {
            throw new IllegalArgumentException("There is already a registered ability with ID: " + ability.getName());
        }
        this.effectMap.put(ability.getName(), ability);
    }

    @Override
    public Ability getEffectFromName(String name) {
        return this.effectMap.get(name);
    }

    @Override
    public void requestActivation() {
        this.shouldActivate = true;
    }

    @Override
    public boolean willBeActivated() {
        if (!Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            throw new IllegalAccessError();
        }
        return this.shouldActivate;
    }

    @Override
    public boolean isRegistered(Ability ability) {
        if (ability == null) {
            return false;
        }
        for (Map.Entry<String, Ability> entry : this.effectMap.entrySet()) {
            if (!entry.getKey().equals(ability.getName()) || entry.getValue() != ability) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Ability> getRegisteredAbilities() {
        return ImmutableList.copyOf(this.effectMap.values());
    }

    public void init() {
        if (this.shouldActivate) {
            MinecraftForge.EVENT_BUS.register((Object)new EffectsTickHandler());
            MinecraftForge.EVENT_BUS.register((Object)new EffectsSyncHandler());
            this.initDefaultAbilities();
            ElecCore.networkHandler.registerClientPacket(PacketSyncAbilities.class);
        }
    }

    public void syncAbilityDataToClient(EntityLivingBase entity, WrappedAbility ability, IAbilityPacket.PacketType packetType) {
        NBTTagCompound toSend = new NBTTagCompound();
        ability.writeToNBT(toSend);
        for (EntityPlayerMP player : ServerHelper.instance.getAllPlayersWatchingBlock(entity.func_130014_f_(), (int)entity.field_70165_t, (int)entity.field_70161_v)) {
            ElecCore.networkHandler.sendTo((IMessage)new PacketSyncAbilities(entity, toSend, packetType), player);
        }
    }

    private void initDefaultAbilities() {
        this.registerEffect(new Climb());
        this.registerEffect(new FireResistance());
        this.registerEffect(new Flight());
        this.registerEffect(new Invisibility());
        this.registerEffect(new Jump());
        this.registerEffect(new PowerStrike());
        this.registerEffect(new QuickStrike());
        this.registerEffect(new QuickSwimming());
        this.registerEffect(new WaterBreathing());
    }

    private static class AbilityCapabilityDispatcher
    implements ICapabilityProvider,
    INBTSerializable<NBTTagCompound> {
        private AbilityCapabilityDispatcher() {
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == ElecCoreAbilitiesAPI.ABILITIES_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == ElecCoreAbilitiesAPI.ABILITIES_CAPABILITY ? new EntityAbilityProperties() : null);
        }

        public NBTTagCompound serializeNBT() {
            return null;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
        }
    }

    public static class EffectsSyncHandler {
        @SubscribeEvent
        public void onEntityConstructing(AttachCapabilitiesEvent.Entity event) {
            if (event.getEntity() instanceof EntityLivingBase) {
                event.addCapability(new ResourceLocation("ElecCore", "AbilitiesAPI"), (ICapabilityProvider)new AbilityCapabilityDispatcher());
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            this.syncEffects((EntityLivingBase)event.player);
        }

        @SubscribeEvent
        public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            this.syncEffects((EntityLivingBase)event.player);
        }

        @SubscribeEvent
        public void onPlayerSpawn(PlayerEvent.PlayerRespawnEvent event) {
            this.syncEffects((EntityLivingBase)event.player);
        }

        private void syncEffects(EntityLivingBase entity) {
            EntityAbilityProperties properties = (EntityAbilityProperties)AbilityHelper.getHandler(entity);
            if (properties == null) {
                throw new RuntimeException();
            }
            for (WrappedAbility ability : properties.activeEffects) {
                instance.syncAbilityDataToClient(entity, ability, IAbilityPacket.PacketType.SYNC);
            }
        }
    }

    public static class EffectsTickHandler {
        @SubscribeEvent
        public void updateEntity(LivingEvent.LivingUpdateEvent event) {
            AbilityHelper.getHandler(event.getEntityLiving()).updateEffects();
        }
    }
}

