/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartModel;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.tile.inventory.AppEngNullInventory;
import appeng.util.Platform;
import appeng.util.inv.WrapperChainedInventory;
import appeng.util.inv.WrapperMCISidedInventory;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;

public class PartP2PItems
extends PartP2PTunnel<PartP2PItems>
implements ISidedInventory,
IGridTickable {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_items");
    private final LinkedList<IInventory> which = new LinkedList();
    private int oldSize = 0;
    private boolean requested;
    private IInventory cachedInv;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public PartP2PItems(ItemStack is) {
        super(is);
    }

    @Override
    public void onNeighborChanged() {
        this.cachedInv = null;
        PartP2PItems input = (PartP2PItems)this.getInput();
        if (input != null && this.isOutput()) {
            input.onTunnelNetworkChange();
        }
    }

    private IInventory getDestination() {
        TunnelCollection itemTunnels;
        this.requested = true;
        if (this.cachedInv != null) {
            return this.cachedInv;
        }
        LinkedList<IInventory> outs = new LinkedList<IInventory>();
        try {
            itemTunnels = this.getOutputs();
        }
        catch (GridAccessException e) {
            return new AppEngNullInventory();
        }
        for (PartP2PItems t : itemTunnels) {
            IInventory inv = t.getOutputInv();
            if (inv == null) continue;
            if (Platform.getRandomInt() % 2 == 0) {
                outs.add(inv);
                continue;
            }
            outs.add(0, inv);
        }
        this.cachedInv = new WrapperChainedInventory(outs);
        return this.cachedInv;
    }

    private IInventory getOutputInv() {
        IInventory output = null;
        if (this.getProxy().isActive()) {
            TileEntity te = this.getTile().func_145831_w().func_175625_s(this.getTile().func_174877_v().func_177972_a(this.getSide().getFacing()));
            if (this.which.contains(this)) {
                return null;
            }
            this.which.add((IInventory)this);
            if (output == null) {
                if (te instanceof TileEntityChest) {
                    output = Platform.GetChestInv(te);
                } else if (te instanceof ISidedInventory) {
                    output = new WrapperMCISidedInventory((ISidedInventory)te, this.getSide().getFacing().func_176734_d());
                } else if (te instanceof IInventory) {
                    output = (IInventory)te;
                }
            }
            this.which.pop();
        }
        return output;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ItemTunnel.getMin(), TickRates.ItemTunnel.getMax(), false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        boolean wasReq = this.requested;
        if (this.requested && this.cachedInv != null) {
            ((WrapperChainedInventory)this.cachedInv).cycleOrder();
        }
        this.requested = false;
        return wasReq ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    @MENetworkEventSubscribe
    public void changeStateA(MENetworkBootingStatusChange bs) {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().func_70302_i_();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        }
    }

    @MENetworkEventSubscribe
    public void changeStateB(MENetworkChannelsChanged bs) {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().func_70302_i_();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        }
    }

    @MENetworkEventSubscribe
    public void changeStateC(MENetworkPowerStatusChange bs) {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().func_70302_i_();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        }
    }

    @Override
    public void onTunnelNetworkChange() {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().func_70302_i_();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        } else {
            PartP2PItems input = (PartP2PItems)this.getInput();
            if (input != null) {
                input.getHost().notifyNeighbors();
            }
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] slots = new int[this.func_70302_i_()];
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            slots[x] = x;
        }
        return slots;
    }

    public int func_70302_i_() {
        return this.getDestination().func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.getDestination().func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.getDestination().func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.getDestination().func_70299_a(i, itemstack);
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.getDestination().func_70297_j_();
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_174889_b(EntityPlayer p) {
    }

    public void func_174886_c(EntityPlayer p) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.getDestination().func_94041_b(i, itemstack);
    }

    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing j) {
        return this.getDestination().func_94041_b(i, itemstack);
    }

    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing j) {
        return false;
    }

    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

