/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.AEApi;
import appeng.api.util.AEAxisAlignedBB;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.effects.LightningFX;
import appeng.client.render.renderable.ItemRenderable;
import appeng.client.render.tesr.ModularTESR;
import appeng.core.AEConfig;
import appeng.core.CommonHelper;
import appeng.helpers.ICustomCollision;
import appeng.tile.misc.TileCharger;
import appeng.util.Platform;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class BlockCharger
extends AEBaseTileBlock
implements ICustomCollision {
    public BlockCharger() {
        super(Material.field_151573_f);
        this.setTileEntity(TileCharger.class);
        this.func_149713_g(2);
        this.setFullSize(this.setOpaque(false));
    }

    @Override
    public boolean onActivated(World w, BlockPos pos, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileCharger tc;
        if (player.func_70093_af()) {
            return false;
        }
        if (Platform.isServer() && (tc = (TileCharger)this.getTileEntity((IBlockAccess)w, pos)) != null) {
            tc.activate(player);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World w, BlockPos pos, Random r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        if ((double)r.nextFloat() < 0.98) {
            return;
        }
        Object tile = this.getTileEntity((IBlockAccess)w, pos);
        if (tile instanceof TileCharger) {
            TileCharger tc = (TileCharger)tile;
            if (AEApi.instance().definitions().materials().certusQuartzCrystalCharged().isSameAs(tc.func_70301_a(0))) {
                double xOff = 0.0;
                double yOff = 0.0;
                double zOff = 0.0;
                for (int bolts = 0; bolts < 3; ++bolts) {
                    if (!CommonHelper.proxy.shouldAddParticles(r)) continue;
                    LightningFX fx = new LightningFX(w, 0.5 + (double)pos.func_177958_n(), 0.5 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), 0.0, 0.0, 0.0);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
                }
            }
        }
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, BlockPos pos, Entity thePlayer, boolean b) {
        TileCharger tile = (TileCharger)this.getTileEntity((IBlockAccess)w, pos);
        if (tile != null) {
            double twoPixels = 0.125;
            EnumFacing up = tile.getUp();
            EnumFacing forward = tile.getForward();
            AEAxisAlignedBB bb = new AEAxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
            if (up.func_82601_c() != 0) {
                bb.minX = 0.0;
                bb.maxX = 1.0;
            }
            if (up.func_96559_d() != 0) {
                bb.minY = 0.0;
                bb.maxY = 1.0;
            }
            if (up.func_82599_e() != 0) {
                bb.minZ = 0.0;
                bb.maxZ = 1.0;
            }
            switch (forward) {
                case DOWN: {
                    bb.maxY = 1.0;
                    break;
                }
                case UP: {
                    bb.minY = 0.0;
                    break;
                }
                case NORTH: {
                    bb.maxZ = 1.0;
                    break;
                }
                case SOUTH: {
                    bb.minZ = 0.0;
                    break;
                }
                case EAST: {
                    bb.minX = 0.0;
                    break;
                }
                case WEST: {
                    bb.maxX = 1.0;
                    break;
                }
            }
            return Collections.singletonList(bb.getBoundingBox());
        }
        return Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public void addCollidingBlockToList(World w, BlockPos pos, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        out.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @SideOnly(value=Side.CLIENT)
    public static TileEntitySpecialRenderer<TileCharger> createTesr() {
        return new ModularTESR<TileCharger>(new ItemRenderable<TileCharger>(BlockCharger::getRenderedItem));
    }

    @SideOnly(value=Side.CLIENT)
    private static Pair<ItemStack, Matrix4f> getRenderedItem(TileCharger tile) {
        Matrix4f transform = new Matrix4f();
        transform.translate(new Vector3f(0.5f, 0.4f, 0.5f));
        return new ImmutablePair((Object)tile.func_70301_a(0), (Object)transform);
    }
}

