/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mercurius;

import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.mercurius.IMinecraftBinding;
import net.minecraftforge.mercurius.Mercurius;
import net.minecraftforge.mercurius.binding.ClientBinding;
import net.minecraftforge.mercurius.binding.ModConfigGui;
import net.minecraftforge.mercurius.binding.ServerBinding;
import net.minecraftforge.mercurius.utils.Commands;
import net.minecraftforge.mercurius.utils.GameEnvironment;

@Mod(modid="mercurius", name="Mercurius", version="1.0.1", guiFactory="net.minecraftforge.mercurius.StatsMod$GuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class StatsMod {
    public static final String MODID = "mercurius";
    public static final String MODNAME = "Mercurius";
    public static final String VERSION = "1.0.1";
    public static final String GUIFACTORY = "net.minecraftforge.mercurius.StatsMod$GuiFactory";
    @Mod.Instance(value="mercurius")
    public static StatsMod instance;
    public static IMinecraftBinding binding;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        binding = e.getSide() == Side.CLIENT ? new ClientBinding(e.getModConfigurationDirectory()) : new ServerBinding(e.getModConfigurationDirectory());
        Mercurius.bootstrap(binding);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        FMLCommonHandler.instance().bus().register((Object)new ConnectionEvents());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        try {
            Mercurius.getSender().collectData(Commands.START, true);
            Mercurius.getSender().startTimer();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        try {
            Mercurius.getSender().collectData(Commands.START, true);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent e) {
        try {
            Mercurius.getSender().collectData(Commands.STOP, true);
            Mercurius.getSender().cancelTimer();
            Mercurius.getBinding().resetSessionID();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public class ConnectionEvents {
        @SubscribeEvent
        public void onConnectionOpened(FMLNetworkEvent.ClientConnectedToServerEvent e) {
            try {
                if (!e.isLocal()) {
                    Mercurius.getSender().collectData(Commands.START, true, GameEnvironment.SERVER_NON_LOCAL);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        @SubscribeEvent
        public void disconnectedFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
            try {
                if (!e.getManager().func_150731_c()) {
                    Mercurius.getSender().collectData(Commands.STOP, true, GameEnvironment.SERVER_NON_LOCAL);
                    Mercurius.getBinding().resetSessionID();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static class GuiFactory
    implements IModGuiFactory {
        public Class<? extends GuiScreen> mainConfigGuiClass() {
            return ModConfigGui.class;
        }

        public void initialize(Minecraft minecraftInstance) {
        }

        public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
            return null;
        }

        public IModGuiFactory.RuntimeOptionGuiHandler getHandlerFor(IModGuiFactory.RuntimeOptionCategoryElement element) {
            return null;
        }
    }
}

