/*
 * Decompiled with CFR 0.152.
 */
package elucent.roots.network;

import elucent.roots.Roots;
import elucent.roots.component.ComponentBase;
import elucent.roots.component.ComponentManager;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSpellCastFX
implements IMessage {
    static Random random = new Random();
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;
    public float lx = 0.0f;
    public float ly = 0.0f;
    public float lz = 0.0f;
    public String name = "";

    public MessageSpellCastFX() {
    }

    public MessageSpellCastFX(String name, float x, float y, float z, Vec3d look) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.lx = (float)look.field_72450_a;
        this.ly = (float)look.field_72448_b;
        this.lz = (float)look.field_72449_c;
    }

    public void fromBytes(ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.x = buf.readFloat();
        this.y = buf.readFloat();
        this.z = buf.readFloat();
        this.lx = buf.readFloat();
        this.ly = buf.readFloat();
        this.lz = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        buf.writeFloat(this.x);
        buf.writeFloat(this.y);
        buf.writeFloat(this.z);
        buf.writeFloat(this.lx);
        buf.writeFloat(this.ly);
        buf.writeFloat(this.lz);
    }

    public static class MessageHolder
    implements IMessageHandler<MessageSpellCastFX, IMessage> {
        public IMessage onMessage(final MessageSpellCastFX message, MessageContext ctx) {
            Minecraft mainThread = ctx.side.isClient() ? Minecraft.func_71410_x() : (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ComponentBase comp = ComponentManager.getComponentFromName(message.name);
                    for (int i = 0; i < 90; ++i) {
                        double offX = (double)random.nextFloat() * 0.5 - 0.25;
                        double offY = (double)random.nextFloat() * 0.5 - 0.25;
                        double offZ = (double)random.nextFloat() * 0.5 - 0.25;
                        double coeff = (offX + offY + offZ) / 1.5 + 0.5;
                        double dx = ((double)message.lx + offX) * coeff;
                        double dy = ((double)message.ly + offY) * coeff;
                        double dz = ((double)message.lz + offZ) * coeff;
                        if (random.nextBoolean()) {
                            Roots.proxy.spawnParticleMagicFX((World)Minecraft.func_71410_x().field_71441_e, (double)message.x + dx, (double)message.y + 1.5 + dy, (double)message.z + dz, dx, dy, dz, comp.primaryColor.field_72450_a, comp.primaryColor.field_72448_b, comp.primaryColor.field_72449_c);
                            continue;
                        }
                        Roots.proxy.spawnParticleMagicFX((World)Minecraft.func_71410_x().field_71441_e, (double)message.x + dx, (double)message.y + 1.5 + dy, (double)message.z + dz, dx, dy, dz, comp.secondaryColor.field_72450_a, comp.secondaryColor.field_72448_b, comp.secondaryColor.field_72449_c);
                    }
                }
            });
            return null;
        }
    }
}

