/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.io.File;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import yalter.mousetweaks.Config;
import yalter.mousetweaks.Constants;
import yalter.mousetweaks.IGuiScreenHandler;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.MouseButton;
import yalter.mousetweaks.OnTickMethod;
import yalter.mousetweaks.Reflection;
import yalter.mousetweaks.WheelScrollDirection;
import yalter.mousetweaks.WheelSearchOrder;
import yalter.mousetweaks.api.IMTModGuiContainer;
import yalter.mousetweaks.api.IMTModGuiContainer2;
import yalter.mousetweaks.api.IMTModGuiContainer2Ex;
import yalter.mousetweaks.handlers.GuiContainerCreativeHandler;
import yalter.mousetweaks.handlers.GuiContainerHandler;
import yalter.mousetweaks.handlers.IMTModGuiContainer2ExHandler;
import yalter.mousetweaks.handlers.IMTModGuiContainer2Handler;
import yalter.mousetweaks.handlers.IMTModGuiContainerHandler;

public class Main {
    private static boolean liteLoader = false;
    private static boolean forge = false;
    public static Config config;
    public static OnTickMethod onTickMethod;
    private static bcx mc;
    private static bft oldGuiScreen;
    private static acc oldSelectedSlot;
    private static acc firstRightClickedSlot;
    private static boolean oldRMBDown;
    private static boolean disableForThisContainer;
    private static boolean disableWheelForThisContainer;
    private static IGuiScreenHandler handler;
    private static boolean readConfig;
    private static boolean initialized;
    private static boolean disabled;

    public static boolean initialize(Constants.EntryPoint entryPoint) {
        Logger.Log("A call to initialize, entry point: " + entryPoint.toString() + ".");
        if (disabled) {
            return false;
        }
        if (initialized) {
            return true;
        }
        initialized = true;
        mc = bcx.z();
        config = new Config(Main.mc.w + File.separator + "config" + File.separator + "MouseTweaks.cfg");
        config.read();
        Reflection.reflectGuiContainer();
        boolean bl = forge = entryPoint == Constants.EntryPoint.FORGE || Reflection.doesClassExist("net.minecraftforge.client.MinecraftForgeClient");
        if (forge) {
            Logger.Log("Minecraft Forge is installed.");
        } else {
            Logger.Log("Minecraft Forge is not installed.");
        }
        boolean bl2 = liteLoader = entryPoint == Constants.EntryPoint.LITELOADER || Reflection.doesClassExist("com.mumfrey.liteloader.core.LiteLoader");
        if (liteLoader) {
            Logger.Log("LiteLoader is installed.");
        } else {
            Logger.Log("LiteLoader is not installed.");
        }
        if (!Main.findOnTickMethod(true)) {
            disabled = true;
            return false;
        }
        Logger.Log("Mouse Tweaks has been initialized.");
        return true;
    }

    public static boolean findOnTickMethod(boolean print_always) {
        OnTickMethod previous_method = onTickMethod;
        for (OnTickMethod method : Main.config.onTickMethodOrder) {
            switch (method) {
                case FORGE: {
                    if (!forge) break;
                    onTickMethod = OnTickMethod.FORGE;
                    if (print_always || onTickMethod != previous_method) {
                        Logger.Log("Using Forge for the mod operation.");
                    }
                    return true;
                }
                case LITELOADER: {
                    if (!liteLoader) break;
                    onTickMethod = OnTickMethod.LITELOADER;
                    if (print_always || onTickMethod != previous_method) {
                        Logger.Log("Using LiteLoader for the mod operation.");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static void onUpdateInGame() {
        bft currentScreen = Main.mc.m;
        if (currentScreen == null) {
            oldGuiScreen = null;
            oldSelectedSlot = null;
            firstRightClickedSlot = null;
            disableForThisContainer = false;
            disableWheelForThisContainer = false;
            readConfig = true;
            handler = null;
        } else {
            if (readConfig) {
                readConfig = false;
                config.read();
                Main.findOnTickMethod(false);
            }
            Main.onUpdateInGui(currentScreen);
        }
        oldRMBDown = Mouse.isButtonDown((int)1);
    }

    private static void onUpdateInGui(bft currentScreen) {
        adz stackOnMouse;
        adz targetStack;
        if (oldGuiScreen != currentScreen) {
            oldGuiScreen = currentScreen;
            Logger.DebugLog("You have just opened " + currentScreen.getClass().getSimpleName() + ".");
            handler = Main.findHandler(currentScreen);
            if (handler == null) {
                disableForThisContainer = true;
                Logger.DebugLog("No valid handler found; MT is disabled.");
                return;
            }
            disableForThisContainer = handler.isMouseTweaksDisabled();
            disableWheelForThisContainer = handler.isWheelTweakDisabled();
            Logger.DebugLog("Handler: " + handler.getClass().getSimpleName() + "; MT is " + (disableForThisContainer ? "disabled" : "enabled") + "; wheel tweak is " + (disableWheelForThisContainer ? "disabled" : "enabled") + ".");
        }
        if (!(Main.config.rmbTweak || Main.config.lmbTweakWithItem || Main.config.lmbTweakWithoutItem || Main.config.wheelTweak)) {
            return;
        }
        if (disableForThisContainer) {
            return;
        }
        acc selectedSlot = handler.getSlotUnderMouse();
        if (Mouse.isButtonDown((int)1)) {
            if (!oldRMBDown) {
                firstRightClickedSlot = selectedSlot;
            }
            if (Main.config.rmbTweak && handler.disableRMBDraggingFunctionality() && firstRightClickedSlot != null && (firstRightClickedSlot != selectedSlot || oldSelectedSlot == selectedSlot) && !handler.isIgnored(firstRightClickedSlot) && !handler.isCraftingOutput(firstRightClickedSlot)) {
                targetStack = firstRightClickedSlot.d();
                stackOnMouse = Main.mc.h.bt.o();
                if (stackOnMouse != null && Main.areStacksCompatible(stackOnMouse, targetStack) && firstRightClickedSlot.a(stackOnMouse)) {
                    handler.clickSlot(firstRightClickedSlot, MouseButton.RIGHT, false);
                }
            }
        } else {
            firstRightClickedSlot = null;
        }
        if (oldSelectedSlot != selectedSlot) {
            boolean shiftIsDown;
            oldSelectedSlot = selectedSlot;
            if (selectedSlot == null) {
                return;
            }
            if (firstRightClickedSlot == selectedSlot) {
                firstRightClickedSlot = null;
            }
            Logger.DebugLog("You have selected a new slot, it's slot number is " + selectedSlot.e);
            targetStack = Main.copyStack(selectedSlot.d());
            stackOnMouse = Main.copyStack(Main.mc.h.bt.o());
            boolean bl = shiftIsDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (Mouse.isButtonDown((int)1)) {
                if (Main.config.rmbTweak && !handler.isIgnored(selectedSlot) && !handler.isCraftingOutput(selectedSlot) && stackOnMouse != null && Main.areStacksCompatible(stackOnMouse, targetStack) && selectedSlot.a(stackOnMouse)) {
                    handler.clickSlot(selectedSlot, MouseButton.RIGHT, false);
                }
            } else if (Mouse.isButtonDown((int)0)) {
                if (stackOnMouse != null) {
                    if (Main.config.lmbTweakWithItem && !handler.isIgnored(selectedSlot) && targetStack != null && Main.areStacksCompatible(stackOnMouse, targetStack)) {
                        if (shiftIsDown) {
                            handler.clickSlot(selectedSlot, MouseButton.LEFT, true);
                        } else if (stackOnMouse.b + targetStack.b <= stackOnMouse.c()) {
                            handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                            if (!handler.isCraftingOutput(selectedSlot)) {
                                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                            }
                        }
                    }
                } else if (Main.config.lmbTweakWithoutItem && targetStack != null && shiftIsDown && !handler.isIgnored(selectedSlot)) {
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, true);
                }
            }
        }
        Main.handleWheel(selectedSlot);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void handleWheel(acc selectedSlot) {
        int numItemsToMove;
        int wheel;
        int n = wheel = Main.config.wheelTweak && !disableWheelForThisContainer ? Mouse.getDWheel() / 120 : 0;
        if (Main.config.wheelScrollDirection == WheelScrollDirection.INVERTED) {
            wheel = -wheel;
        }
        if ((numItemsToMove = Math.abs(wheel)) == 0) return;
        if (selectedSlot == null) return;
        if (handler.isIgnored(selectedSlot)) {
            return;
        }
        boolean pushItems = wheel < 0;
        adz stackOnMouse = Main.copyStack(Main.mc.h.bt.o());
        adz originalStack = Main.copyStack(selectedSlot.d());
        boolean isCraftingOutput = handler.isCraftingOutput(selectedSlot);
        if (originalStack == null) return;
        if (stackOnMouse != null && (isCraftingOutput ? !Main.areStacksCompatible(originalStack, stackOnMouse) : Main.areStacksCompatible(originalStack, stackOnMouse))) {
            return;
        }
        List<acc> slots = handler.getSlots();
        if (isCraftingOutput) {
            if (!pushItems) return;
            if (originalStack == null) {
                return;
            }
            acc applicableSlot = Main.findWheelApplicableSlot(slots, selectedSlot, pushItems);
            int i = 0;
            while (true) {
                if (i >= numItemsToMove) {
                    if (applicableSlot == null) return;
                    if (stackOnMouse != null) return;
                    handler.clickSlot(applicableSlot, MouseButton.LEFT, false);
                    return;
                }
                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                ++i;
            }
        }
        do {
            int i;
            adz stackFrom;
            adz stackTo;
            acc slotFrom;
            acc slotTo;
            acc applicableSlot;
            if ((applicableSlot = Main.findWheelApplicableSlot(slots, selectedSlot, pushItems)) == null) {
                return;
            }
            if (pushItems) {
                slotTo = applicableSlot;
                slotFrom = selectedSlot;
                stackTo = Main.copyStack(slotTo.d());
                stackFrom = Main.copyStack(slotFrom.d());
                numItemsToMove = Math.min(numItemsToMove, stackFrom.b);
                if (stackTo != null && stackTo.c() - stackTo.b <= numItemsToMove) {
                    handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                    handler.clickSlot(slotTo, MouseButton.LEFT, false);
                    handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                    numItemsToMove -= stackTo.c() - stackTo.b;
                    continue;
                }
                handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                if (stackFrom.b <= numItemsToMove) {
                    handler.clickSlot(slotTo, MouseButton.LEFT, false);
                } else {
                    for (i = 0; i < numItemsToMove; ++i) {
                        handler.clickSlot(slotTo, MouseButton.RIGHT, false);
                    }
                }
                handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                return;
            }
            slotTo = selectedSlot;
            slotFrom = applicableSlot;
            stackTo = Main.copyStack(slotTo.d());
            stackFrom = Main.copyStack(slotFrom.d());
            if (stackTo.b == stackTo.c()) {
                return;
            }
            if (stackTo.c() - stackTo.b <= numItemsToMove) {
                handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                handler.clickSlot(slotTo, MouseButton.LEFT, false);
                if (handler.isCraftingOutput(slotFrom)) continue;
                handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                continue;
            }
            handler.clickSlot(slotFrom, MouseButton.LEFT, false);
            if (handler.isCraftingOutput(slotFrom)) {
                handler.clickSlot(slotTo, MouseButton.LEFT, false);
                --numItemsToMove;
            } else if (stackFrom.b <= numItemsToMove) {
                handler.clickSlot(slotTo, MouseButton.LEFT, false);
                numItemsToMove -= stackFrom.b;
            } else {
                for (i = 0; i < numItemsToMove; ++i) {
                    handler.clickSlot(slotTo, MouseButton.RIGHT, false);
                }
                numItemsToMove = 0;
            }
            if (handler.isCraftingOutput(slotFrom)) continue;
            handler.clickSlot(slotFrom, MouseButton.LEFT, false);
        } while (numItemsToMove > 0);
    }

    private static IGuiScreenHandler findHandler(bft currentScreen) {
        if (currentScreen instanceof IMTModGuiContainer2Ex) {
            return new IMTModGuiContainer2ExHandler((IMTModGuiContainer2Ex)currentScreen);
        }
        if (currentScreen instanceof IMTModGuiContainer2) {
            return new IMTModGuiContainer2Handler((IMTModGuiContainer2)currentScreen);
        }
        if (currentScreen instanceof IMTModGuiContainer) {
            return new IMTModGuiContainerHandler((IMTModGuiContainer)currentScreen);
        }
        if (currentScreen instanceof bgu) {
            return new GuiContainerCreativeHandler((bgu)currentScreen);
        }
        if (currentScreen instanceof bgl) {
            return new GuiContainerHandler((bgl)currentScreen);
        }
        return null;
    }

    private static boolean areStacksCompatible(adz a, adz b) {
        return a == null || b == null || a.a(b) && adz.a((adz)a, (adz)b);
    }

    private static adz copyStack(adz stack) {
        return stack == null ? null : stack.k();
    }

    private static acc findWheelApplicableSlot(List<acc> slots, acc selectedSlot, boolean pushItems) {
        int direction;
        int endIndex;
        int startIndex;
        if (pushItems || Main.config.wheelSearchOrder == WheelSearchOrder.FIRST_TO_LAST) {
            startIndex = 0;
            endIndex = slots.size();
            direction = 1;
        } else {
            startIndex = slots.size() - 1;
            endIndex = -1;
            direction = -1;
        }
        adz originalStack = selectedSlot.d();
        boolean findInPlayerInventory = selectedSlot.d != Main.mc.h.bt;
        acc rv = null;
        for (int i = startIndex; i != endIndex; i += direction) {
            acc slot = slots.get(i);
            if (handler.isIgnored(slot) || (!findInPlayerInventory ? slot.d == Main.mc.h.bt : slot.d != Main.mc.h.bt)) continue;
            adz stack = slot.d();
            if (stack == null) {
                if (rv != null || !pushItems || !slot.a(originalStack) || handler.isCraftingOutput(slot)) continue;
                rv = slot;
                continue;
            }
            if (!Main.areStacksCompatible(originalStack, stack)) continue;
            if (pushItems) {
                if (handler.isCraftingOutput(slot) || stack.b >= stack.c()) continue;
                return slot;
            }
            return slot;
        }
        return rv;
    }

    static {
        oldGuiScreen = null;
        oldSelectedSlot = null;
        firstRightClickedSlot = null;
        oldRMBDown = false;
        disableForThisContainer = false;
        disableWheelForThisContainer = false;
        handler = null;
        readConfig = false;
        initialized = false;
        disabled = false;
    }
}

