/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.sonmok14.fromtheshadows.items.DiaboliumArmorItem;
import net.sonmok14.fromtheshadows.utils.registry.ItemRegistry;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;

public class PlagueArmorItem
extends GeoArmorItem
implements IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public PlagueArmorItem(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builder) {
        super(materialIn, slot, builder.m_41491_(CreativeModeTab.f_40757_));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        List slotData = event.getExtraDataOfType(EquipmentSlot.class);
        List stackData = event.getExtraDataOfType(ItemStack.class);
        LivingEntity livingEntity = (LivingEntity)event.getExtraDataOfType(LivingEntity.class).get(0);
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.diabolium.none", Boolean.valueOf(true)));
        if (livingEntity instanceof ArmorStand) {
            return PlayState.CONTINUE;
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ArrayList equipmentList = new ArrayList();
            player.m_20158_().forEach(x -> equipmentList.add(x.m_41720_()));
            List armorList = equipmentList.subList(2, 6);
            boolean isWearingAll = armorList.containsAll(Arrays.asList((DiaboliumArmorItem)((Object)ItemRegistry.DIABOLIUM_LEGGINGS.get())));
            return isWearingAll ? PlayState.CONTINUE : PlayState.STOP;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        Iterator itr = player.m_21221_().values().iterator();
        while (itr.hasNext()) {
            boolean i = true;
            MobEffectInstance effect = (MobEffectInstance)itr.next();
            MobEffect mobeffect = effect.m_19544_();
            if (effect == null || !player.m_21023_(mobeffect) || effect.m_19564_() != 0) continue;
            MobEffectInstance effectinstance = new MobEffectInstance(mobeffect, effect.m_19557_(), 1);
            player.m_7292_(effectinstance);
        }
        super.onArmorTick(stack, level, player);
    }
}

