/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GoToTargetLocation;
import net.minecraft.world.entity.ai.behavior.LongJumpMidJump;
import net.minecraft.world.entity.ai.behavior.LongJumpToRandomPos;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.schedule.Activity;
import net.sonmok14.fromtheshadows.entity.SculkBeast;
import net.sonmok14.fromtheshadows.entity.ai.SculkBeastRoar;
import net.sonmok14.fromtheshadows.entity.ai.SculkBeastRoarTarget;
import net.sonmok14.fromtheshadows.entity.ai.SculkBeastSniffing;
import net.sonmok14.fromtheshadows.entity.ai.SculkBeastTryToSniff;
import net.sonmok14.fromtheshadows.entity.ai.SetSculkBeastLookTarget;
import net.sonmok14.fromtheshadows.utils.registry.SensorRegistry;

public class SculkBeastAI {
    private static final UniformInt TIME_BETWEEN_LONG_JUMPS = UniformInt.m_146622_((int)600, (int)1200);
    public static final int MAX_LONG_JUMP_HEIGHT = 5;
    public static final int MAX_LONG_JUMP_WIDTH = 5;
    public static final float MAX_JUMP_VELOCITY = 1.5f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.5f;
    private static final float SPEED_MULTIPLIER_WHEN_INVESTIGATING = 0.7f;
    private static final float SPEED_MULTIPLIER_WHEN_FIGHTING = 1.2f;
    private static final int MELEE_ATTACK_COOLDOWN = 18;
    private static final int DIGGING_DURATION = Mth.m_14167_((float)100.0f);
    public static final int EMERGE_DURATION = Mth.m_14167_((float)133.59999f);
    public static final int ROAR_DURATION = 25;
    private static final int SNIFFING_DURATION = Mth.m_14167_((float)83.2f);
    public static final int DIGGING_COOLDOWN = 1200;
    private static final int DISTURBANCE_LOCATION_EXPIRY_TIME = 100;
    private static final List<SensorType<? extends Sensor<? super SculkBeast>>> SENSOR_TYPES = List.of(SensorType.f_26812_, (SensorType)SensorRegistry.GOLIATH_SENSOR.get());
    private static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.f_148204_, MemoryModuleType.f_148205_, MemoryModuleType.f_26368_, MemoryModuleType.f_148206_, MemoryModuleType.f_26333_, MemoryModuleType.f_26371_, MemoryModuleType.f_26370_, MemoryModuleType.f_26326_, MemoryModuleType.f_26377_, MemoryModuleType.f_26372_, MemoryModuleType.f_26373_, MemoryModuleType.f_148194_, MemoryModuleType.f_217782_, MemoryModuleType.f_217783_, MemoryModuleType.f_217784_, MemoryModuleType.f_217785_, MemoryModuleType.f_217786_, MemoryModuleType.f_217769_, MemoryModuleType.f_217770_, MemoryModuleType.f_217771_, MemoryModuleType.f_217772_, MemoryModuleType.f_217773_, MemoryModuleType.f_217774_, MemoryModuleType.f_217775_, MemoryModuleType.f_217776_, MemoryModuleType.f_217777_, MemoryModuleType.f_148199_, MemoryModuleType.f_148200_);
    private static final Behavior<SculkBeast> DIG_COOLDOWN_SETTER = new Behavior<SculkBeast>((Map)ImmutableMap.of((Object)MemoryModuleType.f_217770_, (Object)MemoryStatus.REGISTERED)){

        protected void start(ServerLevel p_219554_, SculkBeast p_219555_, long p_219556_) {
            SculkBeastAI.setDigCooldown((LivingEntity)p_219555_);
        }
    };

    protected static void initMemories(Goat p_218765_, RandomSource p_218766_) {
        p_218765_.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)TIME_BETWEEN_LONG_JUMPS.m_214085_(p_218766_));
    }

    public static void updateActivity(SculkBeast p_219513_) {
        p_219513_.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_219852_, (Object)Activity.f_219853_, (Object)Activity.f_219851_, (Object)Activity.f_37988_, (Object)Activity.f_219850_, (Object)Activity.f_219849_, (Object)Activity.f_37979_));
    }

    public static Brain<?> makeBrain(SculkBeast p_219521_, Dynamic<?> p_219522_) {
        Brain.Provider provider = Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
        Brain brain = provider.m_22073_(p_219522_);
        SculkBeastAI.initCoreActivity(p_219521_, (Brain<SculkBeast>)brain);
        SculkBeastAI.initIdleActivity((Brain<SculkBeast>)brain);
        SculkBeastAI.initRoarActivity((Brain<SculkBeast>)brain);
        SculkBeastAI.initLongJumpActivity((Brain<SculkBeast>)brain);
        SculkBeastAI.initFightActivity(p_219521_, (Brain<SculkBeast>)brain);
        SculkBeastAI.initInvestigateActivity((Brain<SculkBeast>)brain);
        SculkBeastAI.initSniffingActivity((Brain<SculkBeast>)brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(SculkBeast p_219518_, Brain<SculkBeast> p_219511_) {
        p_219511_.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)((Object)new SetSculkBeastLookTarget()), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<SculkBeast> p_219537_) {
        p_219537_.m_21891_(Activity.f_37979_, 10, ImmutableList.of(new SculkBeastRoarTarget<SculkBeast>(SculkBeast::getEntityAngryAt), (Object)((Object)new SculkBeastTryToSniff()), (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.f_217785_, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(0.8f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)))));
    }

    private static void initInvestigateActivity(Brain<SculkBeast> p_219542_) {
        p_219542_.m_21895_(Activity.f_219850_, 5, ImmutableList.of(new SculkBeastRoarTarget<SculkBeast>(SculkBeast::getEntityAngryAt), (Object)new GoToTargetLocation(MemoryModuleType.f_217783_, 2, 0.8f)), MemoryModuleType.f_217783_);
    }

    private static void initSniffingActivity(Brain<SculkBeast> p_219544_) {
        p_219544_.m_21895_(Activity.f_219849_, 5, ImmutableList.of(new SculkBeastRoarTarget<SculkBeast>(SculkBeast::getEntityAngryAt), new SculkBeastSniffing(SNIFFING_DURATION)), MemoryModuleType.f_217785_);
    }

    private static void initLongJumpActivity(Brain<SculkBeast> p_149462_) {
        p_149462_.m_21903_(Activity.f_150239_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new LongJumpMidJump(TIME_BETWEEN_LONG_JUMPS, SoundEvents.f_144151_)), (Object)Pair.of((Object)1, (Object)new LongJumpToRandomPos(TIME_BETWEEN_LONG_JUMPS, 5, 5, 1.5f, p_149476_ -> SoundEvents.f_144147_))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_148199_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initRoarActivity(Brain<SculkBeast> p_219546_) {
        p_219546_.m_21895_(Activity.f_219851_, 10, ImmutableList.of((Object)((Object)new SculkBeastRoar())), MemoryModuleType.f_217782_);
    }

    private static void initFightActivity(SculkBeast p_219518_, Brain<SculkBeast> p_219519_) {
        p_219519_.m_21895_(Activity.f_37988_, 10, ImmutableList.of(DIG_COOLDOWN_SETTER, (Object)new StopAttackingIfTargetInvalid(p_219540_ -> !p_219518_.getAngerLevel().m_219236_() || !p_219518_.canTargetEntity((Entity)p_219540_), SculkBeastAI::onTargetInvalid, false), (Object)new SetEntityLookTarget(p_219535_ -> SculkBeastAI.isTarget(p_219518_, p_219535_), (float)p_219518_.m_21133_(Attributes.f_22277_)), (Object)new SetWalkTargetFromAttackTargetIfTargetOutOfReach(1.2f)), MemoryModuleType.f_26372_);
    }

    private static boolean isTarget(SculkBeast p_219515_, LivingEntity p_219516_) {
        return p_219515_.m_6274_().m_21952_(MemoryModuleType.f_26372_).filter(p_219509_ -> p_219509_ == p_219516_).isPresent();
    }

    private static void onTargetInvalid(SculkBeast p_219529_, LivingEntity p_219530_) {
        if (!p_219529_.canTargetEntity((Entity)p_219530_)) {
            p_219529_.clearAnger((Entity)p_219530_);
            p_219529_.m_21561_(false);
        }
        SculkBeastAI.setDigCooldown((LivingEntity)p_219529_);
    }

    public static void setDigCooldown(LivingEntity p_219506_) {
        if (p_219506_.m_6274_().m_21874_(MemoryModuleType.f_217770_)) {
            p_219506_.m_6274_().m_21882_(MemoryModuleType.f_217770_, (Object)Unit.INSTANCE, 1200L);
        }
    }

    public static void setDisturbanceLocation(SculkBeast p_219524_, BlockPos p_219525_) {
        if (p_219524_.f_19853_.m_6857_().m_61937_(p_219525_) && !p_219524_.getEntityAngryAt().isPresent() && !p_219524_.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent()) {
            SculkBeastAI.setDigCooldown((LivingEntity)p_219524_);
            p_219524_.m_6274_().m_21882_(MemoryModuleType.f_217772_, (Object)Unit.INSTANCE, 100L);
            p_219524_.m_6274_().m_21882_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(p_219525_), 100L);
            p_219524_.m_6274_().m_21882_(MemoryModuleType.f_217783_, (Object)p_219525_, 100L);
            p_219524_.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        }
    }
}

