/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.entity;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.sonmok14.fromtheshadows.entity.FallingBlockEntity;
import net.sonmok14.fromtheshadows.entity.ScreenShakeEntity;
import net.sonmok14.fromtheshadows.entity.ai.SculkBeastAI;
import net.sonmok14.fromtheshadows.utils.registry.EffectRegistry;
import net.sonmok14.fromtheshadows.utils.registry.EntityRegistry;
import net.sonmok14.fromtheshadows.utils.registry.SoundRegistry;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SculkBeast
extends Monster
implements IAnimatable,
IAnimationTickable,
VibrationListener.VibrationListenerConfig {
    public int tendrilAnimation;
    public int tendrilAnimationO;
    public int attackID;
    public int attacktick;
    private int stunnedTick;
    public static final byte MELEEATTACK = 1;
    public static final byte SMASH_ATTACK = 2;
    public static final byte SONICBOOM = 3;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int GAME_EVENT_LISTENER_RANGE = 16;
    private static final int VIBRATION_COOLDOWN_TICKS = 40;
    private static final int TIME_TO_USE_MELEE_UNTIL_SONIC_BOOM = 200;
    private static final int MAX_HEALTH = 500;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.3f;
    private static final float KNOCKBACK_RESISTANCE = 1.0f;
    private static final float ATTACK_KNOCKBACK = 1.5f;
    private static final int ATTACK_DAMAGE = 30;
    private static final EntityDataAccessor<Integer> CLIENT_ANGER_LEVEL = SynchedEntityData.m_135353_(SculkBeast.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int DARKNESS_DISPLAY_LIMIT = 200;
    private static final int DARKNESS_DURATION = 260;
    private static final int DARKNESS_RADIUS = 20;
    private static final int DARKNESS_INTERVAL = 120;
    private static final int ANGERMANAGEMENT_TICK_DELAY = 20;
    private static final int DEFAULT_ANGER = 35;
    private static final int PROJECTILE_ANGER = 10;
    private static final int ON_HURT_ANGER_BOOST = 20;
    private static final int RECENT_PROJECTILE_TICK_THRESHOLD = 100;
    private static final int TOUCH_COOLDOWN_TICKS = 20;
    private static final int DIGGING_PARTICLES_AMOUNT = 30;
    private static final float DIGGING_PARTICLES_DURATION = 4.5f;
    private static final float DIGGING_PARTICLES_OFFSET = 0.7f;
    private static final int PROJECTILE_ANGER_DISTANCE = 30;
    private static final Predicate<Entity> NO_NEHEMOTH_AND_ALIVE = p_33346_ -> p_33346_.m_6084_() && !(p_33346_ instanceof SculkBeast);
    public AnimationState sniffAnimationState = new AnimationState();
    public AnimationState sonicBoomAnimationState = new AnimationState();
    private final DynamicGameEventListener<VibrationListener> dynamicGameEventListener;
    private AngerManagement angerManagement = new AngerManagement(this::canTargetEntity, Collections.emptyList());
    private final SculkSpreader sculkSpreader = SculkSpreader.m_222254_();
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_217003_(Pose.ROARING)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.roar", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && this.m_5912_() && this.attackID == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.run", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && this.attackID == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.attackID == 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.meleeattack", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.attackID == 2 && !this.m_20096_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.dash", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.attackID == 2 && this.m_20096_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.landing", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.stunnedTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.stun", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.attackID == 3) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.sonicboom", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate2(AnimationEvent<E> event) {
        if (this.tendrilAnimationO > 0 || this.m_217003_(Pose.SNIFFING)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.sensor", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.attackID == 3) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.sensor", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState predicate3(AnimationEvent<E> event) {
        if (this.m_217003_(Pose.SNIFFING) && this.attackID == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.idle2", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState predicate4(AnimationEvent<E> event) {
        if (this.m_5912_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.angry", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.warden.ambient", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public SculkBeast(EntityType<? extends SculkBeast> type, Level worldIn) {
        super(type, worldIn);
        this.dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationListener((PositionSource)new EntityPositionSource((Entity)this, this.m_20192_()), 16, (VibrationListener.VibrationListenerConfig)this, null, 0.0f, 0));
        this.f_19811_ = true;
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
    }

    public boolean m_5825_() {
        return true;
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)(-id));
    }

    protected void m_8024_() {
        ServerLevel serverlevel = (ServerLevel)this.f_19853_;
        serverlevel.m_46473_().m_6180_("GoliathBrain");
        this.m_6274_().m_21865_(serverlevel, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        super.m_8024_();
        if ((this.f_19797_ + this.m_19879_()) % 120 == 0) {
            SculkBeast.applyDarknessAround(serverlevel, this.m_20182_(), (Entity)this, 20);
        }
        if (this.f_19797_ % 20 == 0) {
            this.angerManagement.m_219263_(serverlevel, this::canTargetEntity);
            this.syncClientAngerLevel();
        }
        SculkBeastAI.updateActivity(this);
    }

    public static void applyDarknessAround(ServerLevel p_219376_, Vec3 p_219377_, @Nullable Entity p_219378_, int p_219379_) {
        MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.f_216964_, 260, 0, false, false);
        MobEffectUtil.m_216946_((ServerLevel)p_219376_, (Entity)p_219378_, (Vec3)p_219377_, (double)p_219379_, (MobEffectInstance)mobeffectinstance, (int)200);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22281_, 30.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, 9.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22283_, 2.0);
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 3.0f, this::predicate);
        AnimationController controller2 = new AnimationController((IAnimatable)this, "controller2", 3.0f, this::predicate2);
        AnimationController controller3 = new AnimationController((IAnimatable)this, "controller3", 12.0f, this::predicate3);
        AnimationController controller4 = new AnimationController((IAnimatable)this, "controller4", 0.0f, this::predicate4);
        controller.registerCustomInstructionListener(this::customListener);
        controller2.registerCustomInstructionListener(this::customListener);
        controller3.registerCustomInstructionListener(this::customListener);
        controller4.registerCustomInstructionListener(this::customListener);
        data.addAnimationController(controller);
        data.addAnimationController(controller2);
        data.addAnimationController(controller3);
        data.addAnimationController(controller4);
    }

    private <ENTITY extends IAnimatable> void customListener(CustomInstructionKeyframeEvent<ENTITY> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_5661_((Component)Component.m_237113_((String)"KeyFraming"), true);
        }
    }

    protected float m_6121_() {
        return 4.0f;
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.NEHEMOTH_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_215763_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215779_;
    }

    private void explode() {
        ServerLevel serverLevel = (ServerLevel)this.f_19853_;
        int radius = 4;
        int j = 4 + this.f_19853_.f_46441_.m_188503_(1);
        int k = 4 + this.f_19853_.f_46441_.m_188503_(1);
        int l = 4 + this.f_19853_.f_46441_.m_188503_(1);
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        float ff = f * f;
        double ffDouble = ff;
        BlockPos center = this.m_20183_();
        BlockState transformState = Blocks.f_220855_.m_49966_();
        BlockState transformState2 = (BlockState)Blocks.f_220856_.m_49966_().m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(true));
        this.m_5496_(SoundEvents.f_215740_, this.m_6121_(), this.m_6100_());
        BlockPos.m_121990_((BlockPos)center.m_7918_(-j, -k, -l), (BlockPos)center.m_7918_(j, k, l)).forEach(blockpos -> {
            if (blockpos.m_123331_((Vec3i)center) <= ffDouble && this.f_19853_.f_46441_.m_188501_() > (float)blockpos.m_123331_((Vec3i)center) / ff && this.f_19853_.m_8055_(blockpos).m_204336_(BlockTags.f_215823_) && !this.f_19853_.m_8055_(blockpos.m_7494_()).m_60815_()) {
                if (this.f_19853_.f_46441_.m_188503_(2) != 0) {
                    this.f_19853_.m_46597_(blockpos, transformState);
                } else {
                    this.f_19853_.m_46597_(blockpos.m_7494_(), transformState2);
                }
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_235900_, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 1.15, (double)blockpos.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            }
        });
    }

    public boolean m_147207_(MobEffectInstance p_182397_, @Nullable Entity p_182398_) {
        return false;
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    protected boolean m_7341_(Entity p_20339_) {
        return false;
    }

    public boolean m_214076_(ServerLevel p_216988_, LivingEntity p_216989_) {
        if (this.m_213877_()) {
            return false;
        }
        this.explode();
        this.m_5496_(SoundEvents.f_215740_, 4.0f, this.m_6100_());
        return super.m_214076_(p_216988_, p_216989_);
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public boolean m_213854_() {
        return true;
    }

    public float m_5610_(BlockPos p_219410_, LevelReader p_219411_) {
        return 0.0f;
    }

    private int getHeartBeatDelay() {
        float f = (float)this.getClientAngerLevel() / (float)AngerLevel.ANGRY.m_219226_();
        return 40 - Mth.m_14143_((float)(Mth.m_14036_((float)f, (float)0.0f, (float)1.0f) * 30.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            ((VibrationListener)this.dynamicGameEventListener.m_223616_()).m_157898_((Level)serverlevel);
            if (this.m_21532_() || this.m_8023_()) {
                SculkBeastAI.setDigCooldown((LivingEntity)this);
            }
        }
        if (this.f_19853_.m_5776_()) {
            if (this.f_19797_ % this.getHeartBeatDelay() == 0 && !this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215762_, this.m_5720_(), 5.0f, 1.0f, false);
            }
            this.tendrilAnimationO = this.tendrilAnimation;
            if (this.tendrilAnimation > 0) {
                --this.tendrilAnimation;
            }
            if (this.attacktick == 18 && this.attackID == 1) {
                RandomSource randomsource = this.m_217043_();
                BlockState blockstate = this.m_20075_();
                if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                    for (int i = 0; i < 30; ++i) {
                        double d0 = this.m_20185_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-2.0f, (float)2.0f);
                        double d1 = this.m_20186_();
                        double d2 = this.m_20189_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-2.0f, (float)2.0f);
                        this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.attackID == 3 && this.attacktick == 5) {
                this.m_5496_(SoundEvents.f_215772_, 6.0f, 1.0f);
            }
        }
        if (this.sonicBoomAnimationState.m_216984_() && this.m_5912_()) {
            this.f_19865_ = Vec3.f_82478_;
        }
        if (this.stunnedTick > 0) {
            --this.stunnedTick;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.stunnedTick == 45) {
                this.m_5496_(SoundEvents.f_215769_, 6.0f, this.m_6100_());
            }
            if (this.m_5448_() != null) {
                if (this.attackID == 1 || this.attackID == 3) {
                    if (this.m_5448_().m_6084_()) {
                        this.f_20883_ = this.f_20885_;
                        this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                    }
                    this.m_20334_(0.0, 0.0, 0.0);
                    this.m_21573_().m_26569_();
                }
                if (this.attackID == 3 && this.attacktick == 29) {
                    this.m_6274_().m_21952_(MemoryModuleType.f_26372_).filter(this::canTargetEntity).filter(p_217707_ -> this.m_216992_((Entity)p_217707_, 55.0, 55.0)).ifPresent(p_217704_ -> {
                        Vec3 vec3 = this.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
                        Vec3 vec31 = p_217704_.m_146892_().m_82546_(vec3);
                        Vec3 vec32 = vec31.m_82541_();
                        if (level instanceof ServerLevel) {
                            ServerLevel serverlevel = (ServerLevel)level;
                            for (int i = 1; i < Mth.m_14107_((double)vec31.m_82553_()) + 7; ++i) {
                                Vec3 vec33 = vec3.m_82549_(vec32.m_82490_((double)i));
                                serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_235902_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            ScreenShakeEntity.ScreenShake((Level)serverlevel, this.m_20182_(), 15.0f, 0.4f, 0, 10);
                            ScreenShakeEntity.ScreenShake((Level)serverlevel, this.m_5448_().m_20182_(), 15.0f, 0.2f, 0, 20);
                        }
                        this.m_5496_(SoundEvents.f_215771_, 5.0f, 1.0f);
                        p_217704_.m_6469_(DamageSource.m_216876_((Entity)this), 10.0f);
                        double d1 = 0.5 * (1.0 - p_217704_.m_21133_(Attributes.f_22278_));
                        double d0 = 2.5 * (1.0 - p_217704_.m_21133_(Attributes.f_22278_));
                        p_217704_.m_5997_(vec32.m_7096_() * d0, vec32.m_7098_() * d1, vec32.m_7094_() * d0);
                    });
                }
                if (this.attackID == 1) {
                    this.m_146922_(this.f_20883_);
                }
                if (this.attacktick == 8 && this.attackID == 1) {
                    this.f_20883_ = this.f_20885_;
                    float f1 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
                    float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
                    this.m_5997_((double)f1 * 0.6, 0.0, (double)f2 * 0.6);
                }
                if (this.attacktick == 18 && this.attackID == 1) {
                    if ((double)this.m_20270_((Entity)this.m_5448_()) <= 3.0) {
                        this.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                    }
                    ScreenShakeEntity.ScreenShake(level, this.m_20182_(), 15.0f, 0.2f, 0, 10);
                    this.meleeattack();
                    this.m_5496_(SoundEvents.f_11913_, 2.0f, 0.5f + this.m_217043_().m_188501_() * 0.1f);
                    this.smash(3);
                }
                if (this.attackID == 2 && this.m_20096_() && this.m_6144_() && this.attacktick > 8) {
                    Player player;
                    if (this.m_5448_() instanceof Player && (player = (Player)this.m_5448_()).m_21254_()) {
                        player.m_36384_(true);
                    }
                    this.m_20260_(false);
                    ScreenShakeEntity.ScreenShake(level, this.m_20182_(), 15.0f, 0.2f, 0, 10);
                    this.impact();
                    this.smash(4);
                    this.m_5496_(SoundEvents.f_11913_, 2.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
                    if (this.f_19853_.f_46443_) {
                        BlockState block = level.m_8055_(this.m_20183_().m_7495_());
                        for (int j = 0; j < 24; ++j) {
                            float f = this.f_19796_.m_188501_() * ((float)Math.PI * 4);
                            float f1 = this.f_19796_.m_188501_() * 0.8f + 0.8f;
                            float f2 = Mth.m_14031_((float)f) * 3.0f * 0.8f * f1;
                            float f3 = Mth.m_14089_((float)f) * 3.0f * 0.8f * f1;
                            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
        if (this.attackID != 0) {
            ++this.attacktick;
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.stunnedTick > 0;
    }

    public boolean m_142582_(Entity p_149755_) {
        return this.stunnedTick <= 0 && super.m_142582_(p_149755_);
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.f_19853_.m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    private void meleeattack() {
        float range = 3.0f;
        float arc = 80.0f;
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.m_82376_()), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.m_82376_()), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, 2.5, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20885_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range) || !(entityRelativeAngle <= arc / 2.0f) || !(entityRelativeAngle >= -arc / 2.0f) || entityRelativeAngle >= 360.0f - arc / 2.0f != entityRelativeAngle <= -360.0f + arc / 2.0f || entityHit instanceof SculkBeast) continue;
            boolean flag = entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
            if (entityHit.m_21254_()) continue;
            entityHit.f_19802_ = 0;
            if (!flag) continue;
            entityHit.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.BLEEDING.get(), 100), (Entity)this);
        }
    }

    private void impact() {
        if (this.m_6084_()) {
            for (LivingEntity livingentity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(3.5), NO_NEHEMOTH_AND_ALIVE)) {
                if (livingentity instanceof SculkBeast) continue;
                livingentity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 10.0f);
            }
            this.m_146850_(GameEvent.f_223709_);
        }
    }

    private void smash(int distance) {
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * 2;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance;
            double pz = this.m_20189_() + vz * (double)distance;
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) continue;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY, hitZ);
            BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
            BlockState block = this.f_19853_.m_8055_(pos);
            BlockState blockAbove = this.f_19853_.m_8055_(abovePos);
            if (block.m_60767_() == Material.f_76296_ || block.m_155947_() || blockAbove.m_60767_().m_76334_()) continue;
            FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(this.f_19853_, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
            this.f_19853_.m_7731_(pos, block.m_60819_().m_76188_(), 3);
            fallingBlockEntity.m_5997_(0.0, 0.2 + this.m_217043_().m_188583_() * 0.15, 0.0);
            this.f_19853_.m_7967_((Entity)fallingBlockEntity);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SonicBoomGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SmashGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new net.minecraft.world.entity.ai.goal.MeleeAttackGoal((PathfinderMob)this, 1.3, false));
        super.m_8099_();
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.2f;
    }

    protected void m_7355_(BlockPos p_219431_, BlockState p_219432_) {
        this.m_5496_(SoundEvents.f_215773_, 10.0f, 0.5f);
    }

    private void playListeningSound() {
        if (!this.m_217003_(Pose.ROARING)) {
            this.m_5496_(this.getAngerLevel().m_219235_(), 10.0f, this.m_6100_());
        }
    }

    public boolean m_213824_() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIENT_ANGER_LEVEL, (Object)0);
    }

    public int getClientAngerLevel() {
        return (Integer)this.f_19804_.m_135370_(CLIENT_ANGER_LEVEL);
    }

    private void syncClientAngerLevel() {
        this.f_19804_.m_135381_(CLIENT_ANGER_LEVEL, (Object)this.getActiveAnger());
    }

    public AngerLevel getAngerLevel() {
        return AngerLevel.m_219227_((int)this.getActiveAnger());
    }

    private int getActiveAnger() {
        return this.angerManagement.m_219286_((Entity)this.m_5448_());
    }

    public void clearAnger(Entity p_219429_) {
        this.angerManagement.m_219266_(p_219429_);
    }

    public void increaseAngerAt(@Nullable Entity p_219442_) {
        this.increaseAngerAt(p_219442_, 35, true);
    }

    @VisibleForTesting
    public void increaseAngerAt(@Nullable Entity p_219388_, int p_219389_, boolean p_219390_) {
        if (!this.m_21525_() && this.canTargetEntity(p_219388_)) {
            SculkBeastAI.setDigCooldown((LivingEntity)this);
            boolean flag = !(this.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null) instanceof Player);
            int i = this.angerManagement.m_219268_(p_219388_, p_219389_);
            if (p_219388_ instanceof Player && flag && AngerLevel.m_219227_((int)i).m_219236_()) {
                this.m_6274_().m_21936_(MemoryModuleType.f_26372_);
            }
            if (p_219390_) {
                this.playListeningSound();
            }
        }
    }

    public Optional<LivingEntity> getEntityAngryAt() {
        return this.getAngerLevel().m_219236_() ? this.angerManagement.m_219256_() : Optional.empty();
    }

    public void m_7380_(CompoundTag p_219434_) {
        super.m_7380_(p_219434_);
        AngerManagement.m_219277_(this::canTargetEntity).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.angerManagement).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219437_ -> p_219434_.m_128365_("anger", p_219437_));
        VibrationListener.m_223781_((VibrationListener.VibrationListenerConfig)this).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((VibrationListener)this.dynamicGameEventListener.m_223616_())).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219418_ -> p_219434_.m_128365_("listener", p_219418_));
    }

    public void m_7378_(CompoundTag p_219415_) {
        super.m_7378_(p_219415_);
        if (p_219415_.m_128441_("anger")) {
            AngerManagement.m_219277_(this::canTargetEntity).parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_219415_.m_128423_("anger"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219394_ -> {
                this.angerManagement = p_219394_;
            });
            this.syncClientAngerLevel();
        }
        if (p_219415_.m_128425_("listener", 10)) {
            VibrationListener.m_223781_((VibrationListener.VibrationListenerConfig)this).parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_219415_.m_128469_("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219408_ -> this.dynamicGameEventListener.m_223628_((GameEventListener)p_219408_, this.f_19853_));
        }
    }

    @Nullable
    public LivingEntity m_5448_() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }

    public boolean m_6785_(double p_219457_) {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (f_19806_.equals(p_219422_)) {
            switch (this.m_20089_()) {
                case SNIFFING: {
                    this.sniffAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    public boolean m_6469_(DamageSource p_219381_, float p_219382_) {
        boolean flag = super.m_6469_(p_219381_, p_219382_);
        if (!this.f_19853_.f_46443_ && !this.m_21525_()) {
            Entity entity = p_219381_.m_7639_();
            this.increaseAngerAt(entity, AngerLevel.ANGRY.m_219226_() + 20, false);
            if (this.f_20939_.m_21952_(MemoryModuleType.f_26372_).isEmpty() && entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!(p_219381_ instanceof IndirectEntityDamageSource) || this.m_19950_((Entity)livingentity, 5.0)) {
                    this.setAttackTarget(livingentity);
                }
            }
            if (this.attackID == 3 && this.attacktick < 28) {
                this.attacktick = 38;
                this.stunnedTick = 45;
                this.f_19853_.m_7605_((Entity)this, (byte)39);
            }
        }
        return flag;
    }

    protected Brain<?> m_8075_(Dynamic<?> p_21069_) {
        return SculkBeastAI.makeBrain(this, p_21069_);
    }

    public Brain<SculkBeast> m_6274_() {
        return super.m_6274_();
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    public void setAttackTarget(LivingEntity p_219460_) {
        this.m_21561_(true);
        this.m_6274_().m_21936_(MemoryModuleType.f_217782_);
        StartAttacking.m_24213_((Mob)this, (LivingEntity)p_219460_);
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable Entity p_219386_) {
        if (p_219386_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_219386_;
            return this.f_19853_ == p_219386_.f_19853_ && EntitySelector.f_20406_.test(p_219386_) && !this.m_7307_(p_219386_) && livingentity.m_6095_() != EntityType.f_20529_ && livingentity.m_6095_() != EntityType.f_217015_ && livingentity.m_6095_() != EntityRegistry.SCULK_BEAST.get() && !livingentity.m_20147_() && !livingentity.m_21224_() && this.f_19853_.m_6857_().m_61935_(livingentity.m_20191_());
        }
        return false;
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> p_216996_) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            p_216996_.accept(this.dynamicGameEventListener, serverlevel);
        }
    }

    public TagKey<GameEvent> m_213929_() {
        return GameEventTags.f_215853_;
    }

    public boolean m_213734_() {
        return true;
    }

    public boolean m_213641_(ServerLevel p_219370_, GameEventListener p_219371_, BlockPos p_219372_, GameEvent p_219373_, GameEvent.Context p_219374_) {
        if (!(this.m_21525_() || this.m_21224_() || this.m_6274_().m_21874_(MemoryModuleType.f_217774_) || !p_219370_.m_6857_().m_61937_(p_219372_) || this.m_213877_() || this.f_19853_ != p_219370_)) {
            Entity entity = p_219374_.f_223711_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                return this.canTargetEntity((Entity)livingentity);
            }
            return true;
        }
        return false;
    }

    public void m_7822_(byte p_21375_) {
        if (this.attackID != 0) {
            ++this.attacktick;
        }
        if (p_21375_ <= 0) {
            this.attackID = Math.abs(p_21375_);
            this.attacktick = 0;
        }
        if (p_21375_ == 61) {
            this.tendrilAnimation = 10;
        } else if (p_21375_ == 62) {
            this.sonicBoomAnimationState.m_216977_(this.f_19797_);
        } else if (p_21375_ == 39) {
            this.stunnedTick = 50;
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public float getTendrilAnimation(float p_219468_) {
        return Mth.m_14179_((float)p_219468_, (float)this.tendrilAnimationO, (float)this.tendrilAnimation) / 10.0f;
    }

    public void m_213991_(ServerLevel p_219362_, GameEventListener p_219363_, BlockPos p_219364_, GameEvent p_219365_, @Nullable Entity p_219366_, @Nullable Entity p_219367_, float p_219368_) {
        if (!this.m_21224_()) {
            this.f_20939_.m_21882_(MemoryModuleType.f_217774_, (Object)Unit.INSTANCE, 40L);
            p_219362_.m_7605_((Entity)this, (byte)61);
            this.m_5496_(SoundEvents.f_215774_, 5.0f, this.m_6100_());
            BlockPos blockpos = p_219364_;
            if (p_219367_ != null) {
                if (this.m_19950_(p_219367_, 30.0)) {
                    if (this.m_6274_().m_21874_(MemoryModuleType.f_217784_)) {
                        if (this.canTargetEntity(p_219367_)) {
                            blockpos = p_219367_.m_20183_();
                        }
                        this.increaseAngerAt(p_219367_);
                    } else {
                        this.increaseAngerAt(p_219367_, 10, true);
                    }
                }
                this.m_6274_().m_21882_(MemoryModuleType.f_217784_, (Object)Unit.INSTANCE, 100L);
            } else {
                this.increaseAngerAt(p_219366_);
            }
            if (!this.getAngerLevel().m_219236_()) {
                Optional optional = this.angerManagement.m_219256_();
                if (p_219367_ != null || optional.isEmpty() || optional.get() == p_219366_) {
                    SculkBeastAI.setDisturbanceLocation(this, blockpos);
                }
            }
        }
    }

    public boolean m_7327_(Entity p_21372_) {
        if (!this.f_19853_.f_46443_ && this.attackID == 0) {
            this.attackID = this.f_19796_.m_188503_(2) != 0 ? 1 : 1;
        }
        return true;
    }

    protected void m_7324_(Entity p_219353_) {
        if (!this.m_21525_() && !this.m_6274_().m_21874_(MemoryModuleType.f_217773_)) {
            this.m_6274_().m_21882_(MemoryModuleType.f_217773_, (Object)Unit.INSTANCE, 20L);
            this.increaseAngerAt(p_219353_);
            SculkBeastAI.setDisturbanceLocation(this, p_219353_.m_20183_());
        }
        super.m_7324_(p_219353_);
    }

    protected PathNavigation m_6037_(Level p_219396_) {
        return new WallClimberNavigation((Mob)this, p_219396_){

            protected PathFinder m_5532_(int p_219479_) {
                this.f_26508_ = new WalkNodeEvaluator();
                this.f_26508_.m_77351_(true);
                return new PathFinder(this.f_26508_, p_219479_){

                    protected float m_214208_(Node p_219486_, Node p_219487_) {
                        return p_219486_.m_230613_(p_219487_);
                    }
                };
            }
        };
    }

    private class SonicBoomGoal
    extends Goal {
        private final SculkBeast nehemoth;
        private LivingEntity attackTarget;

        public SonicBoomGoal(SculkBeast p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && ((double)SculkBeast.this.m_20270_((Entity)this.attackTarget) > 5.0 || this.nehemoth.m_20186_() < this.attackTarget.m_20186_() + 3.0 && this.attackTarget.m_20096_()) && SculkBeast.this.m_20096_() && SculkBeast.this.f_19796_.m_188503_(24) == 0;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(3);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 38;
        }

        public void m_8037_() {
            if (this.nehemoth.attacktick < 38 && this.attackTarget.m_6084_()) {
                SculkBeast.this.f_20883_ = SculkBeast.this.f_20885_;
                this.nehemoth.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            SculkBeast.this.f_19865_ = Vec3.f_82478_;
            this.nehemoth.m_20334_(0.0, 0.0, 0.0);
            SculkBeast.this.m_21573_().m_26569_();
            double dist = this.nehemoth.m_20270_((Entity)this.attackTarget);
        }
    }

    private class MeleeAttackGoal
    extends Goal {
        private final SculkBeast nehemoth;
        private LivingEntity attackTarget;

        public MeleeAttackGoal(SculkBeast p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 1;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(1);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 28;
        }

        public void m_8037_() {
            SculkBeast.this.f_19865_ = Vec3.f_82478_;
            if (this.nehemoth.attacktick < 28 && this.attackTarget.m_6084_()) {
                this.nehemoth.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            double dist = this.nehemoth.m_20270_((Entity)this.attackTarget);
        }
    }

    private class SmashGoal
    extends Goal {
        private final SculkBeast nehemoth;
        private LivingEntity attackTarget;

        public SmashGoal(SculkBeast p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && ((double)SculkBeast.this.m_20270_((Entity)this.attackTarget) > 5.0 || this.nehemoth.m_20186_() < this.attackTarget.m_20186_() + 3.0 && this.attackTarget.m_20096_()) && SculkBeast.this.m_20096_() && SculkBeast.this.f_19796_.m_188503_(38) == 0;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(2);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 31;
        }

        public void m_8037_() {
            SculkBeast.this.f_19865_ = Vec3.f_82478_;
            double dist = this.nehemoth.m_20270_((Entity)this.attackTarget);
            if (this.nehemoth.attacktick < 31 && this.attackTarget.m_6084_()) {
                SculkBeast.this.f_20883_ = SculkBeast.this.f_20885_;
                this.nehemoth.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (this.nehemoth.attacktick == 2) {
                SculkBeast.this.m_6862_(true);
                SculkBeast.this.m_20260_(true);
                if (this.nehemoth.m_20186_() < this.attackTarget.m_20186_() + 3.0 && this.attackTarget.m_20096_()) {
                    SculkBeast.this.m_20334_((this.attackTarget.m_20185_() - SculkBeast.this.m_20185_()) * 0.2, 1.1, (this.attackTarget.m_20189_() - SculkBeast.this.m_20189_()) * 0.2);
                }
                if (this.nehemoth.m_20186_() >= this.attackTarget.m_20186_()) {
                    SculkBeast.this.m_20334_((this.attackTarget.m_20185_() - SculkBeast.this.m_20185_()) * 0.2, 0.8, (this.attackTarget.m_20189_() - SculkBeast.this.m_20189_()) * 0.2);
                }
            }
            if (this.nehemoth.attacktick > 2 && this.nehemoth.attacktick < 7 && SculkBeast.this.m_20096_()) {
                SculkBeast.this.m_20260_(false);
                this.nehemoth.attacktick = 31;
            }
            if (SculkBeast.this.m_20096_() && this.nehemoth.attacktick > 2) {
                SculkBeast.this.m_6862_(false);
            }
        }
    }
}

