/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.entity;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.sonmok14.fromtheshadows.entity.ai.NearestTargetGoal3D;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Reaper
extends Monster
implements IAnimatable,
IAnimationTickable,
Enemy {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(Reaper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final float FLAP_DEGREES_PER_TICK = 7.448451f;
    private boolean isLandNavigator;
    Vec3 moveTargetPoint = Vec3.f_82478_;
    BlockPos anchorPoint = BlockPos.f_121853_;
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)18.0f);
    AttackPhase attackPhase = AttackPhase.CIRCLE;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public int getUniqueFlapTickOffset() {
        return this.m_19879_() * 3;
    }

    public boolean m_142039_() {
        return (this.getUniqueFlapTickOffset() + this.f_19797_) % TICKS_PER_FLAP == 0;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!this.m_20096_() && !this.m_6084_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.reaper.death", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.m_20096_() && event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.reaper.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (!this.m_20096_() && !this.m_5912_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.reaper.fly", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.reaper.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public Reaper(EntityType<? extends Reaper> type, Level worldIn) {
        super(type, worldIn);
        this.f_19811_ = true;
        this.switchNavigator(true);
        this.f_21365_ = new PhantomLookControl((Mob)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public boolean m_142535_(float p_148875_, float p_148876_, DamageSource p_148877_) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isFlying() && this.f_19853_.f_46443_) {
            float f = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            float f1 = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_ + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12230_, this.m_5720_(), 0.95f + this.f_19796_.m_188501_() * 0.05f, 0.95f + this.f_19796_.m_188501_() * 0.05f, false);
            }
        }
        if (!this.isFlying() && this.m_5448_() != null) {
            this.setFlying(true);
        }
        if (this.isFlying() && this.m_20096_() && this.m_5448_() == null) {
            this.setFlying(false);
        }
        if (this.isFlying() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.isFlying() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.isFlying() && this.m_6084_()) {
            this.m_20242_(true);
        } else {
            this.m_20242_(false);
        }
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.isLandNavigator = true;
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
        } else {
            this.isLandNavigator = false;
            this.f_21342_ = new ReaperMoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 45.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.25).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22282_, 0.0);
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        controller.registerCustomInstructionListener(this::customListener);
        data.addAnimationController(controller);
    }

    private <ENTITY extends IAnimatable> void customListener(CustomInstructionKeyframeEvent<ENTITY> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_5661_((Component)Component.m_237113_((String)"KeyFraming"), true);
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PhantomAttackStrategyGoal());
        this.f_21345_.m_25352_(2, (Goal)new PhantomSweepAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new PhantomCircleAroundAnchorGoal());
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Reaper.class}));
        this.f_21346_.m_25352_(2, new NearestTargetGoal3D<Player>((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, new NearestTargetGoal3D<AbstractPiglin>((Mob)this, AbstractPiglin.class, true));
        this.f_21346_.m_25352_(3, new NearestTargetGoal3D<AbstractVillager>((Mob)this, AbstractVillager.class, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{Reaper.class}));
        super.m_8099_();
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    protected BodyRotationControl m_7560_() {
        return new PhantomBodyRotationControl((Mob)this);
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class PhantomLookControl
    extends LookControl {
        public PhantomLookControl(Mob p_33235_) {
            super(p_33235_);
        }

        public void m_8128_() {
        }
    }

    class ReaperMoveControl
    extends MoveControl {
        private float speed;

        public ReaperMoveControl(Mob p_33241_) {
            super(p_33241_);
            this.speed = 0.3f;
        }

        public void m_8126_() {
            if (Reaper.this.f_19862_) {
                Reaper.this.m_146922_(Reaper.this.m_146908_() + 180.0f);
                this.speed = 0.3f;
            }
            double d0 = Reaper.this.moveTargetPoint.f_82479_ - Reaper.this.m_20185_();
            double d1 = Reaper.this.moveTargetPoint.f_82480_ - Reaper.this.m_20186_();
            double d2 = Reaper.this.moveTargetPoint.f_82481_ - Reaper.this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = Reaper.this.m_146908_();
                float f1 = (float)Mth.m_14136_((double)d2, (double)d0);
                float f2 = Mth.m_14177_((float)(Reaper.this.m_146908_() + 90.0f));
                float f3 = Mth.m_14177_((float)(f1 * 57.295776f));
                Reaper.this.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)4.0f) - 90.0f);
                Reaper.this.f_20883_ = Reaper.this.m_146908_();
                this.speed = Mth.m_14145_((float)f, (float)Reaper.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)0.6f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.2f, (float)0.025f);
                float f4 = (float)(-(Mth.m_14136_((double)(-d1), (double)d3) * 57.2957763671875));
                Reaper.this.m_146926_(f4);
                float f5 = Reaper.this.m_146908_() + 90.0f;
                double d6 = (double)(this.speed * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = Reaper.this.m_20184_();
                Reaper.this.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    class PhantomAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        PhantomAttackStrategyGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = Reaper.this.m_5448_();
            return livingentity != null ? Reaper.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }

        public void m_8056_() {
            this.nextSweepTick = this.m_183277_(10);
            Reaper.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void m_8041_() {
            Reaper.this.anchorPoint = Reaper.this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, Reaper.this.anchorPoint).m_6630_(10 + Reaper.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (Reaper.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    Reaper.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.m_183277_((8 + Reaper.this.f_19796_.m_188503_(4)) * 20);
                    Reaper.this.m_5496_(SoundEvents.f_12232_, 10.0f, 0.95f + Reaper.this.f_19796_.m_188501_() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            Reaper.this.anchorPoint = Reaper.this.m_5448_().m_20183_().m_6630_(20 + Reaper.this.f_19796_.m_188503_(20));
            if (Reaper.this.anchorPoint.m_123342_() < Reaper.this.f_19853_.m_5736_()) {
                Reaper.this.anchorPoint = new BlockPos(Reaper.this.anchorPoint.m_123341_(), Reaper.this.f_19853_.m_5736_() + 1, Reaper.this.anchorPoint.m_123343_());
            }
        }
    }

    class PhantomSweepAttackGoal
    extends PhantomMoveTargetGoal {
        private static final int CAT_SEARCH_TICK_DELAY = 20;
        private boolean isScaredOfCat;
        private int catSearchTick;

        PhantomSweepAttackGoal() {
        }

        public boolean m_8036_() {
            return Reaper.this.m_5448_() != null && Reaper.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = Reaper.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (livingentity.m_5833_() || player.m_7500_()) {
                    return false;
                }
            }
            if (!this.m_8036_()) {
                return false;
            }
            if (Reaper.this.f_19797_ > this.catSearchTick) {
                this.catSearchTick = Reaper.this.f_19797_ + 20;
                List list = Reaper.this.f_19853_.m_6443_(Cat.class, Reaper.this.m_20191_().m_82400_(16.0), EntitySelector.f_20402_);
                for (Cat cat : list) {
                    cat.m_28167_();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            Reaper.this.m_6710_(null);
            Reaper.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            LivingEntity livingentity = Reaper.this.m_5448_();
            if (livingentity != null) {
                Reaper.this.moveTargetPoint = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5), livingentity.m_20189_());
                if (Reaper.this.m_20191_().m_82400_((double)0.2f).m_82381_(livingentity.m_20191_())) {
                    Reaper.this.m_7327_((Entity)livingentity);
                    Reaper.this.attackPhase = AttackPhase.CIRCLE;
                    if (!Reaper.this.m_20067_()) {
                        Reaper.this.f_19853_.m_46796_(1039, Reaper.this.m_20183_(), 0);
                    }
                } else if (Reaper.this.f_19862_ || Reaper.this.f_20916_ > 0) {
                    Reaper.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    class PhantomCircleAroundAnchorGoal
    extends PhantomMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        PhantomCircleAroundAnchorGoal() {
        }

        public boolean m_8036_() {
            return Reaper.this.m_5448_() == null || Reaper.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void m_8056_() {
            this.distance = 5.0f + Reaper.this.f_19796_.m_188501_() * 10.0f;
            this.height = -4.0f + Reaper.this.f_19796_.m_188501_() * 9.0f;
            this.clockwise = Reaper.this.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (Reaper.this.f_19796_.m_188503_(this.m_183277_(350)) == 0) {
                this.height = -4.0f + Reaper.this.f_19796_.m_188501_() * 9.0f;
            }
            if (Reaper.this.f_19796_.m_188503_(this.m_183277_(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (Reaper.this.f_19796_.m_188503_(this.m_183277_(450)) == 0) {
                this.angle = Reaper.this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (Reaper.this.moveTargetPoint.f_82480_ < Reaper.this.m_20186_() && !Reaper.this.f_19853_.m_46859_(Reaper.this.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (Reaper.this.moveTargetPoint.f_82480_ > Reaper.this.m_20186_() && !Reaper.this.f_19853_.m_46859_(Reaper.this.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.f_121853_.equals((Object)Reaper.this.anchorPoint)) {
                Reaper.this.anchorPoint = Reaper.this.m_20183_();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            Reaper.this.moveTargetPoint = Vec3.m_82528_((Vec3i)Reaper.this.anchorPoint).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    class PhantomBodyRotationControl
    extends BodyRotationControl {
        public PhantomBodyRotationControl(Mob p_33216_) {
            super(p_33216_);
        }

        public void m_8121_() {
            Reaper.this.f_20885_ = Reaper.this.f_20883_;
            Reaper.this.f_20883_ = Reaper.this.m_146908_();
        }
    }

    abstract class PhantomMoveTargetGoal
    extends Goal {
        public PhantomMoveTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return Reaper.this.moveTargetPoint.m_82531_(Reaper.this.m_20185_(), Reaper.this.m_20186_(), Reaper.this.m_20189_()) < 4.0;
        }
    }
}

