/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.sonmok14.fromtheshadows.entity.ArmoredNehemothEntity;
import net.sonmok14.fromtheshadows.entity.FallingBlockEntity;
import net.sonmok14.fromtheshadows.entity.ScreenShakeEntity;
import net.sonmok14.fromtheshadows.entity.ai.SoulBreathEntity;
import net.sonmok14.fromtheshadows.utils.packet.ThrowPlayerPacket;
import net.sonmok14.fromtheshadows.utils.registry.EffectRegistry;
import net.sonmok14.fromtheshadows.utils.registry.ItemRegistry;
import net.sonmok14.fromtheshadows.utils.registry.SoundRegistry;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class NehemothEntity
extends Monster
implements Enemy,
IAnimatable,
IAnimationTickable {
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(NehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(NehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Predicate<Entity> NO_NEHEMOTH_AND_ALIVE = p_33346_ -> p_33346_.m_6084_() && !(p_33346_ instanceof NehemothEntity);
    public int attackID;
    private int stunnedTick;
    public int attacktick;
    public static final byte MELEE_ATTACK = 1;
    public static final byte BITE_ATTACK = 2;
    public static final byte ROAR_ATTACK = 3;
    public static final byte SMASH_ATTACK = 4;
    public static final byte GUARD_ATTACK = 5;
    public static final byte SHOT_ATTACK = 6;
    public static final byte THROWING_ATTACK = 7;
    public static final byte MELEE_ATTACK_REVERSE = 8;
    public static final byte GUARD = 9;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public NehemothEntity(EntityType<? extends NehemothEntity> type, Level world) {
        super(type, world);
        this.f_19793_ = 1.0f;
        this.f_21364_ = 30;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22281_, 9.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, 9.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22283_, 2.0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    protected float m_6059_() {
        if (this.m_5912_()) {
            return this.f_19788_ + 2.0f;
        }
        return this.f_19788_ + 1.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(CLIMBING, (Object)false);
    }

    public boolean isClimbing() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    public void setClimbing(boolean p_32759_) {
        this.f_19804_.m_135381_(CLIMBING, (Object)p_32759_);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @org.jetbrains.annotations.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @org.jetbrains.annotations.Nullable SpawnGroupData spawnDataIn, @org.jetbrains.annotations.Nullable CompoundTag dataTag) {
        if (NehemothEntity.isBiomeNether((LevelAccessor)worldIn, this.m_20183_())) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        this.m_20301_(this.m_6062_());
        this.m_146926_(0.0f);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private static boolean isBiomeNether(LevelAccessor worldIn, BlockPos position) {
        return worldIn.m_204166_(position).m_203565_(Biomes.f_48199_);
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    private <E extends IAnimatable> PlayState predicate3(AnimationEvent<E> event) {
        event.getController().setAnimationSpeed(0.5);
        if (!(this.m_20067_() || event.isMoving() || this.attackID != 0 || this.isClimbing())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.ldle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_20067_()) {
            switch (this.f_19796_.m_188503_(2)) {
                case 0: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.none", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
                case 1: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.none", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.stop1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState predicate2(AnimationEvent<E> event) {
        event.getController().setAnimationSpeed(0.5);
        if (this.m_6084_()) {
            if (this.attackID == 4 && this.m_20096_() && this.attacktick < 15) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.smashstart", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 4 && !this.m_20096_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.jump", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 1 || this.attackID == 8) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.meleeattack1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimationSpeed(0.5);
        if (!this.m_20067_()) {
            if (event.isMoving() && this.f_20923_ > 0.35f && this.attackID == 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isClimbing()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.climb", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.roar", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (!this.m_6107_()) {
                if (this.attackID == 1 || this.attackID == 8) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.none", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (this.attackID == 2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (this.attackID == 7 && this.attacktick < 15) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (this.attackID == 7 && this.attacktick > 15) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.roar", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
            }
            if (this.attackID == 7 && !this.m_20096_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.jump", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 4 && this.m_20096_() && this.attacktick < 15) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.none", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 4 && this.m_20096_() && this.attacktick > 15) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.smash", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 4 && !this.m_20096_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.none", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 5 && this.attacktick < 55) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.guard", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 9) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.guard", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 5 && this.attacktick > 55) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.bulk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 6 && this.attacktick < 5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.bulk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 6) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.breath", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.m_6107_() && this.m_6084_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.stun", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (!event.isMoving() && this.attackID == 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.ldle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
        } else if (this.m_20067_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.none", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public int m_5792_() {
        return 2;
    }

    public static <T extends Mob> boolean canNehemothSpawn(EntityType<NehemothEntity> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        if (NehemothEntity.isBiomeNether((LevelAccessor)iServerWorld, pos)) {
            return reason == MobSpawnType.SPAWNER || NehemothEntity.checkMonsterSpawnRules(entityType, iServerWorld, reason, pos, random);
        }
        return reason == MobSpawnType.SPAWNER || !iServerWorld.m_45527_(pos) && pos.m_123342_() <= 0 && NehemothEntity.checkMonsterSpawnRules(entityType, iServerWorld, reason, pos, random);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 3.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller2", 8.0f, this::predicate2));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller3", 20.0f, this::predicate3));
    }

    public MobType m_6336_() {
        if (this.getVariant() == 1) {
            return MobType.f_21641_;
        }
        return super.m_6336_();
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new net.minecraft.world.entity.ai.goal.MeleeAttackGoal((PathfinderMob)this, 1.3, false));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new BiteAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new RoarGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SmashGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new BreathGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DoNothingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new GuardandRevengeGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new GuardGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new ThrowingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackReverseGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Allay.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true, p_199899_ -> !p_199899_.m_6162_()));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{NehemothEntity.class}));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5, 25, true));
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)(-id));
    }

    public static void applyDarknessAround(ServerLevel p_219376_, Vec3 p_219377_, @Nullable Entity p_219378_, int p_219379_) {
        MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.f_216964_, 260, 0, false, false);
        MobEffectUtil.m_216946_((ServerLevel)p_219376_, (Entity)p_219378_, (Vec3)p_219377_, (double)p_219379_, (MobEffectInstance)mobeffectinstance, (int)200);
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else if (id == 39) {
            this.stunnedTick = 40;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7327_(Entity p_85031_1_) {
        if (!this.f_19853_.f_46443_ && this.attackID == 0) {
            this.attackID = this.f_19796_.m_188503_(2) != 0 ? 8 : 1;
        }
        return true;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_146922_(this.f_20883_);
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_ && this.m_5448_() != null && this.m_5448_().m_6084_());
        }
        if (this.f_19853_.m_46462_()) {
            this.m_20331_(false);
            this.m_20225_(false);
        }
        Level level = this.f_19853_;
        ++this.f_19797_;
        if (this.attackID != 0) {
            ++this.attacktick;
        }
        if (this.m_6084_()) {
            if (this.m_5448_() != null) {
                float f1;
                if (this.attackID == 7) {
                    if (this.attacktick == 2) {
                        f1 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
                        float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
                        this.m_5997_((double)f1 * 0.2, 0.0, f2 * 1.0f);
                    }
                    if (this.attacktick == 22) {
                        this.m_20153_();
                    }
                    if (this.attacktick == 17 && !this.m_20197_().isEmpty()) {
                        Entity rider = (Entity)this.m_20197_().get(0);
                        float f12 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
                        float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
                        rider.m_8127_();
                        rider.m_5997_((double)f12 * 2.5, 0.7, (double)f2 * 2.5);
                        if (rider instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)rider;
                            ThrowPlayerPacket throwPlayerPacket = new ThrowPlayerPacket((double)f12 * 2.5, 0.7, (double)f2 * 2.5);
                        }
                    }
                    if (this.attacktick > 17 && this.m_5448_().f_19862_) {
                        boolean flag = this.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                        this.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                        if (flag) {
                            this.m_5448_().m_5496_(SoundEvents.f_12319_, 3.0f, 1.0f);
                        }
                    }
                }
                if (this.attackID == 5 && this.m_20067_()) {
                    this.attacktick = 80;
                }
                if (this.attackID == 6 && this.m_20067_()) {
                    this.attacktick = 16;
                }
                if (this.attackID == 3 && this.m_20067_()) {
                    this.attacktick = 25;
                }
                if (this.attackID == 4 && this.m_20067_()) {
                    this.attacktick = 38;
                }
                if (this.attackID == 2 && this.m_20067_()) {
                    this.attacktick = 23;
                }
                if (this.attackID == 1 && this.m_20067_()) {
                    this.attacktick = 39;
                }
                if (this.attackID == 6 && this.attacktick == 8) {
                    this.m_5496_(SoundEvents.f_11932_, 2.0f, 0.1f + this.m_217043_().m_188501_() * 0.1f);
                    LivingEntity livingEntity = this.m_5448_();
                    Vec3 vec3 = this.m_20252_(1.0f);
                    double d2 = livingEntity.m_20185_() - (this.m_20185_() + vec3.f_82479_ * 4.0);
                    double d3 = livingEntity.m_20227_(0.5) - (0.5 + this.m_20227_(0.5));
                    double d4 = livingEntity.m_20189_() - (this.m_20189_() + vec3.f_82481_ * 4.0);
                    SoulBreathEntity largefireball = new SoulBreathEntity(level, (LivingEntity)this, d2, d3, d4);
                    largefireball.m_6034_(this.m_20185_() + vec3.f_82479_ * 0.3, this.m_20227_(0.52), largefireball.m_20189_() + vec3.f_82481_ * 0.1);
                    level.m_7967_((Entity)largefireball);
                }
                if (this.attackID == 2 && this.attacktick == 2) {
                    f1 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
                    float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
                    this.m_5997_((double)f1 * 0.2, 0.0, f2 * 1.0f);
                }
                if (this.attacktick == 17 && this.attackID == 2 && this.m_20363_((Entity)this.m_5448_())) {
                    this.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                    if (this.attackID == 2 && !this.m_5448_().m_21254_()) {
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12465_, this.m_5720_(), 3.0f, 0.3f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
                        this.m_5448_().m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.HEAL_BLOCK.get(), 400), (Entity)this);
                        this.m_5634_((float)this.m_21133_(Attributes.f_22281_));
                    }
                    if (this.attackID == 2 && this.m_5448_().m_21254_() && this.f_19796_.m_188500_() < 0.5) {
                        this.m_6731_((LivingEntity)this);
                        this.m_20153_();
                        this.attacktick = 19;
                    }
                }
                if (this.attackID == 4) {
                    if (this.attacktick < 38 && this.m_5448_().m_6084_()) {
                        this.f_20883_ = this.f_20885_;
                        this.m_21391_((Entity)this.m_5448_(), 30.0f, 30.0f);
                    }
                    if (this.attacktick == 2) {
                        f1 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
                        float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
                        this.m_5997_((double)f1 * 0.4, 0.0, (double)f2 * 0.4);
                    }
                    if (this.attacktick == 9) {
                        this.m_6862_(true);
                        this.m_20260_(true);
                        this.m_20334_((this.m_5448_().m_20185_() - this.m_20185_()) * 0.17, 0.8, (this.m_5448_().m_20189_() - this.m_20189_()) * 0.17);
                    }
                    if (this.attackID == 4 && this.m_20096_() && this.m_6144_() && this.attacktick > 15) {
                        Player player;
                        if (this.m_5448_() instanceof Player && (player = (Player)this.m_5448_()).m_21254_()) {
                            player.m_36384_(true);
                        }
                        if ((double)this.m_20270_((Entity)this.m_5448_()) <= 2.0) {
                            this.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                        }
                        this.m_20260_(false);
                        ScreenShakeEntity.ScreenShake(level, this.m_20182_(), 15.0f, 0.2f, 0, 10);
                        this.roar();
                        this.smash(4);
                        this.m_5496_(SoundEvents.f_11913_, 2.0f, 0.2f + this.m_217043_().m_188501_() * 0.1f);
                    }
                }
                if (this.attackID == 5 && this.attacktick == 55) {
                    ServerLevel serverlevel = (ServerLevel)this.f_19853_;
                    this.f_19853_.m_46473_().m_7238_();
                    NehemothEntity.applyDarknessAround(serverlevel, this.m_20182_(), (Entity)this, 20);
                    this.roar();
                    ScreenShakeEntity.ScreenShake(level, this.m_20182_(), 15.0f, 0.2f, 0, 10);
                    this.m_5496_((SoundEvent)SoundRegistry.NEHEMOTH_ROAR.get(), 1.5f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
                    this.sphereparticle(2.0f, 5.0f);
                }
                if (this.attackID == 1 || this.attackID == 8) {
                    if (this.attacktick == 7) {
                        this.f_20883_ = this.f_20885_;
                        float f13 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
                        float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
                        this.m_5997_((double)f13 * 0.3, 0.0, (double)f2 * 0.3);
                    }
                    if (this.attacktick == 25) {
                        this.f_20883_ = this.f_20885_;
                        float f14 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
                        float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
                        this.m_5997_((double)f14 * 0.3, 0.0, (double)f2 * 0.3);
                    }
                    if (this.attacktick == 9) {
                        this.meleeattack();
                        this.m_5496_(SoundEvents.f_12317_, 3.0f, 0.5f + this.m_217043_().m_188501_() * 0.1f);
                    }
                    if (this.attacktick == 31) {
                        this.meleeattack();
                        this.m_5496_(SoundEvents.f_12317_, 3.0f, 0.5f + this.m_217043_().m_188501_() * 0.1f);
                    }
                }
                if (this.attackID == 3) {
                    if (this.attacktick < 25 && this.m_5448_().m_6084_() && this.m_5448_() != null) {
                        this.m_21391_((Entity)this.m_5448_(), 30.0f, 30.0f);
                    }
                    this.roar();
                    if (this.attacktick == 1) {
                        this.m_5496_((SoundEvent)SoundRegistry.NEHEMOTH_ROAR.get(), 1.5f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
                        ScreenShakeEntity.ScreenShake(level, this.m_20182_(), 20.0f, 0.2f, 20, 10);
                    }
                }
            }
            BlockPos blockpos = new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_());
            if (this.m_5912_() && !this.isClimbing()) {
                this.m_146922_(this.f_20883_);
            }
            if (this.stunnedTick > 0) {
                --this.stunnedTick;
                this.stunEffect();
            }
            if (this.m_20067_()) {
                this.setAttackID(0);
            }
            if (!level.m_45527_(blockpos) && this.m_20067_()) {
                this.m_20331_(false);
                this.m_20225_(false);
            }
            if (this.attackID == 5 && this.attacktick == 55) {
                this.sphereparticle(1.0f, 8.0f);
            }
            if (this.attackID == 4 && this.m_20096_() && this.attacktick > 15) {
                double d2;
                double d1;
                double d0;
                float f2;
                int j;
                BlockState block = level.m_8055_(this.m_20183_().m_7495_());
                for (j = 0; j < 32; ++j) {
                    float f = this.f_19796_.m_188501_() * ((float)Math.PI * 4);
                    float f1 = this.f_19796_.m_188501_() * 0.8f + 0.8f;
                    f2 = Mth.m_14031_((float)f) * 2.0f * 0.8f * f1;
                    float f3 = Mth.m_14089_((float)f) * 2.0f * 0.8f * f1;
                    d0 = this.f_19796_.m_188583_() * 0.5;
                    d1 = this.f_19796_.m_188583_() * 0.5;
                    d2 = this.f_19796_.m_188583_() * 0.5;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, d0, d1, d2);
                    this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, d0, d1, d2);
                }
                for (j = 0; j < 16; ++j) {
                    float f = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                    float f1 = this.f_19796_.m_188501_() * 0.8f + 0.8f;
                    f2 = Mth.m_14031_((float)f) * 4.0f * 0.8f * f1;
                    float f3 = Mth.m_14089_((float)f) * 4.0f * 0.8f * f1;
                    d0 = this.f_19796_.m_188583_() * 0.05;
                    d1 = this.f_19796_.m_188583_() * 0.05;
                    d2 = this.f_19796_.m_188583_() * 0.05;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, d0, d1, d2);
                }
                for (j = 0; j < 4; ++j) {
                    float f = this.f_19796_.m_188501_() * (float)Math.PI;
                    float f1 = this.f_19796_.m_188501_() * 0.8f + 0.8f;
                    f2 = Mth.m_14031_((float)f) * 1.0f * 0.8f * f1;
                    float f3 = Mth.m_14089_((float)f) * 1.0f * 0.8f * f1;
                    d0 = this.f_19796_.m_188583_() * 0.2;
                    d1 = this.f_19796_.m_188583_() * 0.2;
                    d2 = this.f_19796_.m_188583_() * 0.2;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, d0, d1, d2);
                    if (this.getVariant() == 1) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, d0, d1, d2);
                        continue;
                    }
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, d0, d1, d2);
                }
            }
        }
        if (this.f_19853_.f_46443_ && this.getVariant() == 1) {
            if (this.f_19796_.m_188503_(24) == 0 && !this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 1; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public EntityDimensions m_6972_(Pose p_29531_) {
        return super.m_6972_(p_29531_);
    }

    private void Throwing(Entity p_33340_) {
        p_33340_ = this.m_5448_();
        float f1 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
        float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
        p_33340_.m_8127_();
        p_33340_.m_5997_((double)f1 * 2.5, 0.7, (double)f2 * 2.5);
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.stunnedTick > 0;
    }

    public boolean m_142582_(Entity p_149755_) {
        return this.stunnedTick <= 0 && super.m_142582_(p_149755_);
    }

    private void sphereparticle(float height, float size) {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_() + (double)height;
        double d2 = this.m_20189_();
        for (float i = -size; i <= size; i += 1.0f) {
            for (float j = -size; j <= size; j += 1.0f) {
                for (float k = -size; k <= size; k += 1.0f) {
                    double d3 = (double)j + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double d4 = (double)i + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double d5 = (double)k + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + this.f_19796_.m_188583_() * 0.05;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123765_, d0, d1, d2, d3 / d6, d4 / d6, d5 / d6);
                    if (i == -size || i == size || j == -size || j == size) continue;
                    k += size * 2.0f - 1.0f;
                }
            }
        }
    }

    public boolean m_7307_(Entity p_32665_) {
        if (p_32665_ == this) {
            return true;
        }
        if (super.m_7307_(p_32665_)) {
            return true;
        }
        return p_32665_ instanceof ArmoredNehemothEntity;
    }

    private void smash(int distance) {
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * 2;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance;
            double pz = this.m_20189_() + vz * (double)distance;
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) continue;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY, hitZ);
            BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
            BlockState block = this.f_19853_.m_8055_(pos);
            BlockState blockAbove = this.f_19853_.m_8055_(abovePos);
            if (block.m_60767_() == Material.f_76296_ || block.m_155947_() || blockAbove.m_60767_().m_76334_()) continue;
            FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(this.f_19853_, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
            this.f_19853_.m_7731_(pos, block.m_60819_().m_76188_(), 3);
            fallingBlockEntity.m_5997_(this.m_217043_().m_188583_() * 3.0, 0.2 + this.m_217043_().m_188583_() * 0.2, this.m_217043_().m_188583_() * 3.0);
            this.f_19853_.m_7967_((Entity)fallingBlockEntity);
        }
    }

    private void stunEffect() {
        if (this.f_19796_.m_188503_(6) == 0) {
            double d0 = this.m_20185_() - (double)this.m_20205_() * Math.sin(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            double d1 = this.m_20186_() + (double)this.m_20206_() - 0.3;
            double d2 = this.m_20189_() + (double)this.m_20205_() * Math.cos(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, d0, d1, d2, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    private void strongKnockback(Entity p_33340_) {
        double d0 = p_33340_.m_20185_() - this.m_20185_();
        double d1 = p_33340_.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_33340_.m_5997_(d0 / d2 * 2.0, 0.2, d1 / d2 * 2.0);
    }

    public boolean m_6094_() {
        return this.m_20147_();
    }

    protected void m_6731_(LivingEntity p_33361_) {
        if (this.f_19796_.m_188500_() < 0.5 && this.attackID == 2) {
            this.stunnedTick = 40;
            this.f_19853_.m_7605_((Entity)this, (byte)39);
            p_33361_.m_7334_((Entity)this);
        }
        p_33361_.f_19864_ = true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_(Items.f_42590_) && this.m_21223_() < 10.0f && !this.m_20067_()) {
            boolean flag = this.m_6469_(DamageSource.m_19370_((LivingEntity)player), 2.0f);
            this.m_6469_(DamageSource.f_19319_, 2.0f);
            if (flag) {
                itemstack.m_41774_(1);
                player.m_5496_(SoundEvents.f_11770_, 0.1f, 1.0f);
                player.m_21252_();
                if (itemstack.m_41619_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)ItemRegistry.BOTTLE_OF_BLOOD.get()));
                } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)ItemRegistry.BOTTLE_OF_BLOOD.get()))) {
                    player.m_36176_(new ItemStack((ItemLike)ItemRegistry.BOTTLE_OF_BLOOD.get()), false);
                }
            }
        } else {
            return InteractionResult.FAIL;
        }
        return super.m_6071_(player, hand);
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.f_19853_.m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    private void meleeattack() {
        float range = 3.5f;
        float arc = 80.0f;
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.1);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.m_82376_()), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.m_82376_()), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, 3.5, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20885_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range) || !(entityRelativeAngle <= arc / 2.0f) || !(entityRelativeAngle >= -arc / 2.0f) || entityRelativeAngle >= 360.0f - arc / 2.0f != entityRelativeAngle <= -360.0f + arc / 2.0f || entityHit instanceof NehemothEntity) continue;
            boolean flag = entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
            if (entityHit.m_21254_()) continue;
            entityHit.f_19802_ = 0;
            if (!flag) continue;
            entityHit.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.BLEEDING.get(), 100), (Entity)this);
            entityHit.m_5496_(SoundEvents.f_11692_, 2.0f, 0.4f + this.m_217043_().m_188501_() * 0.1f);
        }
    }

    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        if (this.m_20363_(passenger)) {
            double extraY;
            int tick = 5;
            if (this.attackID == 2) {
                tick = this.attacktick;
                if (this.attacktick == 22) {
                    passenger.m_8127_();
                }
                this.m_146922_(this.f_19859_);
                this.f_20883_ = this.m_146908_();
                this.f_20885_ = this.m_146908_();
            }
            if (this.attackID == 7) {
                tick = this.attacktick;
                if (this.attacktick == 17) {
                    passenger.m_8127_();
                    Vec3 throwVec = this.m_20154_().m_82490_(2.0);
                    throwVec = new Vec3(throwVec.m_7096_(), 0.9, throwVec.m_7094_());
                    float f1 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
                    float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
                    passenger.m_6034_((double)f1 * 1.5, throwVec.m_7098_(), (double)f2 * 1.5);
                }
                this.m_146922_(this.f_19859_);
                this.f_20883_ = this.m_146908_();
                this.f_20885_ = this.m_146908_();
            }
            float radius = 0.3f;
            float math = 1.0f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            double d = extraY = tick < 5 ? 0.0 : (double)(0.2f * (float)Mth.m_14045_((int)(tick - 5), (int)0, (int)5));
            if (passenger.m_20206_() < 1.0f) {
                passenger.m_6034_(this.m_20185_() + (double)(f * math) + extraX, this.m_20186_() + extraY + (double)1.4f, this.m_20189_() + (double)(f1 * math) + extraZ);
            } else {
                passenger.m_6034_(this.m_20185_() + (double)(f * math) + extraX, this.m_20186_() + extraY + (double)0.7f, this.m_20189_() + (double)(f1 * math) + extraZ);
            }
        }
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 p_30562_, LivingEntity p_30563_) {
        double d0 = this.m_20185_() + p_30562_.f_82479_;
        double d1 = this.m_20191_().f_82289_;
        double d2 = this.m_20189_() + p_30562_.f_82481_;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : p_30563_.m_7431_()) {
            blockpos$mutableblockpos.m_122169_(d0, d1, d2);
            double d3 = this.m_20191_().f_82292_ + 0.75;
            do {
                Vec3 vec3;
                AABB aabb;
                double d4 = this.f_19853_.m_45573_((BlockPos)blockpos$mutableblockpos);
                if ((double)blockpos$mutableblockpos.m_123342_() + d4 > d3) continue block0;
                if (DismountHelper.m_38439_((double)d4) && DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)p_30563_, (AABB)(aabb = p_30563_.m_21270_(pose)).m_82383_(vec3 = new Vec3(d0, (double)blockpos$mutableblockpos.m_123342_() + d4, d2)))) {
                    p_30563_.m_20124_(pose);
                    return vec3;
                }
                blockpos$mutableblockpos.m_122173_(Direction.UP);
            } while ((double)blockpos$mutableblockpos.m_123342_() < d3);
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity p_30576_) {
        Vec3 vec3 = NehemothEntity.m_19903_((double)this.m_20205_(), (double)p_30576_.m_20205_(), (float)(this.m_146908_() + (p_30576_.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec31 = this.getDismountLocationInDirection(vec3, p_30576_);
        if (vec31 != null) {
            return vec31;
        }
        Vec3 vec32 = NehemothEntity.m_19903_((double)this.m_20205_(), (double)p_30576_.m_20205_(), (float)(this.m_146908_() + (p_30576_.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec33 = this.getDismountLocationInDirection(vec32, p_30576_);
        return vec33 != null ? vec33 : this.m_20182_();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        super.m_7350_(p_21104_);
    }

    private void roar() {
        if (this.m_6084_()) {
            for (LivingEntity livingentity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(3.0), NO_NEHEMOTH_AND_ALIVE)) {
                if (!(livingentity instanceof NehemothEntity)) {
                    livingentity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 3.0f);
                }
                this.strongKnockback((Entity)livingentity);
            }
            this.m_146850_(GameEvent.f_223709_);
        }
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.NEHEMOTH_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_215763_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215779_;
    }

    protected void m_7355_(BlockPos p_33350_, BlockState p_33351_) {
        this.m_5496_((SoundEvent)SoundRegistry.STOMP.get(), 0.5f, 0.7f);
    }

    public float m_6100_() {
        return 0.7f;
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (p_21016_.m_19360_()) {
            p_21017_ = Math.min(1.0f, p_21017_);
        }
        if (this.attackID == 5 && this.attacktick < 55) {
            return false;
        }
        if (this.attackID == 9) {
            return false;
        }
        if (this.m_20067_() && p_21016_ != DamageSource.f_19317_) {
            return false;
        }
        if (p_21016_.m_19378_()) {
            return super.m_6469_(p_21016_, p_21017_);
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends Monster> p_33018_, ServerLevelAccessor p_33019_, MobSpawnType p_33020_, BlockPos p_33021_, RandomSource p_33022_) {
        return p_33019_.m_46791_() != Difficulty.PEACEFUL && NehemothEntity.m_217057_(p_33018_, (LevelAccessor)p_33019_, (MobSpawnType)p_33020_, (BlockPos)p_33021_, (RandomSource)p_33022_);
    }

    public boolean canRiderInteract() {
        return true;
    }

    protected boolean m_7341_(Entity p_20339_) {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.attackID != 0 || this.m_20067_()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            travelVector = Vec3.f_82478_;
            super.m_7023_(travelVector);
            return;
        }
        super.m_7023_(travelVector);
    }

    private class MeleeAttackGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public MeleeAttackGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 1;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(1);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 39;
        }

        public void m_8037_() {
            NehemothEntity.this.m_146922_(NehemothEntity.this.f_20883_);
            if (this.nehemoth.attacktick < 39 && this.attackTarget.m_6084_()) {
                NehemothEntity.this.m_21391_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    private class BiteAttackGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public BiteAttackGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && NehemothEntity.this.m_20270_((Entity)this.attackTarget) <= 3.0f && NehemothEntity.this.f_19796_.m_188503_(8) == 0;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(2);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
            NehemothEntity.this.m_20153_();
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 23;
        }

        public void m_8037_() {
            if (this.nehemoth.attacktick > 6 && this.attackTarget != null && !this.nehemoth.m_20363_((Entity)this.attackTarget)) {
                NehemothEntity.this.attacktick = 22;
            }
            NehemothEntity.this.f_19865_ = Vec3.f_82478_;
            if (this.attackTarget != null) {
                double dist = this.nehemoth.m_20270_((Entity)this.attackTarget);
                if (this.nehemoth.attacktick < 23 && this.attackTarget.m_6084_()) {
                    NehemothEntity.this.m_21391_((Entity)this.attackTarget, 30.0f, 30.0f);
                }
                if (this.nehemoth.attacktick == 6 && dist <= 3.0) {
                    this.attackTarget.m_7998_((Entity)this.nehemoth, true);
                }
                if (this.nehemoth.attacktick == 17 && dist <= 3.0) {
                    this.attackTarget.m_6469_(DamageSource.m_19370_((LivingEntity)this.nehemoth), (float)this.nehemoth.m_21133_(Attributes.f_22281_));
                }
                if (this.nehemoth.attacktick == 22) {
                    NehemothEntity.this.m_20153_();
                }
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    private class RoarGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public RoarGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && (double)NehemothEntity.this.m_20270_((Entity)this.attackTarget) > 9.0 && NehemothEntity.this.m_20096_() && NehemothEntity.this.f_19796_.m_188503_(120) == 0;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(3);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 25;
        }

        public void m_8037_() {
            NehemothEntity.this.f_19865_ = Vec3.f_82478_;
            if (this.nehemoth.attacktick < 25 && this.attackTarget.m_6084_()) {
                NehemothEntity.this.m_21391_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    private class SmashGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public SmashGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && ((double)NehemothEntity.this.m_20270_((Entity)this.attackTarget) > 5.0 || this.nehemoth.m_20186_() < this.attackTarget.m_20186_() + 3.0 && this.attackTarget.m_20096_()) && NehemothEntity.this.m_20096_() && NehemothEntity.this.f_19796_.m_188503_(38) == 0;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(4);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 38;
        }

        public void m_8037_() {
            NehemothEntity.this.f_19865_ = Vec3.f_82478_;
            if (this.nehemoth.attacktick > 11 && this.nehemoth.attacktick < 14 && NehemothEntity.this.m_20096_()) {
                NehemothEntity.this.m_20260_(false);
                this.nehemoth.attacktick = 38;
            }
            if (NehemothEntity.this.m_20096_() && this.nehemoth.attacktick > 9) {
                NehemothEntity.this.m_6862_(false);
                NehemothEntity.this.m_21573_().m_26569_();
            }
        }
    }

    private class BreathGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public BreathGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && (double)NehemothEntity.this.m_20270_((Entity)this.attackTarget) > 5.0 && NehemothEntity.this.m_20096_() && NehemothEntity.this.f_19796_.m_188503_(32) == 0 && NehemothEntity.this.getVariant() == 1;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(6);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 16;
        }

        public void m_8037_() {
            NehemothEntity.this.f_19865_ = Vec3.f_82478_;
            if (this.nehemoth.attacktick < 16 && this.attackTarget.m_6084_()) {
                NehemothEntity.this.m_21391_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    class DoNothingGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public DoNothingGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            BlockPos blockpos = new BlockPos(NehemothEntity.this.m_20185_(), NehemothEntity.this.m_20188_(), NehemothEntity.this.m_20189_());
            return NehemothEntity.this.f_19853_.m_46461_() && NehemothEntity.this.f_19853_.m_45527_(blockpos) && NehemothEntity.this.getVariant() == 0;
        }

        public void m_8037_() {
            NehemothEntity.this.attackID = 0;
            this.attackTarget = null;
            NehemothEntity.this.m_20225_(true);
            NehemothEntity.this.m_20331_(true);
        }
    }

    private class GuardandRevengeGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public GuardandRevengeGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && (double)NehemothEntity.this.m_20270_((Entity)this.attackTarget) <= 3.0 && NehemothEntity.this.f_19796_.m_188503_(12) == 0 && this.nehemoth.m_21223_() <= 25.0f && (this.attackTarget.f_20911_ || this.attackTarget.m_7327_((Entity)this.nehemoth));
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(5);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 80;
        }

        public void m_8037_() {
            NehemothEntity.this.f_19865_ = Vec3.f_82478_;
            if (this.nehemoth.attacktick < 80 && this.attackTarget.m_6084_()) {
                NehemothEntity.this.f_20883_ = NehemothEntity.this.f_20885_;
                NehemothEntity.this.m_21391_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    private class GuardGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public GuardGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && (double)NehemothEntity.this.m_20270_((Entity)this.attackTarget) <= 3.0 && NehemothEntity.this.f_19796_.m_188503_(3) == 0 && this.attackTarget.f_20911_;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(9);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 20;
        }

        public void m_8037_() {
            NehemothEntity.this.f_19865_ = Vec3.f_82478_;
            if (this.nehemoth.attacktick < 20 && this.attackTarget.m_6084_()) {
                NehemothEntity.this.f_20883_ = NehemothEntity.this.f_20885_;
                NehemothEntity.this.m_21391_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    private class ThrowingGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public ThrowingGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && NehemothEntity.this.m_20270_((Entity)this.attackTarget) <= 3.0f && NehemothEntity.this.f_19796_.m_188503_(8) == 0 && !(this.attackTarget instanceof ServerPlayer);
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(7);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
            NehemothEntity.this.m_20153_();
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 23;
        }

        public void m_8037_() {
            if (this.nehemoth.attacktick > 6 && this.nehemoth.attacktick < 16 && this.attackTarget != null && !this.nehemoth.m_20363_((Entity)this.attackTarget)) {
                NehemothEntity.this.attacktick = 22;
            }
            NehemothEntity.this.f_19865_ = Vec3.f_82478_;
            if (this.attackTarget != null) {
                double dist = this.nehemoth.m_20270_((Entity)this.attackTarget);
                if (this.nehemoth.attacktick < 23 && this.attackTarget.m_6084_()) {
                    NehemothEntity.this.m_21391_((Entity)this.attackTarget, 30.0f, 30.0f);
                }
                if (this.nehemoth.attacktick == 6 && dist <= 3.0) {
                    this.attackTarget.m_7998_((Entity)this.nehemoth, true);
                }
                if (this.nehemoth.attacktick == 22) {
                    // empty if block
                }
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    private class MeleeAttackReverseGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public MeleeAttackReverseGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 8;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(8);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 39;
        }

        public void m_8037_() {
            NehemothEntity.this.m_146922_(NehemothEntity.this.f_20883_);
            if (this.nehemoth.attacktick < 39 && this.attackTarget.m_6084_()) {
                NehemothEntity.this.m_21391_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }
}

