/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.entity;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.sonmok14.fromtheshadows.Fromtheshadows;
import net.sonmok14.fromtheshadows.utils.registry.EntityRegistry;
import org.slf4j.Logger;

public class FallingBlockEntity
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private BlockState blockState = Blocks.f_49992_.m_49966_();
    public int time;
    public boolean dropItem = true;
    private boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    @Nullable
    public CompoundTag blockData;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(net.minecraft.world.entity.item.FallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public FallingBlockEntity(EntityType<FallingBlockEntity> type, Level level) {
        super(type, level);
    }

    public FallingBlockEntity(Level p_31953_, double p_31954_, double p_31955_, double p_31956_, BlockState p_31957_) {
        this((EntityType<FallingBlockEntity>)((EntityType)EntityRegistry.FALLING_BLOCK.get()), p_31953_);
        this.blockState = p_31957_;
        this.f_19850_ = true;
        this.m_6034_(p_31954_, p_31955_ + (double)((1.0f - this.m_20206_()) / 2.0f), p_31956_);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = p_31954_;
        this.f_19855_ = p_31955_;
        this.f_19856_ = p_31956_;
        this.setStartPos(this.m_20183_());
    }

    public boolean m_6097_() {
        return false;
    }

    public void setStartPos(BlockPos p_31960_) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)p_31960_);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        if (this.blockState.m_60795_()) {
            this.m_146870_();
        } else {
            Block block = this.blockState.m_60734_();
            ++this.time;
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (!this.f_19853_.f_46443_) {
                BlockHitResult blockhitresult;
                BlockPos blockpos = this.m_20183_();
                boolean flag = this.blockState.m_60734_() instanceof ConcretePowderBlock;
                boolean flag1 = flag && this.f_19853_.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
                double d0 = this.m_20184_().m_82556_();
                if (flag && d0 > 1.0 && (blockhitresult = this.f_19853_.m_45547_(new ClipContext(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_), this.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).m_6662_() != HitResult.Type.MISS && this.f_19853_.m_6425_(blockhitresult.m_82425_()).m_205070_(FluidTags.f_13131_)) {
                    blockpos = blockhitresult.m_82425_();
                    flag1 = true;
                }
                if (!this.f_19861_ && !flag1) {
                    if (!(this.f_19853_.f_46443_ || (this.time <= 100 || blockpos.m_123342_() > this.f_19853_.m_141937_() && blockpos.m_123342_() <= this.f_19853_.m_151558_()) && this.time <= 600)) {
                        if (this.dropItem && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.m_19998_((ItemLike)block);
                        }
                        this.m_146870_();
                    }
                } else {
                    BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                    this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                    if (!blockstate.m_60713_(Blocks.f_50110_)) {
                        if (!this.cancelDrop) {
                            boolean flag4;
                            boolean flag2 = blockstate.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.f_19853_, blockpos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
                            boolean flag3 = FallingBlock.m_53241_((BlockState)this.f_19853_.m_8055_(blockpos.m_7495_())) && (!flag || !flag1);
                            boolean bl = flag4 = this.blockState.m_60710_((LevelReader)this.f_19853_, blockpos) && !flag3;
                            if (flag2 && flag4) {
                                if (this.blockState.m_61138_((Property)BlockStateProperties.f_61362_) && this.f_19853_.m_6425_(blockpos).m_76152_() == Fluids.f_76193_) {
                                    this.blockState = (BlockState)this.blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                                }
                                if (this.f_19853_.m_7731_(blockpos, this.blockState, 3)) {
                                    BlockEntity blockentity;
                                    ((ServerLevel)this.f_19853_).m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos, this.f_19853_.m_8055_(blockpos)));
                                    this.m_146870_();
                                    if (this.blockData != null && this.blockState.m_155947_() && (blockentity = this.f_19853_.m_7702_(blockpos)) != null) {
                                        CompoundTag compoundtag = blockentity.m_187482_();
                                        for (String s : this.blockData.m_128431_()) {
                                            compoundtag.m_128365_(s, this.blockData.m_128423_(s).m_6426_());
                                        }
                                        try {
                                            blockentity.m_142466_(compoundtag);
                                        }
                                        catch (Exception exception) {
                                            Fromtheshadows.LOGGER.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        blockentity.m_6596_();
                                    }
                                } else if (this.dropItem && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                                    this.m_146870_();
                                    this.m_19998_((ItemLike)block);
                                }
                            } else {
                                this.m_146870_();
                                if (this.dropItem && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                                    this.m_19998_((ItemLike)block);
                                }
                            }
                        } else {
                            this.m_146870_();
                        }
                    }
                }
            }
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
    }

    public boolean m_142535_(float p_149643_, float p_149644_, DamageSource p_149645_) {
        return false;
    }

    protected void m_7380_(CompoundTag p_31973_) {
        p_31973_.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        p_31973_.m_128405_("Time", this.time);
        p_31973_.m_128379_("DropItem", this.dropItem);
        p_31973_.m_128379_("HurtEntities", this.hurtEntities);
        p_31973_.m_128350_("FallHurtAmount", this.fallDamagePerDistance);
        p_31973_.m_128405_("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            p_31973_.m_128365_("TileEntityData", (Tag)this.blockData);
        }
    }

    protected void m_7378_(CompoundTag p_31964_) {
        this.blockState = NbtUtils.m_129241_((CompoundTag)p_31964_.m_128469_("BlockState"));
        this.time = p_31964_.m_128451_("Time");
        if (p_31964_.m_128425_("HurtEntities", 99)) {
            this.hurtEntities = p_31964_.m_128471_("HurtEntities");
            this.fallDamagePerDistance = p_31964_.m_128457_("FallHurtAmount");
            this.fallDamageMax = p_31964_.m_128451_("FallHurtMax");
        } else if (this.blockState.m_204336_(BlockTags.f_13033_)) {
            this.hurtEntities = true;
        }
        if (p_31964_.m_128425_("DropItem", 99)) {
            this.dropItem = p_31964_.m_128471_("DropItem");
        }
        if (p_31964_.m_128425_("TileEntityData", 10)) {
            this.blockData = p_31964_.m_128469_("TileEntityData");
        }
        if (this.blockState.m_60795_()) {
            this.blockState = Blocks.f_49992_.m_49966_();
        }
    }

    public void setHurtsEntities(float p_149657_, int p_149658_) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = p_149657_;
        this.fallDamageMax = p_149658_;
    }

    public boolean m_6051_() {
        return false;
    }

    public void m_7976_(CrashReportCategory p_31962_) {
        super.m_7976_(p_31962_);
        p_31962_.m_128159_("Immitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public boolean m_6127_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.getBlockState()));
    }

    public void m_141965_(ClientboundAddEntityPacket p_149654_) {
        super.m_141965_(p_149654_);
        this.blockState = Block.m_49803_((int)p_149654_.m_131509_());
        this.f_19850_ = true;
        double d0 = p_149654_.m_131500_();
        double d1 = p_149654_.m_131501_();
        double d2 = p_149654_.m_131502_();
        this.m_6034_(d0, d1, d2);
        this.setStartPos(this.m_20183_());
    }
}

