/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.sonmok14.fromtheshadows.entity.ArmoredNehemothEntity;
import net.sonmok14.fromtheshadows.entity.FallingBlockEntity;
import net.sonmok14.fromtheshadows.entity.ScreenShakeEntity;
import net.sonmok14.fromtheshadows.utils.registry.EntityRegistry;
import net.sonmok14.fromtheshadows.utils.registry.ParticleRegistry;

public class BreathEntity
extends AbstractHurtingProjectile {
    protected int timeInAir;
    protected boolean inAir;
    private int ticksInAir;
    private LivingEntity shooter;

    public BreathEntity(EntityType<? extends BreathEntity> p_i50160_1_, Level p_i50160_2_) {
        super(p_i50160_1_, p_i50160_2_);
    }

    public BreathEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType)EntityRegistry.BREATH.get(), shooter, accelX, accelY, accelZ, worldIn);
        this.shooter = shooter;
    }

    protected void m_8097_() {
    }

    public boolean m_6783_(double p_36837_) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return p_36837_ < (d0 *= 64.0) * d0;
    }

    public void m_8119_() {
        Entity entity = this.m_37282_();
        if (this.f_19853_.f_46443_ || (entity == null || !entity.m_213877_()) && this.f_19853_.m_46805_(this.m_20183_())) {
            int i;
            HitResult hitresult;
            super.m_8119_();
            if (this.m_5931_()) {
                this.m_20254_(0);
            }
            if ((hitresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            Vec3 vec3 = this.m_20184_();
            double d0 = this.m_20185_() + vec3.f_82479_;
            double d1 = this.m_20186_() + vec3.f_82480_;
            double d2 = this.m_20189_() + vec3.f_82481_;
            this.m_20101_();
            ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
            float f = this.m_6884_();
            if (this.m_20069_()) {
                for (i = 0; i < 4; ++i) {
                    float f1 = 0.25f;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, d0 - vec3.f_82479_ * 0.25, d1 - vec3.f_82480_ * 0.25, d2 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
                f = 0.8f;
            }
            ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
            if (this.f_19853_.f_46443_) {
                for (i = 0; i < 15; ++i) {
                    Vec3 vec31 = this.m_20184_();
                    this.m_6034_(this.m_20185_() + vec31.f_82479_, this.m_20186_() + vec31.f_82480_, this.m_20189_() + vec31.f_82481_);
                    this.f_19853_.m_7106_((ParticleOptions)ParticleRegistry.LASER.get(), this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_ + 0.15, this.m_20189_() - vec31.f_82481_, 0.1, 0.1, 0.1);
                }
            }
            this.m_20256_(vec3.m_82520_(this.f_36813_, this.f_36814_, this.f_36815_).m_82490_((double)f));
            this.f_19853_.m_7106_(this.m_5967_(), d0, d1 + 0.5, d2, 0.0, 0.0, 0.0);
            this.m_6034_(d0, d1, d2);
        } else {
            this.m_146870_();
        }
    }

    private void roar() {
        if (this.m_6084_()) {
            for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(4.0))) {
                if (livingentity instanceof ArmoredNehemothEntity) continue;
                livingentity.m_6469_(DamageSource.m_19370_((LivingEntity)this.shooter), 6.0f);
            }
            this.f_19853_.m_220400_((Entity)this, GameEvent.f_223709_, this.m_146892_());
        }
    }

    protected boolean m_5603_(Entity p_36842_) {
        return super.m_5603_(p_36842_) && !p_36842_.f_19794_;
    }

    protected boolean m_5931_() {
        return false;
    }

    protected float m_6884_() {
        return 0.95f;
    }

    public boolean m_6087_() {
        return false;
    }

    private void smash(int distance) {
        double perpFacing = (double)this.m_146908_() * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * 2;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance;
            double pz = this.m_20189_() + vz * (double)distance;
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) continue;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY, hitZ);
            BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
            BlockState block = this.f_19853_.m_8055_(pos);
            BlockState blockAbove = this.f_19853_.m_8055_(abovePos);
            if (block.m_60767_() == Material.f_76296_ || block.m_155947_() || blockAbove.m_60767_().m_76334_()) continue;
            FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(this.f_19853_, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
            this.f_19853_.m_7731_(pos, block.m_60819_().m_76188_(), 3);
            fallingBlockEntity.m_5997_(0.0, 0.2 + this.f_19796_.m_188583_() * 0.15, 0.0);
            this.f_19853_.m_7967_((Entity)fallingBlockEntity);
        }
    }

    public boolean m_6469_(DamageSource p_36839_, float p_36840_) {
        if (this.m_6673_(p_36839_)) {
            return false;
        }
        this.m_5834_();
        Entity entity = p_36839_.m_7639_();
        if (entity != null) {
            Vec3 vec3 = entity.m_20154_();
            this.m_20256_(vec3);
            this.f_36813_ = vec3.f_82479_ * 0.1;
            this.f_36814_ = vec3.f_82480_ * 0.1;
            this.f_36815_ = vec3.f_82481_ * 0.1;
            this.m_5602_(entity);
            return true;
        }
        return false;
    }

    public float getBrightness() {
        return 1.0f;
    }

    public Packet<?> m_5654_() {
        Entity entity = this.m_37282_();
        int i = entity == null ? 0 : entity.m_19879_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), i, new Vec3(this.f_36813_, this.f_36814_, this.f_36815_), 0.0);
    }

    public void m_141965_(ClientboundAddEntityPacket p_150128_) {
        super.m_141965_(p_150128_);
        double d0 = p_150128_.m_131503_();
        double d1 = p_150128_.m_131504_();
        double d2 = p_150128_.m_131505_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        if (d3 != 0.0) {
            this.f_36813_ = d0 / d3 * 0.1;
            this.f_36814_ = d1 / d3 * 0.1;
            this.f_36815_ = d2 / d3 * 0.1;
        }
    }

    protected void m_6532_(HitResult p_37218_) {
        super.m_6532_(p_37218_);
        if (!this.f_19853_.f_46443_) {
            this.m_5496_(SoundEvents.f_11892_, 1.5f, 1.0f + this.f_19796_.m_188501_() * 0.1f);
            ScreenShakeEntity.ScreenShake(this.f_19853_, this.m_20182_(), 15.0f, 0.2f, 0, 10);
            this.smash(3);
            this.roar();
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult p_37216_) {
        super.m_5790_(p_37216_);
        if (!this.f_19853_.f_46443_) {
            this.m_5496_(SoundEvents.f_11892_, 1.5f, 1.0f + this.f_19796_.m_188501_() * 0.1f);
            Entity entity = p_37216_.m_82443_();
            Entity entity1 = this.m_37282_();
            ScreenShakeEntity.ScreenShake(this.f_19853_, this.m_20182_(), 15.0f, 0.2f, 0, 10);
            entity.m_6469_(DamageSource.f_19319_, 6.0f);
            this.smash(4);
            this.roar();
            if (entity1 instanceof LivingEntity) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }
}

