/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.sonmok14.fromtheshadows.entity.BreathEntity;
import net.sonmok14.fromtheshadows.entity.FallingBlockEntity;
import net.sonmok14.fromtheshadows.entity.NehemothEntity;
import net.sonmok14.fromtheshadows.entity.ScreenShakeEntity;
import net.sonmok14.fromtheshadows.utils.registry.ItemRegistry;
import net.sonmok14.fromtheshadows.utils.registry.SoundRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ArmoredNehemothEntity
extends Monster
implements Enemy,
IAnimatable,
IAnimationTickable {
    private static final Predicate<Entity> NO_NEHEMOTH_AND_ALIVE = p_33346_ -> p_33346_.m_6084_() && !(p_33346_ instanceof ArmoredNehemothEntity);
    public int attackID;
    private int stunnedTick;
    public int attacktick;
    public int armortick;
    public static final byte MELEE_ATTACK = 1;
    public static final byte SHOT_ATTACK = 2;
    public static final byte ROAR_ATTACK = 3;
    public static final byte SMASH_ATTACK = 4;
    public static final byte DASH_ATTACK = 5;
    private static final EntityDataAccessor<Boolean> ARMORED = SynchedEntityData.m_135353_(ArmoredNehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ArmoredNehemothEntity(EntityType<? extends ArmoredNehemothEntity> type, Level world) {
        super(type, world);
        this.f_19793_ = 3.0f;
        this.f_21364_ = 80;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, 9.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22283_, 2.0);
    }

    private <E extends IAnimatable> PlayState predicate2(AnimationEvent<E> event) {
        if (this.attackID == 1 && this.m_6084_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.meleeattack2", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        BlockPos blockpos = new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_());
        if (!this.m_20067_()) {
            if (event.isMoving() && this.m_5912_() && this.attackID == 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.run", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.none2", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.roar", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (!this.m_6107_()) {
                if (this.attackID == 1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.meleeattack", Boolean.valueOf(true)));
                    return PlayState.CONTINUE;
                }
                if (this.attackID == 2 && this.attacktick < 5) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.bulk", Boolean.valueOf(true)));
                    return PlayState.CONTINUE;
                }
                if (this.attackID == 2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.breath", Boolean.valueOf(true)));
                    return PlayState.CONTINUE;
                }
            }
            if (this.attackID == 4 && this.m_20096_() && this.attacktick > 8) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.smash", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (!this.m_6084_() || (double)this.m_21223_() == 0.1 || this.m_21224_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.death", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 4 && !this.m_20096_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.jump", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 5 && this.attacktick < 55) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.guard", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (this.attackID == 5 && this.attacktick > 55) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.bulk", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (this.m_6107_() && this.m_6084_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.stun", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.walk", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (!event.isMoving() && this.attackID == 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.ldle", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
        } else if (this.m_20067_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dracan.stop1", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public boolean isArmored() {
        return (Boolean)this.f_19804_.m_135370_(ARMORED);
    }

    public void setArmored(boolean p_32759_) {
        this.f_19804_.m_135381_(ARMORED, (Object)p_32759_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ARMORED, (Object)true);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 3.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller2", 8.0f, this::predicate2));
    }

    public boolean m_7327_(Entity p_85031_1_) {
        if (!this.f_19853_.f_46443_ && this.attackID == 0) {
            this.attackID = this.f_19796_.m_188503_(4) != 0 ? 1 : 1;
        }
        return true;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 50) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new net.minecraft.world.entity.ai.goal.MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SmashGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new BreathGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new RoarGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DoNothingGoal());
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true, p_199899_ -> !p_199899_.m_6162_()));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{ArmoredNehemothEntity.class}));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)(-id));
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else if (id == 39) {
            this.stunnedTick = 40;
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_46462_()) {
            this.m_20331_(false);
            this.m_20225_(false);
        }
        if (this.attackID != 0) {
            ++this.attacktick;
        }
        if (this.m_5448_() != null) {
            if (this.attackID == 4 && this.m_20096_() && this.m_6144_() && this.attacktick > 8) {
                Player player;
                if (this.m_5448_() instanceof Player && (player = (Player)this.m_5448_()).m_21254_()) {
                    player.m_36384_(true);
                }
                this.m_20260_(false);
                ScreenShakeEntity.ScreenShake(this.f_19853_, this.m_20182_(), 15.0f, 0.2f, 0, 10);
                this.smash(4);
                this.roar();
                this.m_5496_(SoundEvents.f_11913_, 2.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
                if (this.f_19853_.f_46443_) {
                    BlockState block = this.f_19853_.m_8055_(this.m_20183_().m_7495_());
                    for (int j = 0; j < 24; ++j) {
                        float f = this.f_19796_.m_188501_() * ((float)Math.PI * 4);
                        float f1 = this.f_19796_.m_188501_() * 0.8f + 0.8f;
                        float f2 = Mth.m_14031_((float)f) * 3.0f * 0.8f * f1;
                        float f3 = Mth.m_14089_((float)f) * 3.0f * 0.8f * f1;
                        this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.attackID == 5 && this.attacktick == 55) {
                this.roar();
                ScreenShakeEntity.ScreenShake(this.f_19853_, this.m_20182_(), 15.0f, 0.2f, 0, 10);
                this.m_5496_((SoundEvent)SoundRegistry.NEHEMOTH_ROAR.get(), 1.5f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
            }
            if (this.attackID == 2 && this.attacktick == 1) {
                this.m_5496_((SoundEvent)SoundRegistry.WARNING.get(), 1.5f, 0.7f);
            }
            if (this.attackID == 2 && this.attacktick == 8) {
                this.m_5496_(SoundEvents.f_11932_, 2.0f, 0.1f + this.m_217043_().m_188501_() * 0.1f);
                double d1 = 4.0;
                LivingEntity livingEntity = this.m_5448_();
                Vec3 vec3 = this.m_20252_(1.0f);
                double d2 = livingEntity.m_20185_() - (this.m_20185_() + vec3.f_82479_ * 4.0);
                double d3 = livingEntity.m_20227_(0.5) - (0.5 + this.m_20227_(0.5));
                double d4 = livingEntity.m_20189_() - (this.m_20189_() + vec3.f_82481_ * 4.0);
                BreathEntity largefireball = new BreathEntity(this.f_19853_, (LivingEntity)this, d2, d3, d4);
                largefireball.m_6034_(this.m_20185_() + vec3.f_82479_ * 0.3, this.m_20227_(0.52), largefireball.m_20189_() + vec3.f_82481_ * 0.1);
                this.f_19853_.m_7967_((Entity)largefireball);
            }
        }
        if (this.attackID == 1) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.24);
        }
        if (this.attackID != 1) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.35);
        }
        if (this.attacktick == 7 && this.attackID == 1) {
            this.m_146922_(this.f_20883_);
            this.m_6478_(MoverType.SELF, new Vec3(Math.cos(Math.toRadians(this.m_146908_() + 90.0f)), 0.0, Math.sin(Math.toRadians(this.m_146908_() + 90.0f))));
        }
        if (this.attacktick == 28 && this.attackID == 1) {
            this.m_146922_(this.f_20883_);
            this.m_6478_(MoverType.SELF, new Vec3(Math.cos(Math.toRadians(this.m_146908_() + 90.0f)), 0.0, Math.sin(Math.toRadians(this.m_146908_() + 90.0f))));
        }
        if (this.attacktick == 11 && this.attackID == 1) {
            this.meleeattack();
            this.m_5496_(SoundEvents.f_12317_, 3.0f, 0.5f + this.m_217043_().m_188501_() * 0.1f);
        }
        if (this.attacktick == 31 && this.attackID == 1) {
            this.meleeattack();
            this.m_5496_(SoundEvents.f_12317_, 3.0f, 0.5f + this.m_217043_().m_188501_() * 0.1f);
        }
        if (this.attackID == 3) {
            this.roar();
            if (this.attacktick == 1) {
                this.m_5496_((SoundEvent)SoundRegistry.NEHEMOTH_ROAR.get(), 1.5f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
                ScreenShakeEntity.ScreenShake(this.f_19853_, this.m_20182_(), 20.0f, 0.2f, 20, 10);
            }
        }
        float f = this.m_213856_();
        BlockPos blockpos = new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_());
        if (this.stunnedTick > 0) {
            --this.stunnedTick;
            this.stunEffect();
        }
        if (!this.f_19853_.m_45527_(blockpos) && this.m_20067_()) {
            this.m_20331_(false);
            this.m_20225_(false);
        }
        if (!this.isArmored()) {
            ++this.armortick;
            if (this.armortick > 200) {
                this.armortick = 0;
                this.sphereparticle(2.0f, 5.0f);
                if (!this.f_19853_.f_46443_) {
                    this.setArmored(true);
                    this.m_5496_(SoundEvents.f_12513_, 1.5f, 0.2f + this.m_217043_().m_188501_() * 0.1f);
                }
            }
        }
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.stunnedTick > 0;
    }

    public boolean m_142582_(Entity p_149755_) {
        return this.stunnedTick <= 0 && super.m_142582_(p_149755_);
    }

    public int getStunnedTick() {
        return this.stunnedTick;
    }

    private void stunEffect() {
        if (this.f_19796_.m_188503_(6) == 0) {
            double d0 = this.m_20185_() - (double)this.m_20205_() * Math.sin(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            double d1 = this.m_20186_() + (double)this.m_20206_() - 0.3;
            double d2 = this.m_20189_() + (double)this.m_20205_() * Math.cos(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, d0, d1, d2, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    public boolean m_7307_(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (super.m_7307_(p_32665_)) {
            return true;
        }
        return p_32665_ instanceof NehemothEntity;
    }

    private void smash(int distance) {
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * 2;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance;
            double pz = this.m_20189_() + vz * (double)distance;
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) continue;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY, hitZ);
            BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
            BlockState block = this.f_19853_.m_8055_(pos);
            BlockState blockAbove = this.f_19853_.m_8055_(abovePos);
            if (block.m_60767_() == Material.f_76296_ || block.m_155947_() || blockAbove.m_60767_().m_76334_()) continue;
            FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(this.f_19853_, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
            this.f_19853_.m_7731_(pos, block.m_60819_().m_76188_(), 3);
            fallingBlockEntity.m_5997_(0.0, 0.2 + this.m_217043_().m_188583_() * 0.15, 0.0);
            this.f_19853_.m_7967_((Entity)fallingBlockEntity);
        }
    }

    private void strongKnockback(Entity p_33340_) {
        double d0 = p_33340_.m_20185_() - this.m_20185_();
        double d1 = p_33340_.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_33340_.m_5997_(d0 / d2 * 2.0, 0.2, d1 / d2 * 2.0);
    }

    public boolean canBeControlledByRider() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (itemstack.m_150930_(Items.f_42590_) && this.m_21223_() < 10.0f && !this.m_20067_()) {
            boolean flag = this.m_6469_(DamageSource.m_19370_((LivingEntity)player), 2.0f);
            this.m_6469_(DamageSource.f_19319_, 2.0f);
            if (flag) {
                itemstack.m_41774_(1);
                player.m_5496_(SoundEvents.f_11770_, 0.1f, 1.0f);
                player.m_21252_();
                if (itemstack.m_41619_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)ItemRegistry.BOTTLE_OF_BLOOD.get()));
                } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)ItemRegistry.BOTTLE_OF_BLOOD.get()))) {
                    player.m_36176_(new ItemStack((ItemLike)ItemRegistry.BOTTLE_OF_BLOOD.get()), false);
                }
            }
        } else {
            return InteractionResult.FAIL;
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    private void meleeattack() {
        float range = 3.0f;
        float arc = 60.0f;
        List entitiesHit = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(3.0), NO_NEHEMOTH_AND_ALIVE);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20885_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range) || !(entityRelativeAngle <= arc / 2.0f) || !(entityRelativeAngle >= -arc / 2.0f) || entityRelativeAngle >= 360.0f - arc / 2.0f != entityRelativeAngle <= -360.0f + arc / 2.0f || entityHit instanceof ArmoredNehemothEntity) continue;
            entityHit.f_19802_ = 0;
            entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        }
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            float radius = 0.5f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = radius * Mth.m_14031_((float)((float)(3.141592653589792 + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            passenger.m_6034_(this.m_20185_() + extraX, this.m_20186_() - (double)0.17f, this.m_20189_() + extraZ);
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        super.m_7350_(p_21104_);
    }

    private void roar() {
        if (this.m_6084_()) {
            for (LivingEntity livingentity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(3.5), NO_NEHEMOTH_AND_ALIVE)) {
                if (!(livingentity instanceof ArmoredNehemothEntity)) {
                    livingentity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 6.0f);
                }
                this.strongKnockback((Entity)livingentity);
            }
            this.m_146850_(GameEvent.f_223709_);
        }
    }

    public static boolean canNehemothSpawnInLight(EntityType<? extends ArmoredNehemothEntity> p_223325_0_, ServerLevelAccessor p_223325_1_, MobSpawnType p_223325_2_, BlockPos p_223325_3_, RandomSource p_223325_4_) {
        return ArmoredNehemothEntity.m_217057_(p_223325_0_, (LevelAccessor)p_223325_1_, (MobSpawnType)p_223325_2_, (BlockPos)p_223325_3_, (RandomSource)p_223325_4_);
    }

    public static <T extends Mob> boolean canNehemothSpawn(EntityType<ArmoredNehemothEntity> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockState blockstate = iServerWorld.m_8055_(pos.m_7495_());
        return reason == MobSpawnType.SPAWNER || !iServerWorld.m_45527_(pos) && pos.m_123342_() <= 64 && ArmoredNehemothEntity.canNehemothSpawnInLight(entityType, iServerWorld, reason, pos, random);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_144212_;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_12360_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12359_;
    }

    protected void m_7355_(BlockPos p_33350_, BlockState p_33351_) {
        this.m_5496_(SoundEvents.f_12361_, 0.3f, 0.1f);
    }

    public float m_6100_() {
        return 0.1f;
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (p_21016_.m_19360_()) {
            p_21017_ = Math.min(1.0f, p_21017_);
        }
        if (this.attackID == 5 && this.attacktick < 55) {
            return false;
        }
        if (this.isArmored() && this.attackID == 2 && this.attacktick < 13 && p_21017_ > 0.0f) {
            if (!this.f_19853_.f_46443_) {
                this.setArmored(false);
                this.m_5496_(SoundEvents.f_12513_, 1.5f, 0.2f + this.m_217043_().m_188501_() * 0.1f);
            } else {
                this.sphereparticle(2.0f, 5.0f);
                p_21017_ = Math.min(3.0f, p_21017_);
                return true;
            }
        }
        if (this.m_20067_() && p_21016_ != DamageSource.f_19317_) {
            return false;
        }
        if (this.isArmored() && p_21016_ != DamageSource.f_19317_ && (this.attackID != 2 || this.attacktick >= 11)) {
            return false;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    private void sphereparticle(float height, float size) {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_() + (double)height;
        double d2 = this.m_20189_();
        for (float i = -size; i <= size; i += 1.0f) {
            for (float j = -size; j <= size; j += 1.0f) {
                for (float k = -size; k <= size; k += 1.0f) {
                    double d3 = (double)j + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double d4 = (double)i + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double d5 = (double)k + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + this.f_19796_.m_188583_() * 0.05;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123815_, d0, d1, d2, d3 / d6, d4 / d6, d5 / d6);
                    if (i == -size || i == size || j == -size || j == size) continue;
                    k += size * 2.0f - 1.0f;
                }
            }
        }
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends Monster> p_33018_, ServerLevelAccessor p_33019_, MobSpawnType p_33020_, BlockPos p_33021_, RandomSource p_33022_) {
        return p_33019_.m_46791_() != Difficulty.PEACEFUL && ArmoredNehemothEntity.m_217057_(p_33018_, (LevelAccessor)p_33019_, (MobSpawnType)p_33020_, (BlockPos)p_33021_, (RandomSource)p_33022_);
    }

    public static void applyDarknessAround(ServerLevel p_219376_, Vec3 p_219377_, @javax.annotation.Nullable Entity p_219378_, int p_219379_) {
        MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.f_216964_, 260, 0, false, false);
        MobEffectUtil.m_216946_((ServerLevel)p_219376_, (Entity)p_219378_, (Vec3)p_219377_, (double)p_219379_, (MobEffectInstance)mobeffectinstance, (int)200);
    }

    private class MeleeAttackGoal
    extends Goal {
        private final ArmoredNehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public MeleeAttackGoal(ArmoredNehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 1;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(1);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 37;
        }

        public void m_8037_() {
            if (this.nehemoth.attacktick < 37 && this.attackTarget.m_6084_()) {
                this.nehemoth.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            double dist = this.nehemoth.m_20270_((Entity)this.attackTarget);
        }
    }

    private class SmashGoal
    extends Goal {
        private final ArmoredNehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public SmashGoal(ArmoredNehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && ((double)ArmoredNehemothEntity.this.m_20270_((Entity)this.attackTarget) > 5.0 || this.nehemoth.m_20186_() < this.attackTarget.m_20186_() + 3.0 && this.attackTarget.m_20096_()) && ArmoredNehemothEntity.this.m_20096_() && ArmoredNehemothEntity.this.f_19796_.m_188503_(38) == 0;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(4);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 31;
        }

        public void m_8037_() {
            ArmoredNehemothEntity.this.f_19865_ = Vec3.f_82478_;
            double dist = this.nehemoth.m_20270_((Entity)this.attackTarget);
            if (this.nehemoth.attacktick < 31 && this.attackTarget.m_6084_()) {
                ArmoredNehemothEntity.this.f_20883_ = ArmoredNehemothEntity.this.f_20885_;
                this.nehemoth.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (this.nehemoth.attacktick == 2) {
                ArmoredNehemothEntity.this.m_6862_(true);
                ArmoredNehemothEntity.this.m_20260_(true);
                if (this.nehemoth.m_20186_() < this.attackTarget.m_20186_() + 3.0 && this.attackTarget.m_20096_()) {
                    ArmoredNehemothEntity.this.m_20334_((this.attackTarget.m_20185_() - ArmoredNehemothEntity.this.m_20185_()) * 0.2, 1.1, (this.attackTarget.m_20189_() - ArmoredNehemothEntity.this.m_20189_()) * 0.2);
                }
                if (this.nehemoth.m_20186_() >= this.attackTarget.m_20186_()) {
                    ArmoredNehemothEntity.this.m_20334_((this.attackTarget.m_20185_() - ArmoredNehemothEntity.this.m_20185_()) * 0.2, 0.8, (this.attackTarget.m_20189_() - ArmoredNehemothEntity.this.m_20189_()) * 0.2);
                }
            }
            if (this.nehemoth.attacktick > 2 && this.nehemoth.attacktick < 7 && ArmoredNehemothEntity.this.m_20096_()) {
                ArmoredNehemothEntity.this.m_20260_(false);
                this.nehemoth.attacktick = 31;
            }
            if (ArmoredNehemothEntity.this.m_20096_() && this.nehemoth.attacktick > 2) {
                ArmoredNehemothEntity.this.m_6862_(false);
            }
        }
    }

    private class BreathGoal
    extends Goal {
        private final ArmoredNehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public BreathGoal(ArmoredNehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && (double)ArmoredNehemothEntity.this.m_20270_((Entity)this.attackTarget) > 5.0 && ArmoredNehemothEntity.this.m_20096_() && ArmoredNehemothEntity.this.f_19796_.m_188503_(32) == 0 && ArmoredNehemothEntity.this.isArmored();
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(2);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 16;
        }

        public void m_8037_() {
            ArmoredNehemothEntity.this.f_19865_ = Vec3.f_82478_;
            double dist = this.nehemoth.m_20270_((Entity)this.attackTarget);
            if (this.nehemoth.attacktick < 16 && this.attackTarget.m_6084_()) {
                this.nehemoth.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
        }
    }

    private class RoarGoal
    extends Goal {
        private final ArmoredNehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public RoarGoal(ArmoredNehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && (double)ArmoredNehemothEntity.this.m_20270_((Entity)this.attackTarget) > 9.0 && ArmoredNehemothEntity.this.m_20096_() && ArmoredNehemothEntity.this.f_19796_.m_188503_(52) == 0;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(3);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 25;
        }

        public void m_8037_() {
            ArmoredNehemothEntity.this.f_19865_ = Vec3.f_82478_;
            double dist = this.nehemoth.m_20270_((Entity)this.attackTarget);
            if (this.nehemoth.attacktick < 25 && this.attackTarget.m_6084_()) {
                this.nehemoth.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
        }
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            float f = ArmoredNehemothEntity.this.m_213856_();
            BlockPos blockpos = new BlockPos(ArmoredNehemothEntity.this.m_20185_(), ArmoredNehemothEntity.this.m_20188_(), ArmoredNehemothEntity.this.m_20189_());
            return ArmoredNehemothEntity.this.f_19853_.m_46461_() && ArmoredNehemothEntity.this.f_19853_.m_45527_(blockpos);
        }

        public void m_8037_() {
            ArmoredNehemothEntity.this.m_20225_(true);
            ArmoredNehemothEntity.this.m_20331_(true);
        }
    }
}

