/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.item.BlueprintBoatItem;
import com.teamabnormals.blueprint.common.item.FuelItem;
import com.teamabnormals.blueprint.core.registry.BoatTypeRegistry;
import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemSubRegistryHelper
extends AbstractSubRegistryHelper<Item> {
    public ItemSubRegistryHelper(RegistryHelper parent, DeferredRegister<Item> deferredRegister) {
        super(parent, deferredRegister);
    }

    public ItemSubRegistryHelper(RegistryHelper parent) {
        super(parent, DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)parent.getModId()));
    }

    public static BlockItem createStandingAndWallBlockItem(Block floorBlock, Block wallBlock, CreativeModeTab itemGroup) {
        return new StandingAndWallBlockItem(floorBlock, wallBlock, new Item.Properties().m_41491_(itemGroup));
    }

    public static BlockItem createDoubleHighBlockItem(Block blockForInput, CreativeModeTab itemGroup) {
        return new DoubleHighBlockItem(blockForInput, new Item.Properties().m_41491_(itemGroup));
    }

    public static FuelItem createFuelItem(int burnTime, CreativeModeTab itemGroup) {
        return new FuelItem(burnTime, new Item.Properties().m_41491_(itemGroup));
    }

    public static BlockItem createSimpleBlockItem(Block blockForInput, @Nullable CreativeModeTab itemGroup) {
        return new BlockItem(blockForInput, new Item.Properties().m_41491_(itemGroup));
    }

    public static Item.Properties createSimpleItemProperty(int stackSize, CreativeModeTab itemGroup) {
        return new Item.Properties().m_41491_(itemGroup).m_41487_(stackSize);
    }

    public <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier) {
        return this.deferredRegister.register(name, supplier);
    }

    public RegistryObject<Item> createCompatItem(String modId, String name, Item.Properties properties, CreativeModeTab group) {
        return this.deferredRegister.register(name, () -> new Item(properties.m_41491_((CreativeModeTab)(ItemSubRegistryHelper.areModsLoaded(modId) ? group : null))));
    }

    public RegistryObject<Item> createCompatItem(String name, Item.Properties properties, CreativeModeTab group, String ... modIds) {
        return this.deferredRegister.register(name, () -> new Item(properties.m_41491_((CreativeModeTab)(ItemSubRegistryHelper.areModsLoaded(modIds) ? group : null))));
    }

    public RegistryObject<ForgeSpawnEggItem> createSpawnEggItem(String entityName, Supplier<EntityType<? extends Mob>> supplier, int primaryColor, int secondaryColor) {
        return this.deferredRegister.register(entityName + "_spawn_egg", () -> new ForgeSpawnEggItem(supplier, primaryColor, secondaryColor, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    }

    public Pair<RegistryObject<Item>, RegistryObject<Item>> createBoatAndChestBoatItem(String wood, RegistryObject<Block> block) {
        String type = this.parent.getModId() + ":" + wood;
        RegistryObject boat = this.deferredRegister.register(wood + "_boat", () -> new BlueprintBoatItem(false, type, ItemSubRegistryHelper.createSimpleItemProperty(1, CreativeModeTab.f_40752_)));
        RegistryObject chestBoat = this.deferredRegister.register(wood + "_chest_boat", () -> new BlueprintBoatItem(true, type, ItemSubRegistryHelper.createSimpleItemProperty(1, CreativeModeTab.f_40752_)));
        BoatTypeRegistry.registerBoat(type, (Supplier<Item>)boat, (Supplier<Item>)chestBoat, block);
        return Pair.of((Object)boat, (Object)chestBoat);
    }
}

