/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public final class BasicRegistry<T>
implements Codec<T> {
    private final Lifecycle lifecycle;
    private final BiMap<ResourceLocation, T> map = HashBiMap.create();

    public BasicRegistry(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public BasicRegistry() {
        this.lifecycle = Lifecycle.stable();
    }

    public void register(ResourceLocation name, T value) {
        this.map.put((Object)name, value);
    }

    @Nonnull
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Nullable
    public T getValue(ResourceLocation name) {
        return (T)this.map.get((Object)name);
    }

    @Nullable
    public ResourceLocation getKey(T value) {
        return (ResourceLocation)this.map.inverse().get(value);
    }

    @Nonnull
    public Set<ResourceLocation> keySet() {
        return this.map.keySet();
    }

    @Nonnull
    public Set<T> getValues() {
        return this.map.values();
    }

    @Nonnull
    public Set<Map.Entry<ResourceLocation, T>> getEntries() {
        return this.map.entrySet();
    }

    public boolean containsKey(ResourceLocation name) {
        return this.map.containsKey((Object)name);
    }

    public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
        return ResourceLocation.f_135803_.decode(ops, input).flatMap(encodedRegistryPair -> {
            ResourceLocation name = (ResourceLocation)encodedRegistryPair.getFirst();
            T value = this.getValue(name);
            return value == null ? DataResult.error((String)("Unknown registry key: " + name)) : DataResult.success((Object)Pair.of(value, (Object)encodedRegistryPair.getSecond()), (Lifecycle)this.lifecycle);
        });
    }

    public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
        ResourceLocation name = this.getKey(input);
        if (name == null) {
            return DataResult.error((String)("Unknown registry element: " + prefix));
        }
        return ops.mergeToPrimitive(prefix, ops.createString(name.toString())).setLifecycle(this.lifecycle);
    }
}

