/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.util.packets.weapons;

import java.util.function.Supplier;
import mod.azure.doom.item.weapons.SuperShotgun;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SSGLoadingPacket {
    public int slot;

    public SSGLoadingPacket(int slot) {
        this.slot = slot;
    }

    public SSGLoadingPacket(FriendlyByteBuf packetBuffer) {
        this.slot = packetBuffer.readInt();
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(this.slot);
    }

    public static void handle(SSGLoadingPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            PacketListener handler = context.getNetworkManager().m_129538_();
            if (handler instanceof ServerGamePacketListenerImpl) {
                ServerPlayer playerEntity = ((ServerGamePacketListenerImpl)handler).f_9743_;
                SuperShotgun.reload((Player)playerEntity, InteractionHand.MAIN_HAND);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

