/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.util.packets;

import java.util.function.Supplier;
import mod.azure.doom.client.gui.weapons.GunTableScreenHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class DoomCraftingPacket {
    private int index;

    public DoomCraftingPacket(FriendlyByteBuf packetBuffer) {
        this.index = packetBuffer.readInt();
    }

    public DoomCraftingPacket(int index) {
        this.index = index;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.index);
    }

    public void handle(Supplier<NetworkEvent.Context> sup) {
        NetworkEvent.Context ctx = sup.get();
        ctx.enqueueWork(() -> {
            NetworkEvent.Context context = (NetworkEvent.Context)sup.get();
            PacketListener handler = context.getNetworkManager().m_129538_();
            if (handler instanceof ServerGamePacketListenerImpl) {
                ServerPlayer playerEntity = ((ServerGamePacketListenerImpl)handler).f_9743_;
                AbstractContainerMenu container = playerEntity.f_36096_;
                if (container instanceof GunTableScreenHandler) {
                    GunTableScreenHandler gunTableScreenHandler = (GunTableScreenHandler)container;
                    gunTableScreenHandler.setRecipeIndex(this.index);
                    gunTableScreenHandler.switchTo(this.index);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

