/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.recipes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mod.azure.doom.recipes.GunTableRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.apache.commons.lang3.tuple.Pair;

public class GunRecipeSerializer
implements RecipeSerializer<GunTableRecipe> {
    private static List<Pair<Ingredient, Integer>> getIngredients(String pattern, Map<String, Pair<Ingredient, Integer>> keys, int width) {
        ArrayList<Pair<Ingredient, Integer>> pairList = new ArrayList<Pair<Ingredient, Integer>>();
        for (int i = 0; i < 5; ++i) {
            pairList.add(Pair.of((Object)Ingredient.f_43901_, (Object)0));
        }
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length(); ++i) {
            String key = pattern.substring(i, i + 1);
            Ingredient ingredient = (Ingredient)keys.get(key).getKey();
            if (ingredient == null) {
                throw new JsonSyntaxException("Pattern references symbol '" + key + "' but it's not defined in the key");
            }
            set.remove(key);
            pairList.set(i, (Pair<Ingredient, Integer>)Pair.of((Object)ingredient, (Object)((Integer)keys.get(key).getRight())));
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return pairList;
    }

    private static Map<String, Pair<Ingredient, Integer>> getComponents(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (key.length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 String only).");
            }
            if (" ".equals(key)) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(key, Pair.of((Object)Ingredient.m_43917_((JsonElement)jsonElement), (Object)GsonHelper.m_13824_((JsonObject)jsonElement.getAsJsonObject(), (String)"count", (int)1)));
        }
        map.put(" ", Pair.of((Object)Ingredient.f_43901_, (Object)0));
        return map;
    }

    public GunTableRecipe fromJson(ResourceLocation ResourceLocation2, JsonObject jsonObject) {
        Map<String, Pair<Ingredient, Integer>> map;
        String pattern = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"pattern");
        List<Pair<Ingredient, Integer>> pairList = GunRecipeSerializer.getIngredients(pattern, map = GunRecipeSerializer.getComponents(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"key")), pattern.length());
        if (pairList.isEmpty()) {
            throw new JsonParseException("No ingredients for gun table recipe");
        }
        if (pairList.size() > 5) {
            throw new JsonParseException("Too many ingredients for gun table recipe");
        }
        ItemStack itemStack = ShapedRecipe.m_151278_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result")).m_7968_();
        return new GunTableRecipe(ResourceLocation2, pairList.toArray(new Pair[0]), itemStack);
    }

    public void toNetwork(FriendlyByteBuf packetbuffer, GunTableRecipe gunTableRecipe) {
        for (int i = 0; i < 5; ++i) {
            Pair<Ingredient, Integer> pair = gunTableRecipe.ingredients[i];
            Ingredient ingredient = (Ingredient)pair.getLeft();
            int count = (Integer)pair.getRight();
            ingredient.m_43923_(packetbuffer);
            packetbuffer.writeInt(count);
        }
        packetbuffer.m_130055_(gunTableRecipe.output);
    }

    public GunTableRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf packetbuffer) {
        Pair[] pairs = new Pair[5];
        for (int j = 0; j < 5; ++j) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)packetbuffer);
            int count = packetbuffer.readInt();
            pairs[j] = Pair.of((Object)ingredient, (Object)count);
        }
        ItemStack output = packetbuffer.m_130267_();
        return new GunTableRecipe(resourceLocation, pairs, output);
    }
}

