/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.item.weapons;

import java.util.List;
import mod.azure.doom.entity.tileentity.TickingLightEntity;
import mod.azure.doom.item.weapons.Unmaykr;
import mod.azure.doom.util.registry.DoomBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.network.GeckoLibNetwork;
import software.bernie.geckolib3.network.ISyncable;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class DoomBaseItem
extends Item
implements IAnimatable,
ISyncable {
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public String controllerName = "controller";
    public static final int ANIM_OPEN = 0;
    public static final int ANIM_OPEN_FASTER = 2;
    public static final int ANIM_HOOK = 1;
    private BlockPos lightBlockPos = null;

    public <P extends ProjectileWeaponItem> PlayState predicate(AnimationEvent<P> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, this.controllerName, 1.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void onAnimationSync(int id, int state) {
        AnimationController controller;
        if (state == 0 && (controller = GeckoLibUtil.getControllerForID((AnimationFactory)this.factory, (Integer)id, (String)this.controllerName)).getAnimationState() == AnimationState.Stopped) {
            controller.markNeedsReload();
            controller.setAnimation(new AnimationBuilder().addAnimation("firing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        }
        if (state == 2 && (controller = GeckoLibUtil.getControllerForID((AnimationFactory)this.factory, (Integer)id, (String)this.controllerName)).getAnimationState() == AnimationState.Stopped) {
            controller.markNeedsReload();
            controller.setAnimationSpeed(2.0);
            controller.setAnimation(new AnimationBuilder().addAnimation("firing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        }
        if (state == 1 && (controller = GeckoLibUtil.getControllerForID((AnimationFactory)this.factory, (Integer)id, (String)this.controllerName)).getAnimationState() == AnimationState.Stopped) {
            controller.markNeedsReload();
            controller.setAnimation(new AnimationBuilder().addAnimation("hook", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        }
    }

    public DoomBaseItem(Item.Properties properties) {
        super(properties);
        if (!(this instanceof Unmaykr)) {
            GeckoLibNetwork.registerSyncable((ISyncable)this);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static void removeAmmo(Item ammo, Player playerEntity) {
        if (!playerEntity.m_7500_()) {
            block0: for (ItemStack item : playerEntity.m_150109_().f_35976_) {
                if (item.m_41720_() == ammo) {
                    item.m_41774_(1);
                    break;
                }
                for (ItemStack item1 : playerEntity.m_150109_().f_35974_) {
                    if (item1.m_41720_() != ammo) continue;
                    item1.m_41774_(1);
                    continue block0;
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public int m_8105_(ItemStack stack) {
        return 7200;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)("Ammo: " + (stack.m_41776_() - stack.m_41773_() - 1) + " / " + (stack.m_41776_() - 1))).m_130940_(ChatFormatting.ITALIC));
    }

    protected void spawnLightSource(Entity entity, boolean isInWaterBlock) {
        if (this.lightBlockPos == null) {
            this.lightBlockPos = this.findFreeSpace(entity.f_19853_, entity.m_20183_(), 2);
            if (this.lightBlockPos == null) {
                return;
            }
            entity.f_19853_.m_46597_(this.lightBlockPos, ((Block)DoomBlocks.TICKING_LIGHT_BLOCK.get()).m_49966_());
            BlockEntity blockEntity1 = entity.f_19853_.m_7702_(this.lightBlockPos);
            if (blockEntity1 instanceof TickingLightEntity) {
                ((TickingLightEntity)blockEntity1).refresh(isInWaterBlock ? 1 : 1);
            }
        } else if (this.checkDistance(this.lightBlockPos, entity.m_20183_(), 2)) {
            BlockEntity blockEntity = entity.f_19853_.m_7702_(this.lightBlockPos);
            if (blockEntity instanceof TickingLightEntity) {
                ((TickingLightEntity)blockEntity).refresh(isInWaterBlock ? 1 : 1);
                entity.f_19853_.m_46597_(this.lightBlockPos, ((Block)DoomBlocks.TICKING_LIGHT_BLOCK.get()).m_49966_());
            } else {
                BlockEntity blockEntity1 = entity.f_19853_.m_7702_(this.lightBlockPos);
                if (blockEntity1 instanceof TickingLightEntity) {
                    ((TickingLightEntity)blockEntity1).refresh(isInWaterBlock ? 1 : 1);
                }
                this.lightBlockPos = null;
            }
        } else {
            BlockEntity blockEntity1 = entity.f_19853_.m_7702_(this.lightBlockPos);
            if (blockEntity1 instanceof TickingLightEntity) {
                ((TickingLightEntity)blockEntity1).refresh(isInWaterBlock ? 1 : 1);
            }
            this.lightBlockPos = null;
        }
    }

    private boolean checkDistance(BlockPos blockPosA, BlockPos blockPosB, int distance) {
        return Math.abs(blockPosA.m_123341_() - blockPosB.m_123341_()) <= distance && Math.abs(blockPosA.m_123342_() - blockPosB.m_123342_()) <= distance && Math.abs(blockPosA.m_123343_() - blockPosB.m_123343_()) <= distance;
    }

    private BlockPos findFreeSpace(Level world, BlockPos blockPos, int maxDistance) {
        if (blockPos == null) {
            return null;
        }
        int[] offsets = new int[maxDistance * 2 + 1];
        offsets[0] = 0;
        for (int i = 2; i <= maxDistance * 2; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets) {
            for (int y : offsets) {
                for (int z : offsets) {
                    BlockPos offsetPos = blockPos.m_7918_(x, y, z);
                    BlockState state = world.m_8055_(offsetPos);
                    if (!state.m_60795_() && !state.m_60734_().equals(DoomBlocks.TICKING_LIGHT_BLOCK)) continue;
                    return offsetPos;
                }
            }
        }
        return null;
    }
}

