/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.item.weapons;

import java.util.List;
import java.util.function.Consumer;
import mod.azure.doom.DoomMod;
import mod.azure.doom.client.Keybindings;
import mod.azure.doom.client.render.weapons.DarkLordCrucibleRender;
import mod.azure.doom.entity.tierboss.ArchMakyrEntity;
import mod.azure.doom.entity.tierboss.GladiatorEntity;
import mod.azure.doom.entity.tierboss.IconofsinEntity;
import mod.azure.doom.entity.tierboss.MotherDemonEntity;
import mod.azure.doom.entity.tierboss.SpiderMastermind2016Entity;
import mod.azure.doom.entity.tierboss.SpiderMastermindEntity;
import mod.azure.doom.util.packets.DoomPacketHandler;
import mod.azure.doom.util.packets.weapons.DarkLordCrucibleLoadingPacket;
import mod.azure.doom.util.registry.DoomItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.network.GeckoLibNetwork;
import software.bernie.geckolib3.network.ISyncable;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class DarkLordCrucibleItem
extends SwordItem
implements IAnimatable,
ISyncable {
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public String controllerName = "controller";
    public static final int ANIM_OPEN = 0;

    public DarkLordCrucibleItem() {
        super(DoomMod.DOOM_HIGHTEIR, 1, -2.5f, new Item.Properties().m_41491_(DoomMod.DoomWeaponItemGroup).m_41487_(1).m_41503_(24));
        GeckoLibNetwork.registerSyncable((ISyncable)this);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new DarkLordCrucibleRender();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity miner) {
        if (miner instanceof Player) {
            Player playerentity = (Player)miner;
            if (stack.m_41773_() < stack.m_41776_() - 1 && playerentity.m_21205_().m_41720_() instanceof DarkLordCrucibleItem) {
                AABB aabb = new AABB(miner.m_20183_().m_7494_()).m_82377_(4.0, 1.0, 4.0);
                miner.m_20193_().m_45933_((Entity)miner, aabb).forEach(e -> this.doDamage((LivingEntity)playerentity, (Entity)e));
                stack.m_41622_(1, miner, p -> p.m_21190_(playerentity.m_7655_()));
            }
        }
        return stack.m_41773_() < stack.m_41776_() - 1;
    }

    private void doDamage(LivingEntity user, Entity target) {
        if (target instanceof LivingEntity) {
            target.f_19802_ = 0;
            target.m_6469_(DamageSource.m_19344_((Player)((Player)user)), !(target instanceof ArchMakyrEntity) || !(target instanceof GladiatorEntity) || !(target instanceof IconofsinEntity) || !(target instanceof MotherDemonEntity) || !(target instanceof SpiderMastermind2016Entity) || !(target instanceof SpiderMastermindEntity) ? 30.0f : 200.0f);
        }
    }

    public <P extends Item> PlayState predicate(AnimationEvent<P> event) {
        if (Minecraft.m_91087_().f_91074_.m_150109_().m_36056_().m_41720_() instanceof DarkLordCrucibleItem) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("opening", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE).addAnimation("open", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("closed", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, this.controllerName, 1.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void onAnimationSync(int id, int state) {
        AnimationController controller;
        if (state == 0 && (controller = GeckoLibUtil.getControllerForID((AnimationFactory)this.factory, (Integer)id, (String)this.controllerName)).getAnimationState() == AnimationState.Stopped) {
            controller.markNeedsReload();
            controller.setAnimation(new AnimationBuilder().addAnimation("using", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        }
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)("Ammo: " + (stack.m_41776_() - stack.m_41773_() - 1) + " / " + (stack.m_41776_() - 1))).m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Player Player2 = (Player)entityIn;
        if (worldIn.f_46443_ && Player2.m_21205_().m_41720_() instanceof DarkLordCrucibleItem) {
            while (Keybindings.RELOAD.m_90859_() && isSelected) {
                DoomPacketHandler.DARKLORDCRUCIBLE.sendToServer((Object)new DarkLordCrucibleLoadingPacket(itemSlot));
            }
        }
    }

    public static void reload(Player user, InteractionHand hand) {
        if (user.m_21120_(hand).m_41720_() instanceof DarkLordCrucibleItem) {
            while (!user.m_7500_() && user.m_21120_(hand).m_41773_() != 0 && user.m_150109_().m_18947_((Item)DoomItems.ARGENT_BLOCK.get()) > 0) {
                DarkLordCrucibleItem.removeAmmo((Item)DoomItems.ARGENT_BLOCK.get(), user);
                user.m_21120_(hand).m_41622_(-5, (LivingEntity)user, s -> user.m_21190_(hand));
                user.m_21120_(hand).m_41754_(3);
            }
        }
    }

    public static void removeAmmo(Item ammo, Player Player2) {
        if (!Player2.m_7500_()) {
            block0: for (ItemStack item : Player2.m_150109_().f_35976_) {
                if (item.m_41720_() == ammo) {
                    item.m_41774_(1);
                    break;
                }
                for (ItemStack item1 : Player2.m_150109_().f_35974_) {
                    if (item1.m_41720_() != ammo) continue;
                    item1.m_41774_(1);
                    continue block0;
                }
            }
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public int m_8105_(ItemStack stack) {
        return 7200;
    }
}

