/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.tileentity;

import java.util.List;
import java.util.Random;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.util.registry.DoomEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class TotemEntity
extends BlockEntity
implements IAnimatable {
    protected final Random random = new Random();
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public TotemEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DoomEntities.TOTEM.get(), pos, state);
    }

    private <E extends BlockEntity> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TotemEntity blockEntity) {
        if (blockEntity.f_58857_.m_46467_() % 80L == 0L) {
            blockEntity.applyEffects();
        }
        if (world != null && world.m_5776_()) {
            double d0 = (double)pos.m_123341_() + 1.0 * (blockEntity.random.nextDouble() - 0.25) * 2.0;
            double d1 = (double)pos.m_123342_() + 1.0 * (blockEntity.random.nextDouble() - 0.5) * 2.0;
            double d2 = (double)pos.m_123343_() + 1.0 * (blockEntity.random.nextDouble() - 0.25) * 2.0;
            for (int k = 0; k < 4; ++k) {
                world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d0, d1, d2, (blockEntity.random.nextDouble() - 0.5) * 2.0, -blockEntity.random.nextDouble(), (blockEntity.random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    public void m_7651_() {
        this.removeEffects();
        super.m_7651_();
    }

    private void applyEffects() {
        if (!this.f_58857_.f_46443_) {
            AABB axisalignedbb = new AABB(this.f_58858_).m_82400_(40.0).m_82363_(0.0, (double)this.f_58857_.m_151558_(), 0.0);
            List list = this.f_58857_.m_45976_(DemonEntity.class, axisalignedbb);
            for (DemonEntity entity : list) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1000, 1));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 1000, 1));
                entity.m_146915_(true);
            }
        }
    }

    private void removeEffects() {
        if (!this.f_58857_.f_46443_) {
            AABB axisalignedbb = new AABB(this.f_58858_).m_82400_(40.0).m_82363_(0.0, (double)this.f_58857_.m_151558_(), 0.0);
            List list = this.f_58857_.m_45976_(DemonEntity.class, axisalignedbb);
            for (DemonEntity entity : list) {
                entity.m_146915_(false);
                entity.m_21219_();
            }
        }
    }
}

