/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.tiersuperheavy;

import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.ai.goal.RangedStrafeAttackGoal;
import mod.azure.doom.entity.attack.AbstractRangedAttack;
import mod.azure.doom.entity.attack.AttackSound;
import mod.azure.doom.entity.projectiles.entity.BarenBlastEntity;
import mod.azure.doom.util.registry.DoomSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class FireBaronEntity
extends DemonEntity
implements IAnimatable,
IAnimationTickable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int flameTimer;

    public FireBaronEntity(EntityType<FireBaronEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking_fireborne", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death_fireborne", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (!event.isMoving() && this.f_19864_) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle_fireborne", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle_fireborne", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate1(AnimationEvent<E> event) {
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 1 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("melee_fireborne", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 2 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ranged_fireborne", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate);
        AnimationController controller1 = new AnimationController((IAnimatable)this, "controller1", 0.0f, this::predicate1);
        controller.registerSoundListener(this::soundListener);
        controller1.registerSoundListener(this::soundListener);
        data.addAnimationController(controller);
        data.addAnimationController(controller1);
    }

    private <ENTITY extends IAnimatable> void soundListener(SoundKeyframeEvent<ENTITY> event) {
        if (event.sound.matches("walk") && this.f_19853_.m_5776_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DoomSounds.PINKY_STEP.get(), SoundSource.HOSTILE, 0.25f, 1.0f, true);
        }
        if (event.sound.matches("attack") && this.f_19853_.m_5776_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DoomSounds.BARON_AMBIENT.get(), SoundSource.HOSTILE, 0.25f, 1.0f, true);
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8107_() {
        super.m_8107_();
        this.flameTimer = (this.flameTimer + 1) % 3;
    }

    public int getFlameTimer() {
        return this.flameTimer;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new RangedStrafeAttackGoal(this, new FireballAttack(this).setProjectileOriginOffset(0.8, 0.8, 0.8).setDamage(((Double)DoomConfig.SERVER.baron_ranged_damage.get()).floatValue()), 1.1, 2));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, ((Double)DoomConfig.SERVER.baron_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.0);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)DoomSounds.BARON_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DoomSounds.BARON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DoomSounds.BARON_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)DoomSounds.BARON_STEP.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public int m_5792_() {
        return 1;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    public class FireballAttack
    extends AbstractRangedAttack {
        public FireballAttack(DemonEntity parentEntity, double xOffSetModifier, double entityHeightFraction, double zOffSetModifier, float damage) {
            super(parentEntity, xOffSetModifier, entityHeightFraction, zOffSetModifier, damage);
        }

        public FireballAttack(DemonEntity parentEntity) {
            super(parentEntity);
        }

        @Override
        public AttackSound getDefaultAttackSound() {
            return new AttackSound((SoundEvent)DoomSounds.PLASMA_FIRING.get(), 0.7f, 1.0f);
        }

        @Override
        public Projectile getProjectile(Level world, double d2, double d3, double d4) {
            return new BarenBlastEntity(world, (LivingEntity)this.parentEntity, d2, d3, d4, this.damage);
        }
    }
}

