/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.tiersuperheavy;

import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.projectiles.entity.DoomFireEntity;
import mod.azure.doom.entity.projectiles.entity.RocketMobEntity;
import mod.azure.doom.util.registry.DoomSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class DoomHunterEntity
extends DemonEntity
implements IAnimatable,
IAnimationTickable {
    public int flameTimer;
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public static final EntityDataAccessor<Integer> DEATH_STATE = SynchedEntityData.m_135353_(DoomHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public DoomHunterEntity(EntityType<DoomHunterEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if ((this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("sled_death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && this.f_20917_ < 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 1 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rockets", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 2 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("flamethrower", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 3 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("chainsaw", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        event.getController().setAnimationSpeed(0.5);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate);
        controller.registerSoundListener(this::soundListener);
        data.addAnimationController(controller);
    }

    private <ENTITY extends IAnimatable> void soundListener(SoundKeyframeEvent<ENTITY> event) {
        if (event.sound.matches("phasechange") && this.f_19853_.f_46443_) {
            this.m_20193_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DoomSounds.DOOMHUNTER_PHASECHANGE.get(), SoundSource.HOSTILE, 0.25f, 1.0f, true);
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    public void spawnFlames(double x, double z, double maxY, double y, float yaw, int warmup) {
        BlockPos blockpos = new BlockPos(x, y, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)this.f_19853_, blockpos1, Direction.UP)) continue;
            if (!this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
        if (flag) {
            DoomFireEntity fang = new DoomFireEntity(this.f_19853_, x, (double)blockpos.m_123342_() + d0, z, yaw, 1, (LivingEntity)this, ((Double)DoomConfig.SERVER.doomhunter_ranged_damage.get()).floatValue() + ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1 ? ((Double)DoomConfig.SERVER.doomhunter_extra_phase_two_damage.get()).floatValue() : 0.0f));
            fang.m_20254_(this.f_19797_);
            fang.m_6842_(false);
            this.f_19853_.m_7967_((Entity)fang);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, ((Double)DoomConfig.SERVER.doomhunter_health.get()).doubleValue()).m_22268_(Attributes.f_22280_, 2.25).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22281_, ((Double)DoomConfig.SERVER.doomhunter_melee_damage.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.55).m_22268_(Attributes.f_22282_, 0.0);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 6.05f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)DoomSounds.DOOMHUNTER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DoomSounds.DOOMHUNTER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DoomSounds.DOOMHUNTER_DEATH.get();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public int m_5792_() {
        return 1;
    }

    public int getFlameTimer() {
        return this.flameTimer;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    public void m_8107_() {
        super.m_8107_();
        this.flameTimer = (this.flameTimer + 1) % 8;
        ++this.f_19797_;
        if (!this.f_19853_.f_46443_) {
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1000000, 1));
            } else if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
                this.m_21195_(MobEffects.f_19600_);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 10000000, 2));
            }
        }
    }

    public int m_21230_() {
        return (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1 ? 0 : (int)(this.m_21223_() / this.m_21233_() * 100.0f);
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 80 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
            this.m_21153_(this.m_21233_());
            this.setDeathState(1);
            this.f_20919_ = 0;
        }
        if (this.f_20919_ == 40 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public int getDeathState() {
        return (Integer)this.f_19804_.m_135370_(DEATH_STATE);
    }

    public void setDeathState(int state) {
        this.f_19804_.m_135381_(DEATH_STATE, (Object)state);
    }

    public void m_6667_(DamageSource source) {
        if (!this.f_19853_.f_46443_) {
            if (source == DamageSource.f_19317_) {
                this.setDeathState(1);
            }
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
                AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
                areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123813_);
                areaeffectcloudentity.m_19712_(3.0f);
                areaeffectcloudentity.m_19734_(55);
                areaeffectcloudentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.m_21335_((Entity)this.m_21188_());
                this.f_19853_.m_7605_((Entity)this, (byte)3);
            }
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
                super.m_6667_(source);
            }
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDeathState(compound.m_128451_("Phase"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Phase", this.getDeathState());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DEATH_STATE, (Object)0);
    }

    public boolean m_8023_() {
        return true;
    }

    public void m_6043_() {
    }

    public boolean m_6128_() {
        return true;
    }

    static class AttackGoal
    extends Goal {
        private final DoomHunterEntity parentEntity;
        protected int attackTimer = 0;

        public AttackGoal(DoomHunterEntity ghast) {
            this.parentEntity = ghast;
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null;
        }

        public void m_8056_() {
            super.m_8056_();
            this.parentEntity.m_21561_(true);
            this.parentEntity.setAttackingState(0);
        }

        public void m_8041_() {
            super.m_8041_();
            this.parentEntity.m_21561_(false);
            this.parentEntity.setAttackingState(0);
            this.attackTimer = -1;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.parentEntity.m_5448_();
            if (this.parentEntity.m_142582_((Entity)livingentity)) {
                Level world = this.parentEntity.f_19853_;
                ++this.attackTimer;
                Vec3 vector3d = this.parentEntity.m_20252_(1.0f);
                double d0 = Math.min(livingentity.m_20186_(), livingentity.m_20186_());
                double d1 = Math.max(livingentity.m_20186_(), livingentity.m_20186_()) + 1.0;
                double d2 = livingentity.m_20185_() - (this.parentEntity.m_20185_() + vector3d.f_82479_ * 2.0);
                double d3 = livingentity.m_20227_(0.5) - (0.5 + this.parentEntity.m_20227_(0.5));
                double d4 = livingentity.m_20189_() - (this.parentEntity.m_20189_() + vector3d.f_82481_ * 2.0);
                float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.parentEntity.m_20189_()), (double)(livingentity.m_20185_() - this.parentEntity.m_20185_()));
                RocketMobEntity fireballentity = new RocketMobEntity(world, (LivingEntity)this.parentEntity, d2, d3, d4, ((Double)DoomConfig.SERVER.doomhunter_ranged_damage.get()).floatValue() + ((Integer)this.parentEntity.f_19804_.m_135370_(DEATH_STATE) == 1 ? ((Double)DoomConfig.SERVER.doomhunter_extra_phase_two_damage.get()).floatValue() : 0.0f));
                this.parentEntity.m_21573_().m_5624_((Entity)livingentity, this.parentEntity.getDeathState() == 0 ? 0.75 : 1.0);
                if (this.attackTimer == 15) {
                    if ((double)this.parentEntity.m_20270_((Entity)livingentity) >= 3.0) {
                        if ((Integer)this.parentEntity.f_19804_.m_135370_(DEATH_STATE) == 1) {
                            for (int l = 0; l < 16; ++l) {
                                double d5 = 1.25 * (double)(l + 1);
                                int j = 1 * l;
                                this.parentEntity.spawnFlames(this.parentEntity.m_20185_() + (double)Mth.m_14089_((float)f) * d5, this.parentEntity.m_20189_() + (double)Mth.m_14031_((float)f) * d5, d0, d1, f, j);
                                this.parentEntity.setAttackingState(2);
                            }
                        }
                        if ((Integer)this.parentEntity.f_19804_.m_135370_(DEATH_STATE) == 0) {
                            fireballentity.m_6034_(this.parentEntity.m_20185_() + vector3d.f_82479_ * 2.0, this.parentEntity.m_20227_(0.5) + 0.5, fireballentity.m_20189_() + vector3d.f_82481_ * 2.0);
                            world.m_7967_((Entity)fireballentity);
                            this.parentEntity.setAttackingState(1);
                        }
                    } else {
                        this.parentEntity.setAttackingState(3);
                        this.parentEntity.m_7327_((Entity)livingentity);
                    }
                }
                if (this.attackTimer >= 35) {
                    this.parentEntity.setAttackingState(0);
                    this.attackTimer = -15;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
        }
    }
}

