/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.tiersuperheavy;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.projectiles.entity.DoomFireEntity;
import mod.azure.doom.util.registry.DoomSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ArchvileEntity
extends DemonEntity
implements IAnimatable,
IAnimationTickable {
    private int targetChangeTime;
    public int flameTimer;
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(ArchvileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public ArchvileEntity(EntityType<ArchvileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, ((Double)DoomConfig.SERVER.archvile_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.0);
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (!this.f_19853_.f_46443_) {
            float f2 = 200.0f;
            int k1 = Mth.m_14107_((double)(this.m_20185_() - (double)f2 - 1.0));
            int l1 = Mth.m_14107_((double)(this.m_20185_() + (double)f2 + 1.0));
            int i2 = Mth.m_14107_((double)(this.m_20186_() - (double)f2 - 1.0));
            int i1 = Mth.m_14107_((double)(this.m_20186_() + (double)f2 + 1.0));
            int j2 = Mth.m_14107_((double)(this.m_20189_() - (double)f2 - 1.0));
            int j1 = Mth.m_14107_((double)(this.m_20189_() + (double)f2 + 1.0));
            List list = this.f_19853_.m_45933_((Entity)this, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
            for (int k2 = 0; k2 < list.size(); ++k2) {
                Entity entity = (Entity)list.get(k2);
                if (!entity.m_6084_()) continue;
                entity.m_146915_(false);
            }
        }
        if (this.f_20919_ == 50) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (!event.isMoving() && this.f_19864_) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate1(AnimationEvent<E> event) {
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 1 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attacking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate);
        AnimationController controller1 = new AnimationController((IAnimatable)this, "controller1", 0.0f, this::predicate1);
        controller.registerSoundListener(this::soundListener);
        controller1.registerSoundListener(this::soundListener);
        data.addAnimationController(controller);
        data.addAnimationController(controller1);
    }

    private <ENTITY extends IAnimatable> void soundListener(SoundKeyframeEvent<ENTITY> event) {
        if (event.sound.matches("walk") && this.f_19853_.m_5776_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DoomSounds.PINKY_STEP.get(), SoundSource.HOSTILE, 0.25f, 1.0f, true);
        }
        if (event.sound.matches("attack") && this.f_19853_.m_5776_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DoomSounds.ARCHVILE_SCREAM.get(), SoundSource.HOSTILE, 0.25f, 1.0f, true);
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128451_("Variant"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
    }

    public int getVariant() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(VARIANT)), (int)1, (int)2);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getVariants() {
        return 2;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.f_19796_.m_188502_());
        return spawnDataIn;
    }

    public void m_8107_() {
        super.m_8107_();
        this.flameTimer = (this.flameTimer + 1) % 8;
    }

    public int getFlameTimer() {
        return this.flameTimer;
    }

    public boolean m_6162_() {
        return false;
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new FindPlayerGoal(this, arg_0 -> ((ArchvileEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    protected void m_8022_() {
        boolean flag = this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_());
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
        super.m_8022_();
    }

    private boolean teleportTowards(Entity p_70816_1_) {
        Vec3 vec3 = new Vec3(this.m_20185_() - p_70816_1_.m_20185_(), this.m_20227_(0.5) - p_70816_1_.m_20188_(), this.m_20189_() - p_70816_1_.m_20189_());
        vec3 = vec3.m_82541_();
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 10.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * 10.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 10.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean isLookingAtMe(Player player) {
        Vec3 vector3d = player.m_20252_(1.0f).m_82541_();
        Vec3 vector3d1 = new Vec3(this.m_20185_() - player.m_20185_(), this.m_20188_() - player.m_20188_(), this.m_20189_() - player.m_20189_());
        double d0 = vector3d1.m_82553_();
        double d1 = vector3d.m_82526_(vector3d1 = vector3d1.m_82541_());
        return d1 > 1.0 - 0.025 / d0 ? player.m_142582_((Entity)this) : false;
    }

    protected void m_8024_() {
        float f;
        if (this.f_19853_.m_46461_() && this.f_19797_ >= this.targetChangeTime + 600 && (f = this.m_213856_()) > 0.5f && this.f_19853_.m_45527_(this.m_20183_()) && this.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f) {
            this.m_6710_(null);
            this.teleportRandomly();
        }
        super.m_8024_();
    }

    protected boolean teleportRandomly() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 10.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 10);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 10.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    public void spawnFangs(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
        BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)this.f_19853_, blockpos1, Direction.UP)) continue;
            if (!this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_190876_5_) - 1);
        if (flag) {
            DoomFireEntity fang = new DoomFireEntity(this.f_19853_, p_190876_1_, (double)blockpos.m_123342_() + d0, p_190876_3_, p_190876_9_, 1, (LivingEntity)this, ((Double)DoomConfig.SERVER.archvile_ranged_damage.get()).floatValue());
            fang.m_20254_(this.f_19797_);
            fang.m_6842_(false);
            this.f_19853_.m_7967_((Entity)fang);
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DoomSounds.ARCHVILE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DoomSounds.ARCHVILE_DEATH.get();
    }

    public int m_5792_() {
        return 1;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    static class AttackGoal
    extends Goal {
        private final ArchvileEntity entity;
        public int cooldown;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        private float maxAttackDistance = 20.0f;
        private int strafeTicks = 20;

        public AttackGoal(ArchvileEntity ghast) {
            this.entity = ghast;
        }

        public boolean m_8036_() {
            return this.entity.m_5448_() != null;
        }

        public void m_8056_() {
            super.m_8056_();
            this.entity.m_21561_(true);
            this.cooldown = 0;
            this.entity.setAttackingState(0);
        }

        public void m_8041_() {
            super.m_8041_();
            this.entity.m_21561_(false);
            this.entity.setAttackingState(0);
            this.seeTime = 0;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.entity.m_5448_();
            ++this.cooldown;
            double distanceToTargetSq = this.entity.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            boolean inLineOfSight = this.entity.m_21574_().m_148306_((Entity)livingentity);
            if (inLineOfSight != this.seeTime > 0) {
                this.seeTime = 0;
            }
            this.seeTime = inLineOfSight ? ++this.seeTime : --this.seeTime;
            if (distanceToTargetSq <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.entity.m_21573_().m_5624_((Entity)livingentity, (double)0.95f);
                this.entity.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= this.strafeTicks) {
                if ((double)this.entity.m_217043_().m_188501_() < 0.3) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distanceToTargetSq > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (distanceToTargetSq < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            } else {
                this.entity.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            }
            if (this.cooldown == 20) {
                if (!this.entity.f_19853_.f_46443_) {
                    AABB aabb = new AABB(this.entity.m_20183_().m_7494_()).m_82377_(24.0, 24.0, 24.0);
                    this.entity.m_20193_().m_45933_((Entity)this.entity, aabb).forEach(e -> {
                        if (e instanceof Mob) {
                            ((Mob)e).m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1000, 1));
                        }
                    });
                    double d = Math.min(livingentity.m_20186_(), this.entity.m_20186_());
                    double e2 = Math.max(livingentity.m_20186_(), this.entity.m_20186_()) + 1.0;
                    float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.entity.m_20189_()), (double)(livingentity.m_20185_() - this.entity.m_20185_()));
                    if (this.entity.m_20280_((Entity)livingentity) < 9.0) {
                        float h;
                        int j;
                        for (j = 0; j < 15; ++j) {
                            h = f + (float)j * (float)Math.PI * 0.4f;
                            this.entity.spawnFangs(this.entity.m_20185_() + (double)Mth.m_14089_((float)h) * 1.5, this.entity.m_20189_() + (double)Mth.m_14031_((float)h) * 1.5, d, e2, h, 0);
                        }
                        for (j = 0; j < 18; ++j) {
                            h = f + (float)j * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                            this.entity.spawnFangs(this.entity.m_20185_() + (double)Mth.m_14089_((float)h) * 2.5, this.entity.m_20189_() + (double)Mth.m_14031_((float)h) * 2.5, d, e2, h, 3);
                        }
                    } else {
                        for (int j = 0; j < 26; ++j) {
                            double l1 = 1.25 * (double)(j + 1);
                            this.entity.spawnFangs(this.entity.m_20185_() + (double)Mth.m_14089_((float)f) * l1, this.entity.m_20189_() + (double)Mth.m_14031_((float)f) * l1, d, e2, f, 32);
                        }
                    }
                }
                if (!this.entity.f_19853_.f_46443_) {
                    this.entity.m_5496_((SoundEvent)DoomSounds.ARCHVILE_SCREAM.get(), 1.0f, 1.2f / (this.entity.f_19796_.m_188501_() * 0.2f + 0.9f));
                }
                this.entity.setAttackingState(1);
            }
            if (this.cooldown >= 40) {
                this.entity.setAttackingState(0);
                this.cooldown = -5;
            }
            this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final ArchvileEntity enderman;
        private Player player;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();

        public FindPlayerGoal(ArchvileEntity p_i241912_1_, @Nullable Predicate<LivingEntity> p_i241912_2_) {
            super((Mob)p_i241912_1_, Player.class, 10, false, false, p_i241912_2_);
            this.enderman = p_i241912_1_;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(p_32578_ -> p_i241912_1_.isLookingAtMe((Player)p_32578_));
        }

        public boolean m_8036_() {
            this.player = this.enderman.f_19853_.m_45946_(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.player != null;
        }

        public void m_8056_() {
            this.aggroTime = 5;
            this.teleportTime = 0;
        }

        public void m_8041_() {
            this.player = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.player != null) {
                if (!this.enderman.isLookingAtMe(this.player)) {
                    return false;
                }
                this.enderman.m_21391_((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.enderman, this.f_26050_) ? true : super.m_8045_();
        }

        public void m_8037_() {
            if (this.enderman.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.player;
                    this.player = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.enderman.m_20159_()) {
                    if (this.enderman.isLookingAtMe((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.enderman) < 16.0) {
                            this.enderman.teleportRandomly();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportTowards((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

