/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.tierfodder;

import java.util.EnumSet;
import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.ai.goal.RandomFlyConvergeOnTargetGoal;
import mod.azure.doom.entity.ai.goal.RangedAttackGoal;
import mod.azure.doom.entity.attack.FireballAttack;
import mod.azure.doom.util.registry.DoomSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class GargoyleEntity
extends DemonEntity
implements IAnimatable,
IAnimationTickable,
Enemy {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public GargoyleEntity(EntityType<GargoyleEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.f_21342_ = new GargoyleMoveControl(this);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!(!event.isMoving() || this.m_20096_() || this.f_19861_ || !this.f_20899_ || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("flying", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (!event.isMoving() && this.m_20096_() && this.f_19861_ && !this.f_20890_ && !((double)this.m_21223_() < 0.01) && !this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && this.m_20096_() && this.f_19861_ && !this.f_20890_ && !((double)this.m_21223_() < 0.01) && !this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            event.getController().setAnimationSpeed(1.05);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("flying", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate1(AnimationEvent<E> event) {
        if (!((Integer)this.f_19804_.m_135370_(STATE) <= 0 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attacking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 1.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller1", 1.0f, this::predicate1));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 50) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RangedAttackGoal(this, new FireballAttack(this, false).setProjectileOriginOffset(0.8, 0.8, 0.8).setDamage(((Double)DoomConfig.SERVER.gargoyle_ranged_damage.get()).floatValue()).setSound(SoundEvents.f_11705_, 1.0f, 1.4f + this.m_217043_().m_188501_() * 0.35f), 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyConvergeOnTargetGoal(this, 2.0, 15.0, 0.5));
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_7023_(Vec3 movementInput) {
        if (this.m_5912_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                BlockPos ground = new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
                float f = 0.91f;
                if (this.f_19861_) {
                    f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
                }
                float f1 = 0.16277137f / (f * f * f);
                f = 0.91f;
                if (this.f_19861_) {
                    f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
                }
                this.m_19920_(this.f_19861_ ? 0.1f * f1 : 0.02f, movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)f));
            }
            this.m_21043_((LivingEntity)this, false);
        } else {
            super.m_7023_(movementInput);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, ((Double)DoomConfig.SERVER.gargoyle_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22280_, 0.25).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.0);
    }

    public boolean m_6162_() {
        return false;
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DoomSounds.GARGOLYE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DoomSounds.GARGOLYE_DEATH.get();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public int m_5792_() {
        return 7;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    static class GargoyleMoveControl
    extends MoveControl {
        protected final DemonEntity entity;
        private int courseChangeCooldown;

        public GargoyleMoveControl(DemonEntity entity) {
            super((Mob)entity);
            this.entity = entity;
        }

        public void m_8126_() {
            if (this.entity.m_5912_()) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                    if (this.courseChangeCooldown-- <= 0) {
                        this.courseChangeCooldown += this.entity.m_217043_().m_188503_(5) + 2;
                        Vec3 vector3d = new Vec3(this.f_24975_ - this.entity.m_20185_(), this.f_24976_ - this.entity.m_20186_(), this.f_24977_ - this.entity.m_20189_());
                        double d0 = vector3d.m_82553_();
                        if (this.canReach(vector3d = vector3d.m_82541_(), Mth.m_14165_((double)d0))) {
                            this.entity.m_20256_(this.entity.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                        } else {
                            this.f_24981_ = MoveControl.Operation.WAIT;
                        }
                    }
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.entity.m_21564_(0.0f);
                }
            } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                double d0 = this.f_24975_ - this.entity.m_20185_();
                double d1 = this.f_24977_ - this.entity.m_20189_();
                double d2 = this.f_24976_ - this.entity.m_20186_();
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.entity.m_21564_(0.0f);
                    return;
                }
                float f9 = (float)(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
                this.entity.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f9, 90.0f));
                this.entity.m_7910_(0.25f);
                BlockPos blockpos = this.f_24974_.m_20183_();
                BlockState blockstate = this.f_24974_.f_19853_.m_8055_(blockpos);
                VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)this.f_24974_.f_19853_, blockpos);
                if (d2 > (double)this.f_24974_.getStepHeight() && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.f_24974_.m_20205_()) || !voxelshape.m_83281_() && this.f_24974_.m_20186_() < voxelshape.m_83297_(Direction.Axis.Y) + (double)blockpos.m_123342_() && !blockstate.m_204336_(BlockTags.f_13103_) && !blockstate.m_204336_(BlockTags.f_13039_)) {
                    this.f_24981_ = MoveControl.Operation.JUMPING;
                }
            } else if (this.f_24981_ == MoveControl.Operation.JUMPING) {
                this.f_24974_.m_7910_(0.25f);
                if (this.f_24974_.m_20096_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.entity.m_21564_(0.0f);
            }
        }

        private boolean canReach(Vec3 direction, int steps) {
            AABB axisalignedbb = this.f_24974_.m_20191_();
            for (int i = 1; i < steps; ++i) {
                if (this.f_24974_.f_19853_.m_45756_((Entity)this.entity, axisalignedbb = axisalignedbb.m_82383_(direction))) continue;
                return false;
            }
            return true;
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final GargoyleEntity parentEntity;

        public LookAroundGoal(GargoyleEntity ghast) {
            this.parentEntity = ghast;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.parentEntity.m_5448_() == null) {
                Vec3 vec3d = this.parentEntity.m_20184_();
                this.parentEntity.f_20883_ = this.parentEntity.f_19857_ = -((float)Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_)) * 57.295776f;
            } else {
                LivingEntity livingentity = this.parentEntity.m_5448_();
                if (livingentity.m_20280_((Entity)this.parentEntity) < 4096.0) {
                    double d1 = livingentity.m_20185_() - this.parentEntity.m_20185_();
                    double d2 = livingentity.m_20189_() - this.parentEntity.m_20189_();
                    this.parentEntity.f_20883_ = this.parentEntity.f_19857_ = -((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }
}

