/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.tierboss;

import java.util.Random;
import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.projectiles.CustomFireballEntity;
import mod.azure.doom.entity.projectiles.entity.DoomFireEntity;
import mod.azure.doom.entity.tierambient.TentacleEntity;
import mod.azure.doom.util.registry.DoomEntities;
import mod.azure.doom.util.registry.DoomSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MotherDemonEntity
extends DemonEntity
implements IAnimatable,
IAnimationTickable {
    public static final EntityDataAccessor<Integer> DEATH_STATE = SynchedEntityData.m_135353_(MotherDemonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true).m_7006_(true);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public MotherDemonEntity(EntityType<MotherDemonEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("moving", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if ((this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death_phaseone", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if ((this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("moving", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate1(AnimationEvent<E> event) {
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 1 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("shooting", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 2 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("fire", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller1", 0.0f, this::predicate1));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_6667_(DamageSource source) {
        if (!this.f_19853_.f_46443_) {
            if (source == DamageSource.f_19317_) {
                this.setDeathState(1);
            }
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
                AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
                areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123813_);
                areaeffectcloudentity.m_19712_(3.0f);
                areaeffectcloudentity.m_19734_(55);
                areaeffectcloudentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.m_21335_((Entity)this.m_21188_());
                this.f_19853_.m_7605_((Entity)this, (byte)3);
            }
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
                super.m_6667_(source);
            }
        }
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 80 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
            this.m_21153_(this.m_21233_());
            this.setDeathState(1);
            this.f_20919_ = 0;
        }
        if (this.f_20919_ == 40 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public int getDeathState() {
        return (Integer)this.f_19804_.m_135370_(DEATH_STATE);
    }

    public void setDeathState(int state) {
        this.f_19804_.m_135381_(DEATH_STATE, (Object)state);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_6138_() {
    }

    protected boolean m_7341_(Entity p_184228_1_) {
        return false;
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ServerBossEvent getBossInfo() {
        return this.bossInfo;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, AbstractVillager.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, IronGolem.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.applyEntityAI();
    }

    protected void applyEntityAI() {
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    protected void m_8022_() {
        boolean flag = this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_());
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
        super.m_8022_();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 9.05f;
    }

    public void spawnFlames(double x, double z, double maxY, double y, float yaw, int warmup) {
        BlockPos blockpos = new BlockPos(x, y, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)this.f_19853_, blockpos1, Direction.UP)) continue;
            if (!this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
        if (flag) {
            DoomFireEntity fang = new DoomFireEntity(this.f_19853_, x, (double)blockpos.m_123342_() + d0, z, yaw, 1, (LivingEntity)this, ((Double)DoomConfig.SERVER.motherdemon_ranged_damage.get()).floatValue() + ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1 ? ((Double)DoomConfig.SERVER.motherdemon_phaseone_damage_boos.get()).floatValue() : 0.0f));
            fang.m_20254_(this.f_19797_);
            fang.m_6842_(false);
            this.f_19853_.m_7967_((Entity)fang);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, ((Double)DoomConfig.SERVER.motherdemon_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, (double)0.9f).m_22268_(Attributes.f_22282_, 0.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)DoomSounds.MOTHER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DoomSounds.MOTHER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DoomSounds.MOTHER_DEATH.get();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public int m_5792_() {
        return 1;
    }

    public boolean m_7296_(int p_204209_1_) {
        return this.m_6084_() ? true : super.m_7296_(p_204209_1_);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, SpawnGroupData p_213386_4_, CompoundTag p_213386_5_) {
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public void m_6075_() {
        super.m_6075_();
        AABB aabb = new AABB(this.m_20183_().m_7494_()).m_82377_(64.0, 64.0, 64.0);
        this.m_20193_().m_45933_((Entity)this, aabb).forEach(e -> {
            if (e.isAddedToWorld() && e instanceof MotherDemonEntity && e.f_19797_ < 1) {
                e.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (e instanceof Player && !((Player)e).m_7500_() && !((Player)e).m_5833_()) {
                this.m_6710_((LivingEntity)e);
            }
        });
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.setDeathState(compound.m_128451_("Phase"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Phase", this.getDeathState());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DEATH_STATE, (Object)0);
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    public boolean m_8023_() {
        return true;
    }

    public void m_6043_() {
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    public boolean m_6128_() {
        return true;
    }

    static class AttackGoal
    extends Goal {
        private final MotherDemonEntity parentEntity;
        protected int attackTimer = 0;

        public AttackGoal(MotherDemonEntity ghast) {
            this.parentEntity = ghast;
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null;
        }

        public void m_8056_() {
            super.m_8056_();
            this.parentEntity.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.parentEntity.m_21561_(false);
            this.parentEntity.setAttackingState(0);
            this.attackTimer = -1;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.parentEntity.m_5448_();
            if (this.parentEntity.m_142582_((Entity)livingentity)) {
                Level world = this.parentEntity.f_19853_;
                ++this.attackTimer;
                Random rand = new Random();
                Vec3 vector3d = this.parentEntity.m_20252_(1.0f);
                double d0 = Math.min(livingentity.m_20186_(), livingentity.m_20186_());
                double d1 = Math.max(livingentity.m_20186_(), livingentity.m_20186_()) + 1.0;
                double d2 = livingentity.m_20185_() - (this.parentEntity.m_20185_() + vector3d.f_82479_ * 2.0);
                double d3 = livingentity.m_20227_(0.5) - (0.5 + this.parentEntity.m_20227_(0.5));
                double d4 = livingentity.m_20189_() - (this.parentEntity.m_20189_() + vector3d.f_82481_ * 2.0);
                float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.parentEntity.m_20189_()), (double)(livingentity.m_20185_() - this.parentEntity.m_20185_()));
                CustomFireballEntity fireballentity = new CustomFireballEntity(world, (LivingEntity)this.parentEntity, d2, d3, d4, ((Double)DoomConfig.SERVER.motherdemon_ranged_damage.get()).floatValue() + ((Integer)this.parentEntity.f_19804_.m_135370_(DEATH_STATE) == 1 ? ((Double)DoomConfig.SERVER.motherdemon_phaseone_damage_boos.get()).floatValue() : 0.0f));
                CustomFireballEntity fireballentity1 = new CustomFireballEntity(world, (LivingEntity)this.parentEntity, d2, d3, d4, ((Double)DoomConfig.SERVER.motherdemon_ranged_damage.get()).floatValue() + ((Integer)this.parentEntity.f_19804_.m_135370_(DEATH_STATE) == 1 ? ((Double)DoomConfig.SERVER.motherdemon_phaseone_damage_boos.get()).floatValue() : 0.0f));
                CustomFireballEntity fireballentity2 = new CustomFireballEntity(world, (LivingEntity)this.parentEntity, d2, d3, d4, ((Double)DoomConfig.SERVER.motherdemon_ranged_damage.get()).floatValue() + ((Integer)this.parentEntity.f_19804_.m_135370_(DEATH_STATE) == 1 ? ((Double)DoomConfig.SERVER.motherdemon_phaseone_damage_boos.get()).floatValue() : 0.0f));
                this.parentEntity.m_21573_().m_5624_((Entity)livingentity, 1.5);
                if (this.attackTimer == 15) {
                    if ((double)this.parentEntity.m_21223_() <= (double)this.parentEntity.m_21233_() * 0.5) {
                        for (int l = 0; l < 32; ++l) {
                            float f1 = f + (float)l * (float)Math.PI * 0.4f;
                            for (int y = 0; y < 5; ++y) {
                                this.parentEntity.spawnFlames(this.parentEntity.m_20185_() + (double)Mth.m_14089_((float)f1) * rand.nextDouble() * 11.5, this.parentEntity.m_20189_() + (double)Mth.m_14031_((float)f1) * rand.nextDouble() * 11.5, d0, d1, f1, 0);
                            }
                            this.parentEntity.f_19853_.m_7785_(this.parentEntity.m_20185_(), this.parentEntity.m_20186_(), this.parentEntity.m_20189_(), (SoundEvent)DoomSounds.MOTHER_ATTACK.get(), SoundSource.HOSTILE, 1.0f, 1.0f, true);
                            this.parentEntity.setAttackingState(2);
                        }
                        livingentity.m_20256_(livingentity.m_20184_().m_82542_((double)0.4f, (double)1.4f, (double)0.4f));
                        TentacleEntity lost_soul = (TentacleEntity)((EntityType)DoomEntities.TENTACLE.get()).m_20615_(world);
                        lost_soul.m_7678_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 0.0f, 0.0f);
                        world.m_7967_((Entity)lost_soul);
                    } else {
                        fireballentity.m_6034_(this.parentEntity.m_20185_() + vector3d.f_82479_ * 1.0, this.parentEntity.m_20227_(0.5) + 0.5, fireballentity.m_20189_() + vector3d.f_82481_ * 1.0);
                        world.m_7967_((Entity)fireballentity);
                        fireballentity1.m_6034_(this.parentEntity.m_20185_() + 3.0 + vector3d.f_82479_ * 1.0, this.parentEntity.m_20227_(0.5) + 0.5, fireballentity.m_20189_() + vector3d.f_82481_ * 1.0);
                        world.m_7967_((Entity)fireballentity1);
                        fireballentity2.m_6034_(this.parentEntity.m_20185_() - 3.0 + vector3d.f_82479_ * 1.0, this.parentEntity.m_20227_(0.5) + 0.5, fireballentity.m_20189_() + vector3d.f_82481_ * 1.0);
                        world.m_7967_((Entity)fireballentity2);
                        this.parentEntity.f_19853_.m_7785_(this.parentEntity.m_20185_(), this.parentEntity.m_20186_(), this.parentEntity.m_20189_(), (SoundEvent)DoomSounds.MOTHER_ATTACK.get(), SoundSource.HOSTILE, 1.0f, 1.0f, true);
                        TentacleEntity lost_soul = (TentacleEntity)((EntityType)DoomEntities.TENTACLE.get()).m_20615_(world);
                        lost_soul.m_7678_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 0.0f, 0.0f);
                        world.m_7967_((Entity)lost_soul);
                        this.parentEntity.setAttackingState(1);
                    }
                }
                if (this.attackTimer >= 30) {
                    this.parentEntity.setAttackingState(0);
                    this.attackTimer = -5;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
        }
    }
}

