/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.tierboss;

import java.util.List;
import java.util.Random;
import java.util.SplittableRandom;
import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.ai.goal.IconAttackGoal;
import mod.azure.doom.entity.attack.FireballAttack;
import mod.azure.doom.entity.projectiles.entity.DoomFireEntity;
import mod.azure.doom.util.registry.DoomSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class IconofsinEntity
extends DemonEntity
implements IAnimatable,
IAnimationTickable {
    public static final EntityDataAccessor<Integer> DEATH_STATE = SynchedEntityData.m_135353_(IconofsinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true).m_7006_(true);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public IconofsinEntity(EntityType<IconofsinEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving() && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if ((this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death_phaseone", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if ((this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking_nohelmet", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle_nohelmet", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!event.isMoving() && this.f_19864_ && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle_nohelmet", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!event.isMoving() && this.f_19864_) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate1(AnimationEvent<E> event) {
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 1 || (Integer)this.f_19804_.m_135370_(DEATH_STATE) != 0 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("summoned", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 2 || (Integer)this.f_19804_.m_135370_(DEATH_STATE) != 1 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("summoned_nohelmet", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 3 || (Integer)this.f_19804_.m_135370_(DEATH_STATE) != 0 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("slam", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 4 || (Integer)this.f_19804_.m_135370_(DEATH_STATE) != 1 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("slam_nohelmet", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 5 || (Integer)this.f_19804_.m_135370_(DEATH_STATE) != 0 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("stomp", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 6 || (Integer)this.f_19804_.m_135370_(DEATH_STATE) != 1 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("stomp_nohelmet", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller1", 0.0f, this::predicate1));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_6667_(DamageSource source) {
        if (!this.f_19853_.f_46443_) {
            if (source == DamageSource.f_19317_) {
                this.setDeathState(1);
            }
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
                AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
                areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123813_);
                areaeffectcloudentity.m_19712_(3.0f);
                areaeffectcloudentity.m_19734_(55);
                areaeffectcloudentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.m_21335_((Entity)this.m_21188_());
                this.f_19853_.m_7605_((Entity)this, (byte)3);
            }
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
                super.m_6667_(source);
            }
        }
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 80 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
            this.m_21153_(this.m_21233_());
            this.setDeathState(1);
            this.f_20919_ = 0;
        }
        if (this.f_20919_ == 40 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public int getDeathState() {
        return (Integer)this.f_19804_.m_135370_(DEATH_STATE);
    }

    public void setDeathState(int state) {
        this.f_19804_.m_135381_(DEATH_STATE, (Object)state);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_6138_() {
    }

    protected boolean m_7341_(Entity p_184228_1_) {
        return false;
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ServerBossEvent getBossInfo() {
        return this.bossInfo;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new IconAttackGoal(this, new FireballAttack(this, true).setProjectileOriginOffset(0.8, 0.8, 0.8).setDamage(((Double)DoomConfig.SERVER.icon_melee_damage.get()).floatValue() + ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1 ? ((Double)DoomConfig.SERVER.icon_phaseone_damage_boos.get()).floatValue() : 0.0f)).setSound(SoundEvents.f_11874_, 1.0f, 1.4f + this.m_217043_().m_188501_() * 0.35f), 1.1));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public void spawnWave(int WaveAmount, LivingEntity entity) {
        Random rand = new Random();
        List waveEntries = (List)DoomConfig.SERVER.icon_wave_entries.get();
        SplittableRandom random = new SplittableRandom();
        for (int k = 1; k < WaveAmount; ++k) {
            int r = random.nextInt(-3, 3);
            for (int i = 0; i < 1; ++i) {
                int randomIndex = rand.nextInt(waveEntries.size());
                ResourceLocation randomElement1 = new ResourceLocation((String)waveEntries.get(randomIndex));
                EntityType randomElement = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(randomElement1);
                Entity waveentity = randomElement.m_20615_(this.f_19853_);
                waveentity.m_6034_(entity.m_20185_() + (double)r, entity.m_20186_() + 0.5, entity.m_20189_() + (double)r);
                this.f_19853_.m_7967_(waveentity);
            }
        }
    }

    public void doDamage() {
        AABB aabb = new AABB(this.m_20183_().m_7494_()).m_82377_(64.0, 64.0, 64.0);
        this.m_20193_().m_45933_((Entity)this, aabb).forEach(e -> {
            if (e instanceof LivingEntity) {
                e.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)this.m_5448_()), ((Double)DoomConfig.SERVER.icon_melee_damage.get()).floatValue() + ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1 ? ((Double)DoomConfig.SERVER.motherdemon_phaseone_damage_boos.get()).floatValue() : 0.0f));
            }
        });
    }

    public void spawnFlames(double x, double z, double maxY, double y, float yaw, int warmup) {
        BlockPos blockpos = new BlockPos(x, y, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)this.f_19853_, blockpos1, Direction.UP)) continue;
            if (!this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
        if (flag) {
            DoomFireEntity fang = new DoomFireEntity(this.f_19853_, x, (double)blockpos.m_123342_() + d0, z, yaw, 1, (LivingEntity)this, ((Double)DoomConfig.SERVER.icon_melee_damage.get()).floatValue() + ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1 ? ((Double)DoomConfig.SERVER.motherdemon_phaseone_damage_boos.get()).floatValue() : 0.0f));
            fang.m_20254_(this.f_19797_);
            fang.m_6842_(false);
            this.f_19853_.m_7967_((Entity)fang);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, ((Double)DoomConfig.SERVER.icon_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.0);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 18.7f;
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)DoomSounds.ICON_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DoomSounds.ICON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DoomSounds.ICON_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12383_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public int m_5792_() {
        return 1;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.setDeathState(compound.m_128451_("Phase"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Phase", this.getDeathState());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DEATH_STATE, (Object)0);
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public int m_21230_() {
        return (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1 ? 0 : (int)(this.m_21223_() / this.m_21233_() * 100.0f);
    }

    public void m_8107_() {
        super.m_8107_();
        ++this.f_19797_;
        if (!this.f_19853_.f_46443_) {
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1000000, 1));
            } else if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
                this.m_21195_(MobEffects.f_19600_);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 10000000, 2));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 10000000, 1));
            }
            if (!this.f_19853_.m_6042_().f_63863_()) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 10000000, 3));
                if (this.f_19797_ % 2400 == 0) {
                    this.m_5634_(40.0f);
                }
            }
        }
    }

    public void m_6075_() {
        super.m_6075_();
        AABB aabb = new AABB(this.m_20183_().m_7494_()).m_82377_(64.0, 64.0, 64.0);
        this.m_20193_().m_45933_((Entity)this, aabb).forEach(e -> {
            if (e.isAddedToWorld() && e instanceof IconofsinEntity && e.f_19797_ < 1) {
                e.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (e instanceof Player && !((Player)e).m_7500_() && !((Player)e).m_5833_()) {
                this.m_6710_((LivingEntity)e);
            }
        });
    }

    public boolean m_7327_(Entity target) {
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        boolean bl = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), ((Double)DoomConfig.SERVER.icon_melee_damage.get()).floatValue() + ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1 ? ((Double)DoomConfig.SERVER.icon_phaseone_damage_boos.get()).floatValue() : 0.0f));
        if (bl) {
            this.f_19853_.m_46518_((Entity)this, target.m_20185_(), target.m_20186_(), target.m_20189_(), 3.0f, false, Explosion.BlockInteraction.BREAK);
            this.m_19970_((LivingEntity)this, target);
            target.f_19802_ = 0;
        }
        return bl;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return source == DamageSource.f_19310_ || source == DamageSource.f_19307_ || source == DamageSource.f_19305_ ? false : super.m_6469_(source, amount);
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    public boolean m_8023_() {
        return true;
    }

    public void m_6043_() {
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }
}

