/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.tierboss;

import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.ai.goal.RangedStrafeGladiatorAttackGoal;
import mod.azure.doom.entity.attack.AbstractDoubleRangedAttack;
import mod.azure.doom.entity.attack.AttackSound;
import mod.azure.doom.entity.projectiles.CustomFireballEntity;
import mod.azure.doom.entity.projectiles.entity.GladiatorMaceEntity;
import mod.azure.doom.util.registry.DoomSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class GladiatorEntity
extends DemonEntity
implements IAnimatable,
IAnimationTickable {
    public static final EntityDataAccessor<Integer> DEATH_STATE = SynchedEntityData.m_135353_(GladiatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> TEXTURE = SynchedEntityData.m_135353_(GladiatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(false).m_7006_(false);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public GladiatorEntity(EntityType<? extends DemonEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0 && event.isMoving() && (Integer)this.f_19804_.m_135370_(STATE) < 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking_phaseone", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            event.getController().setAnimationSpeed(1.5);
            return PlayState.CONTINUE;
        }
        if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0 && (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death_phaseone", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(DEATH_STATE) != 0 || (Integer)this.f_19804_.m_135370_(STATE) != 1 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("shield_plant", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1 && event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking_phasetwo", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            event.getController().setAnimationSpeed(1.5);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1 && (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death_phasetwo", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (!event.isMoving() && this.f_19864_) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0 ? "idle_phaseone" : "idle_phasetwo", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0 ? "idle_phaseone" : "idle_phasetwo", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate1(AnimationEvent<E> event) {
        if (!((Integer)this.f_19804_.m_135370_(DEATH_STATE) != 0 || (Integer)this.f_19804_.m_135370_(STATE) != 2 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("melee_phaseone", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(DEATH_STATE) != 0 || (Integer)this.f_19804_.m_135370_(STATE) != 3 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("melee_phaseone2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(DEATH_STATE) != 0 || (Integer)this.f_19804_.m_135370_(STATE) != 4 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("melee_phaseone3", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(DEATH_STATE) != 1 || (Integer)this.f_19804_.m_135370_(STATE) != 2 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("melee_phasetwo", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(DEATH_STATE) != 1 || (Integer)this.f_19804_.m_135370_(STATE) != 3 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("melee_phasetwo2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!((Integer)this.f_19804_.m_135370_(DEATH_STATE) != 1 || (Integer)this.f_19804_.m_135370_(STATE) != 4 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("melee_phasetwo2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller1", 0.0f, this::predicate1));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    public void m_6667_(DamageSource source) {
        if (!this.f_19853_.f_46443_) {
            if (source == DamageSource.f_19317_) {
                this.setDeathState(1);
            }
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
                AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
                areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123813_);
                areaeffectcloudentity.m_19712_(3.0f);
                areaeffectcloudentity.m_19734_(55);
                areaeffectcloudentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.m_21335_((Entity)this.m_21188_());
                this.f_19853_.m_7605_((Entity)this, (byte)3);
            }
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
                super.m_6667_(source);
            }
        }
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 80 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
            this.m_21153_(this.m_21233_());
            this.setDeathState(1);
            this.f_20919_ = 0;
        }
        if (this.f_20919_ == 40 && (Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public int getDeathState() {
        return (Integer)this.f_19804_.m_135370_(DEATH_STATE);
    }

    public void setDeathState(int state) {
        this.f_19804_.m_135381_(DEATH_STATE, (Object)state);
    }

    public int getTextureState() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE);
    }

    public void setTextureState(int state) {
        this.f_19804_.m_135381_(TEXTURE, (Object)state);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.setTextureState(compound.m_128451_("Texture"));
        this.setDeathState(compound.m_128451_("Phase"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Phase", this.getDeathState());
        tag.m_128405_("Texture", this.getDeathState());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DEATH_STATE, (Object)0);
        this.f_19804_.m_135372_(TEXTURE, (Object)0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 0) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1000000, 0, false, false));
            } else {
                this.m_21195_(MobEffects.f_19606_);
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new RangedStrafeGladiatorAttackGoal(this, new FireballAttack(this).setProjectileOriginOffset(0.8, 0.8, 0.8).setDamage(((Double)DoomConfig.SERVER.gladiator_ranged_damage.get()).floatValue() + ((Integer)this.f_19804_.m_135370_(DEATH_STATE) == 1 ? ((Double)DoomConfig.SERVER.gladiator_phaseone_damage_boost.get()).floatValue() : 0.0f)).setSound(SoundEvents.f_11874_, 1.0f, 1.4f + this.m_217043_().m_188501_() * 0.35f)));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_7327_(Entity target) {
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        boolean bl = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), ((Double)DoomConfig.SERVER.gladiator_melee_damage.get()).floatValue());
        if (bl) {
            target.m_20256_(target.m_20184_().m_82542_((double)1.4f, (double)1.4f, (double)1.4f));
            this.m_19970_((LivingEntity)this, target);
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20186_() + 5.0, this.m_20189_(), 3.0f, false, Explosion.BlockInteraction.BREAK);
            target.f_19802_ = 0;
        }
        return true;
    }

    public boolean doHurtTarget1(Entity target) {
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        boolean bl = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), ((Double)DoomConfig.SERVER.gladiator_melee_damage.get()).floatValue());
        if (bl) {
            this.m_19970_((LivingEntity)this, target);
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20186_() + 5.0, this.m_20189_(), 3.0f, false, Explosion.BlockInteraction.BREAK);
            target.f_19802_ = 0;
        }
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, ((Double)DoomConfig.SERVER.gladiator_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DoomConfig.SERVER.gladiator_melee_damage.get()).doubleValue()).m_22268_(Attributes.f_22278_, (double)0.9f).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)DoomSounds.BARON_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DoomSounds.BARON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DoomSounds.BARON_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)DoomSounds.BARON_STEP.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public ServerBossEvent getBossInfo() {
        return this.bossInfo;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6075_() {
        super.m_6075_();
        AABB aabb = new AABB(this.m_20183_().m_7494_()).m_82377_(64.0, 64.0, 64.0);
        this.m_20193_().m_45933_((Entity)this, aabb).forEach(e -> {
            if (e.isAddedToWorld() && e instanceof GladiatorEntity && e.f_19797_ < 1) {
                e.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (e instanceof Player && !((Player)e).m_7500_() && !((Player)e).m_5833_()) {
                this.m_6710_((LivingEntity)e);
            }
        });
    }

    public boolean m_8023_() {
        return true;
    }

    public void m_6043_() {
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return this.getAttckingState() == 1 || this.getAttckingState() == 4 ? false : super.m_6469_(source, amount);
    }

    public class FireballAttack
    extends AbstractDoubleRangedAttack {
        public FireballAttack(DemonEntity parentEntity, double xOffSetModifier, double entityHeightFraction, double zOffSetModifier, float damage) {
            super(parentEntity, xOffSetModifier, entityHeightFraction, zOffSetModifier, damage);
        }

        public FireballAttack(DemonEntity parentEntity) {
            super(parentEntity);
        }

        @Override
        public AttackSound getDefaultAttackSound() {
            return new AttackSound((SoundEvent)DoomSounds.BALLISTA_FIRING.get(), 1.0f, 1.0f);
        }

        @Override
        public Projectile getProjectile(Level world, double d2, double d3, double d4) {
            return new CustomFireballEntity(world, (LivingEntity)this.parentEntity, d2, d3, d4, this.damage);
        }

        @Override
        public Projectile getProjectile2(Level world, double d2, double d3, double d4) {
            return new GladiatorMaceEntity(world, (LivingEntity)this.parentEntity, d2, d3, d4);
        }
    }
}

