/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.tierambient;

import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.projectiles.CustomSmallFireballEntity;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class TurretEntity
extends DemonEntity
implements IAnimatable,
IAnimationTickable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public TurretEntity(EntityType<TurretEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22276_, ((Double)DoomConfig.SERVER.turret_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22282_, 0.0);
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 30) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 1 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attacking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, AbstractVillager.class, 8.0f));
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public int m_5792_() {
        return 1;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    static class AttackGoal
    extends Goal {
        private final TurretEntity parentEntity;
        protected int attackTimer = 0;

        public AttackGoal(TurretEntity ghast) {
            this.parentEntity = ghast;
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null;
        }

        public void m_8056_() {
            super.m_8056_();
            this.parentEntity.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.parentEntity.m_21561_(false);
            this.parentEntity.setAttackingState(0);
            this.attackTimer = -1;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.parentEntity.m_5448_();
            if (this.parentEntity.m_142582_((Entity)livingentity)) {
                Level world = this.parentEntity.f_19853_;
                ++this.attackTimer;
                Vec3 vector3d = this.parentEntity.m_20252_(1.0f);
                double d2 = livingentity.m_20185_() - (this.parentEntity.m_20185_() + vector3d.f_82479_ * 2.0);
                double d3 = livingentity.m_20227_(0.5) - (0.5 + this.parentEntity.m_20227_(0.5));
                double d4 = livingentity.m_20189_() - (this.parentEntity.m_20189_() + vector3d.f_82481_ * 2.0);
                CustomSmallFireballEntity fireballentity = new CustomSmallFireballEntity(world, (LivingEntity)this.parentEntity, d2, d3, d4, ((Double)DoomConfig.SERVER.turret_ranged_damage.get()).floatValue());
                if (this.attackTimer == 10) {
                    this.parentEntity.setAttackingState(1);
                }
                if (this.attackTimer == 20) {
                    fireballentity.m_6034_(this.parentEntity.m_20185_() + vector3d.f_82479_, this.parentEntity.m_20227_(0.5) + 0.5, fireballentity.m_20189_() + vector3d.f_82481_);
                    world.m_7967_((Entity)fireballentity);
                }
                if (this.attackTimer >= 30) {
                    this.parentEntity.setAttackingState(0);
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
        }
    }
}

