/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.tierambient;

import java.util.SplittableRandom;
import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.ai.goal.IgniteDemonGoal;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class CueBallEntity
extends DemonEntity
implements IAnimatable,
IAnimationTickable {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(CueBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FUSE_SPEED = SynchedEntityData.m_135353_(CueBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHARGED = SynchedEntityData.m_135353_(CueBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IGNITED = SynchedEntityData.m_135353_(CueBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int flameTimer;
    private int lastFuseTime;
    private int currentFuseTime;
    private int fuseTime = 30;
    private int explosionRadius = 4;

    public CueBallEntity(EntityType<CueBallEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22276_, ((Double)DoomConfig.SERVER.cueball_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22282_, 0.0);
    }

    public void m_147240_(double strength, double x, double z) {
        super.m_147240_(3.0, x, z);
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 30) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
            if (!this.f_19853_.f_46443_ && this.getVariant() == 1) {
                this.explode();
            }
            if (!this.f_19853_.f_46443_ && this.getVariant() == 3) {
                AABB aabb = new AABB(this.m_20183_().m_7494_()).m_82377_(24.0, 24.0, 24.0);
                this.m_9236_().m_45933_((Entity)this, aabb).forEach(e -> {
                    if (e.m_6084_() && e instanceof DemonEntity) {
                        ((LivingEntity)e).m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1000, 1));
                    }
                });
            }
        }
    }

    protected void explode() {
        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 1.0f, Explosion.BlockInteraction.NONE);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        if (!event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        if (this.getVariant() != 3) {
            this.f_21345_.m_25352_(2, (Goal)new IgniteDemonGoal(this));
        }
        if (this.getVariant() != 3) {
            this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        }
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, AbstractVillager.class, 8.0f));
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public int m_5792_() {
        return 1;
    }

    public void m_8107_() {
        int i;
        super.m_8107_();
        this.flameTimer = (this.flameTimer + 1) % 2;
        if (this.f_19853_.f_46443_ && this.getVariant() == 3) {
            for (i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        if (this.m_6084_() && this.getVariant() != 3) {
            this.lastFuseTime = this.currentFuseTime;
            if (this.isIgnited()) {
                this.setFuseSpeed(1);
            }
            if ((i = this.getFuseSpeed()) > 0 && this.currentFuseTime == 0) {
                this.m_146850_(GameEvent.f_157776_);
            }
            this.currentFuseTime += i;
            if (this.currentFuseTime < 0) {
                this.currentFuseTime = 0;
            }
            if (this.currentFuseTime >= this.fuseTime) {
                this.currentFuseTime = this.fuseTime;
                if (!((double)this.m_21223_() < 0.01) && !this.m_21224_()) {
                    this.explode();
                }
                this.m_6074_();
            }
        }
    }

    public int getFlameTimer() {
        return this.flameTimer;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FUSE_SPEED, (Object)-1);
        this.f_19804_.m_135372_(CHARGED, (Object)false);
        this.f_19804_.m_135372_(IGNITED, (Object)false);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128451_("Variant"));
        if (((Boolean)this.f_19804_.m_135370_(CHARGED)).booleanValue()) {
            tag.m_128379_("powered", true);
        }
        tag.m_128376_("Fuse", (short)this.fuseTime);
        tag.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        tag.m_128379_("ignited", this.isIgnited());
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        this.f_19804_.m_135381_(CHARGED, (Object)tag.m_128471_("powered"));
        if (tag.m_128425_("Fuse", 99)) {
            this.fuseTime = tag.m_128448_("Fuse");
        }
        if (tag.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = tag.m_128445_("ExplosionRadius");
        }
        if (tag.m_128471_("ignited")) {
            this.ignite();
        }
    }

    public int getVariant() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(VARIANT)), (int)1, (int)3);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getVariants() {
        return 3;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        SplittableRandom random = new SplittableRandom();
        int var = random.nextInt(0, 4);
        this.setVariant(var);
        return spawnDataIn;
    }

    public Component m_7770_() {
        return this.getVariant() == 3 ? Component.m_237115_((String)"entity.doom.screecher") : (this.getVariant() == 2 ? Component.m_237115_((String)"entity.doom.possessedengineer") : super.m_7770_());
    }

    public float getClientFuseTime(float timeDelta) {
        return Mth.m_14179_((float)timeDelta, (float)this.lastFuseTime, (float)this.currentFuseTime) / (float)(this.fuseTime - 2);
    }

    public int getFuseSpeed() {
        return (Integer)this.f_19804_.m_135370_(FUSE_SPEED);
    }

    public void setFuseSpeed(int fuseSpeed) {
        this.f_19804_.m_135381_(FUSE_SPEED, (Object)fuseSpeed);
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(IGNITED, (Object)true);
    }
}

