/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.projectiles.entity;

import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.util.registry.DoomEntities;
import mod.azure.doom.util.registry.DoomSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BloodBoltEntity
extends AbstractHurtingProjectile
implements IAnimatable {
    protected int timeInAir;
    protected boolean inAir;
    private int ticksInAir;
    private float directHitDamage = 2.0f;
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public BloodBoltEntity(EntityType<BloodBoltEntity> entity, Level world) {
        super(entity, world);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public BloodBoltEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ, float directHitDamage) {
        super((EntityType)DoomEntities.BLOODBOLT_MOB.get(), shooter, accelX, accelY, accelZ, worldIn);
        this.directHitDamage = directHitDamage;
    }

    public BloodBoltEntity(Level worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType)DoomEntities.BLOODBOLT_MOB.get(), x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        this.ticksInAir = 0;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("life", (short)this.ticksInAir);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksInAir = compound.m_128448_("life");
    }

    public void setDirectHitDamage(float directHitDamage) {
        this.directHitDamage = directHitDamage;
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123760_;
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19853_.m_7106_(this.m_5967_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
    }

    public boolean m_6060_() {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_20068_() {
        return !this.m_20069_();
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        super.m_5790_(p_213868_1_);
        if (!this.f_19853_.f_46443_) {
            Entity entity = p_213868_1_.m_82443_();
            Entity entity1 = this.m_37282_();
            if (!(entity instanceof DemonEntity)) {
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)((LivingEntity)entity1)), this.directHitDamage);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            if (entity1 instanceof LivingEntity && !(entity instanceof DemonEntity)) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
        this.m_5496_((SoundEvent)DoomSounds.UNMAKYR_FIRE.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }
}

